/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.StateMachineType;
import com.prosysopc.ua.types.opcua.StateVariableType;
import com.prosysopc.ua.types.opcua.TransitionVariableType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2299")
public abstract class StateMachineTypeImplBase
extends BaseObjectTypeImpl
implements StateMachineType {
    protected StateMachineTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public TransitionVariableType getLastTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastTransition");
        return (TransitionVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLastTransition() {
        TransitionVariableType transitionVariableType = this.getLastTransitionNode();
        if (transitionVariableType == null) {
            return null;
        }
        Object object = transitionVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLastTransition(LocalizedText localizedText) throws StatusException {
        TransitionVariableType transitionVariableType = this.getLastTransitionNode();
        if (transitionVariableType == null) {
            throw new RuntimeException("Setting LastTransition failed, the Optional node does not exist)");
        }
        transitionVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public StateVariableType getCurrentStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentState");
        return (StateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getCurrentState() {
        StateVariableType stateVariableType = this.getCurrentStateNode();
        if (stateVariableType == null) {
            return null;
        }
        Object object = stateVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText localizedText) throws StatusException {
        StateVariableType stateVariableType = this.getCurrentStateNode();
        if (stateVariableType == null) {
            throw new RuntimeException("Setting CurrentState failed, the Optional node does not exist)");
        }
        stateVariableType.setValue(localizedText);
    }
}

