/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.ShelvedStateMachineType;
import com.prosysopc.ua.types.opcua.client.FiniteStateMachineTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2929")
public abstract class ShelvedStateMachineTypeImplBase
extends FiniteStateMachineTypeImpl
implements ShelvedStateMachineType {
    protected ShelvedStateMachineTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getUnshelveTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnshelveTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getUnshelveTime() {
        UaProperty uaProperty = this.getUnshelveTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setUnshelveTime(Double d2) throws StatusException {
        UaProperty uaProperty = this.getUnshelveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UnshelveTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaMethod getTimedShelveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void timedShelve(Double d2) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve"));
        this.call(nodeId, d2);
    }

    public AsyncResult<Void> timedShelveAsync(Double d2) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, d2);
    }

    @Override
    @Mandatory
    public UaMethod getUnshelveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void unshelve() throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve"));
        this.call(nodeId, new Object[0]);
    }

    public AsyncResult<Void> unshelveAsync() {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, new Object[0]);
    }

    @Override
    @Optional
    public UaMethod getTimedShelve2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void timedShelve2(Double d2, LocalizedText localizedText) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve2"));
        this.call(nodeId, d2, localizedText);
    }

    public AsyncResult<Void> timedShelve2Async(Double d2, LocalizedText localizedText) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve2"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, d2, localizedText);
    }

    @Override
    @Mandatory
    public UaMethod getOneShotShelveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void oneShotShelve() throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve"));
        this.call(nodeId, new Object[0]);
    }

    public AsyncResult<Void> oneShotShelveAsync() {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, new Object[0]);
    }

    @Override
    @Optional
    public UaMethod getUnshelve2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void unshelve2(LocalizedText localizedText) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve2"));
        this.call(nodeId, localizedText);
    }

    public AsyncResult<Void> unshelve2Async(LocalizedText localizedText) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve2"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, localizedText);
    }

    @Override
    @Optional
    public UaMethod getOneShotShelve2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void oneShotShelve2(LocalizedText localizedText) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve2"));
        this.call(nodeId, localizedText);
    }

    public AsyncResult<Void> oneShotShelve2Async(LocalizedText localizedText) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve2"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, localizedText);
    }
}

