/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.OptionSetType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11487")
public abstract class OptionSetTypeImplBase
extends BaseDataVariableTypeImpl
implements OptionSetType {
    protected OptionSetTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getOptionSetValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OptionSetValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText[] getOptionSetValues() {
        UaProperty uaProperty = this.getOptionSetValuesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Mandatory
    public void setOptionSetValues(LocalizedText[] localizedTextArray) throws StatusException {
        UaProperty uaProperty = this.getOptionSetValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OptionSetValues failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedTextArray);
    }

    @Override
    @Optional
    public UaProperty getBitMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BitMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean[] isBitMask() {
        UaProperty uaProperty = this.getBitMaskNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean[])object;
    }

    @Override
    @Optional
    public void setBitMask(Boolean[] booleanArray) throws StatusException {
        UaProperty uaProperty = this.getBitMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BitMask failed, the Optional node does not exist)");
        }
        uaProperty.setValue(booleanArray);
    }
}

