/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.core.DataSetFieldContentMask;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.types.opcua.DataSetWriterMessageType;
import com.prosysopc.ua.types.opcua.DataSetWriterTransportType;
import com.prosysopc.ua.types.opcua.DataSetWriterType;
import com.prosysopc.ua.types.opcua.PubSubDiagnosticsDataSetWriterType;
import com.prosysopc.ua.types.opcua.PubSubStatusType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15298")
public abstract class DataSetWriterTypeImplBase
extends BaseObjectTypeImpl
implements DataSetWriterType {
    protected DataSetWriterTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getKeyFrameCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "KeyFrameCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getKeyFrameCount() {
        UaProperty uaProperty = this.getKeyFrameCountNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setKeyFrameCount(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getKeyFrameCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting KeyFrameCount failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetFieldContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetFieldContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetFieldContentMask getDataSetFieldContentMask() {
        UaProperty uaProperty = this.getDataSetFieldContentMaskNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DataSetFieldContentMask)object;
    }

    @Override
    @Mandatory
    public void setDataSetFieldContentMask(DataSetFieldContentMask dataSetFieldContentMask) throws StatusException {
        UaProperty uaProperty = this.getDataSetFieldContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetFieldContentMask failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dataSetFieldContentMask);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetWriterIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetWriterId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getDataSetWriterId() {
        UaProperty uaProperty = this.getDataSetWriterIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setDataSetWriterId(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getDataSetWriterIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetWriterId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedShort);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetWriterPropertiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetWriterProperties");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public KeyValuePair[] getDataSetWriterProperties() {
        UaProperty uaProperty = this.getDataSetWriterPropertiesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (KeyValuePair[])object;
    }

    @Override
    @Mandatory
    public void setDataSetWriterProperties(KeyValuePair[] keyValuePairArray) throws StatusException {
        UaProperty uaProperty = this.getDataSetWriterPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetWriterProperties failed, the Optional node does not exist)");
        }
        uaProperty.setValue(keyValuePairArray);
    }

    @Override
    @Optional
    public DataSetWriterMessageType getMessageSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageSettings");
        return (DataSetWriterMessageType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public PubSubStatusType getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return (PubSubStatusType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public DataSetWriterTransportType getTransportSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportSettings");
        return (DataSetWriterTransportType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public PubSubDiagnosticsDataSetWriterType getDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Diagnostics");
        return (PubSubDiagnosticsDataSetWriterType)this.getComponent(qualifiedName);
    }
}

