/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.ConditionVariableType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=9002")
public abstract class ConditionVariableTypeImplBase
extends BaseDataVariableTypeImpl
implements ConditionVariableType {
    protected ConditionVariableTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getSourceTimestampNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceTimestamp");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getSourceTimestamp() {
        UaProperty uaProperty = this.getSourceTimestampNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setSourceTimestamp(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getSourceTimestampNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SourceTimestamp failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }
}

