/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.types.opcua.BaseAnalogType;
import com.prosysopc.ua.types.opcua.client.DataItemTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15318")
public abstract class BaseAnalogTypeImplBase
extends DataItemTypeImpl
implements BaseAnalogType {
    protected BaseAnalogTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getEngineeringUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EngineeringUnits");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EUInformation getEngineeringUnits() {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Optional
    public void setEngineeringUnits(EUInformation eUInformation) throws StatusException {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EngineeringUnits failed, the Optional node does not exist)");
        }
        uaProperty.setValue(eUInformation);
    }

    @Override
    @Optional
    public UaProperty getEURangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EURange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Range getEURange() {
        UaProperty uaProperty = this.getEURangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Optional
    public void setEURange(Range range) throws StatusException {
        UaProperty uaProperty = this.getEURangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EURange failed, the Optional node does not exist)");
        }
        uaProperty.setValue(range);
    }

    @Override
    @Optional
    public UaProperty getInstrumentRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InstrumentRange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Range getInstrumentRange() {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Optional
    public void setInstrumentRange(Range range) throws StatusException {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InstrumentRange failed, the Optional node does not exist)");
        }
        uaProperty.setValue(range);
    }
}

