/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua;

import com.prosysopc.ua.MethodOutputArguments;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import com.prosysopc.ua.types.opcua.PubSubKeyPushTargetFolderType;
import com.prosysopc.ua.types.opcua.SecurityGroupFolderType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15906")
public interface PubSubKeyServiceType
extends BaseObjectType {
    public static final String SECURITY_GROUPS = "SecurityGroups";
    public static final String KEY_PUSH_TARGETS = "KeyPushTargets";
    public static final String GET_SECURITY_GROUP = "GetSecurityGroup";
    public static final String GET_SECURITY_KEYS = "GetSecurityKeys";

    @Optional
    public SecurityGroupFolderType getSecurityGroupsNode();

    @Optional
    public PubSubKeyPushTargetFolderType getKeyPushTargetsNode();

    @Optional
    public UaMethod getGetSecurityGroupNode();

    public NodeId getSecurityGroup(String var1) throws StatusException, ServiceException;

    @Optional
    public UaMethod getGetSecurityKeysNode();

    public GetSecurityKeysMethodOutputs getSecurityKeys(String var1, UnsignedInteger var2, UnsignedInteger var3) throws StatusException, ServiceException;

    public static class GetSecurityKeysMethodOutputs
    implements MethodOutputArguments {
        protected String f_securityPolicyUri;
        protected UnsignedInteger f_firstTokenId;
        protected ByteString[] f_keys;
        protected Double f_timeToNextKey;
        protected Double f_keyLifetime;

        public GetSecurityKeysMethodOutputs(String string, UnsignedInteger unsignedInteger, ByteString[] byteStringArray, Double d2, Double d3) {
            this.f_securityPolicyUri = string;
            this.f_firstTokenId = unsignedInteger;
            this.f_keys = byteStringArray;
            this.f_timeToNextKey = d2;
            this.f_keyLifetime = d3;
        }

        public String getSecurityPolicyUri() {
            return this.f_securityPolicyUri;
        }

        public UnsignedInteger getFirstTokenId() {
            return this.f_firstTokenId;
        }

        public ByteString[] getKeys() {
            return this.f_keys;
        }

        public Double getTimeToNextKey() {
            return this.f_timeToNextKey;
        }

        public Double getKeyLifetime() {
            return this.f_keyLifetime;
        }

        @Override
        public final Variant[] asVariantArray() {
            return new Variant[]{new Variant(this.f_securityPolicyUri), new Variant(this.f_firstTokenId), new Variant(this.f_keys), new Variant(this.f_timeToNextKey), new Variant(this.f_keyLifetime)};
        }
    }
}

