/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.types.opcua.ConditionType;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2881")
public interface AcknowledgeableConditionType
extends ConditionType {
    public static final String ENABLED_STATE = "EnabledState";
    public static final String ACKED_STATE = "AckedState";
    public static final String CONFIRMED_STATE = "ConfirmedState";
    public static final String CONFIRM = "Confirm";
    public static final String ACKNOWLEDGE = "Acknowledge";

    @Override
    @Mandatory
    public TwoStateVariableType getEnabledStateNode();

    @Override
    @Mandatory
    public LocalizedText getEnabledState();

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText var1) throws StatusException;

    @Mandatory
    public TwoStateVariableType getAckedStateNode();

    @Mandatory
    public LocalizedText getAckedState();

    @Mandatory
    public void setAckedState(LocalizedText var1) throws StatusException;

    @Optional
    public TwoStateVariableType getConfirmedStateNode();

    @Optional
    public LocalizedText getConfirmedState();

    @Optional
    public void setConfirmedState(LocalizedText var1) throws StatusException;

    @Optional
    public UaMethod getConfirmNode();

    public void confirm(ByteString var1, LocalizedText var2) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getAcknowledgeNode();

    public void acknowledge(ByteString var1, LocalizedText var2) throws StatusException, ServiceException;
}

