/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.gds.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.types.gds.AuthorizationServiceType;
import com.prosysopc.ua.types.gds.server.AuthorizationServiceTypeGetServiceDescriptionMethod;
import com.prosysopc.ua.types.gds.server.AuthorizationServiceTypeNode;
import com.prosysopc.ua.types.gds.server.AuthorizationServiceTypeRequestAccessTokenMethod;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/GDS/;i=966")
public abstract class AuthorizationServiceTypeNodeBase
extends BaseObjectTypeNode
implements AuthorizationServiceType {
    private static GeneratedNodeInitializer<AuthorizationServiceTypeNode> Ek;
    private static AuthorizationServiceTypeGetServiceDescriptionMethod El;
    private static AuthorizationServiceTypeRequestAccessTokenMethod Em;

    protected AuthorizationServiceTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuthorizationServiceTypeNode> generatedNodeInitializer = AuthorizationServiceTypeNodeBase.getAuthorizationServiceTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuthorizationServiceTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuthorizationServiceTypeNode> getAuthorizationServiceTypeNodeInitializer() {
        return Ek;
    }

    public static void setAuthorizationServiceTypeNodeInitializer(GeneratedNodeInitializer<AuthorizationServiceTypeNode> generatedNodeInitializer) {
        Ek = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getServiceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "ServiceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getServiceUri() {
        UaProperty uaProperty = this.getServiceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServiceUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setServiceUri(String string) {
        UaProperty uaProperty = this.getServiceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServiceUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getServiceCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "ServiceCertificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getServiceCertificate() {
        UaProperty uaProperty = this.getServiceCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServiceCertificate does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setServiceCertificate(ByteString byteString) {
        UaProperty uaProperty = this.getServiceCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceCertificate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServiceCertificate failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getUserTokenPoliciesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "UserTokenPolicies");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UserTokenPolicy[] getUserTokenPolicies() {
        UaProperty uaProperty = this.getUserTokenPoliciesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UserTokenPolicy[])object;
    }

    @Override
    @Optional
    public void setUserTokenPolicies(UserTokenPolicy[] userTokenPolicyArray) {
        UaProperty uaProperty = this.getUserTokenPoliciesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UserTokenPolicies failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(userTokenPolicyArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UserTokenPolicies failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "GetServiceDescription"), nodeId)) {
            return this.a(serviceContext).asVariantArray();
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "RequestAccessToken"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (UserIdentityToken)variantArray[0].getValue(), (String)variantArray[1].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getGetServiceDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "GetServiceDescription");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract AuthorizationServiceType.GetServiceDescriptionMethodOutputs onGetServiceDescription(ServiceContext var1) throws StatusException;

    @Override
    public AuthorizationServiceType.GetServiceDescriptionMethodOutputs getServiceDescription() throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private AuthorizationServiceType.GetServiceDescriptionMethodOutputs a(ServiceContext serviceContext) throws StatusException {
        AuthorizationServiceTypeGetServiceDescriptionMethod authorizationServiceTypeGetServiceDescriptionMethod = AuthorizationServiceTypeNodeBase.getGetServiceDescriptionMethodImplementation();
        if (authorizationServiceTypeGetServiceDescriptionMethod != null) {
            return authorizationServiceTypeGetServiceDescriptionMethod.getServiceDescription(serviceContext, (AuthorizationServiceTypeNode)this);
        }
        return this.onGetServiceDescription(serviceContext);
    }

    public static AuthorizationServiceTypeGetServiceDescriptionMethod getGetServiceDescriptionMethodImplementation() {
        return El;
    }

    public static void setGetServiceDescriptionMethodImplementation(AuthorizationServiceTypeGetServiceDescriptionMethod authorizationServiceTypeGetServiceDescriptionMethod) {
        El = authorizationServiceTypeGetServiceDescriptionMethod;
    }

    @Override
    @Optional
    public UaMethod getRequestAccessTokenNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "RequestAccessToken");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract String onRequestAccessToken(ServiceContext var1, UserIdentityToken var2, String var3) throws StatusException;

    @Override
    public String requestAccessToken(UserIdentityToken userIdentityToken, String string) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, userIdentityToken, string);
    }

    private String a(ServiceContext serviceContext, UserIdentityToken userIdentityToken, String string) throws StatusException {
        AuthorizationServiceTypeRequestAccessTokenMethod authorizationServiceTypeRequestAccessTokenMethod = AuthorizationServiceTypeNodeBase.getRequestAccessTokenMethodImplementation();
        if (authorizationServiceTypeRequestAccessTokenMethod != null) {
            return authorizationServiceTypeRequestAccessTokenMethod.requestAccessToken(serviceContext, (AuthorizationServiceTypeNode)this, userIdentityToken, string);
        }
        return this.onRequestAccessToken(serviceContext, userIdentityToken, string);
    }

    public static AuthorizationServiceTypeRequestAccessTokenMethod getRequestAccessTokenMethodImplementation() {
        return Em;
    }

    public static void setRequestAccessTokenMethodImplementation(AuthorizationServiceTypeRequestAccessTokenMethod authorizationServiceTypeRequestAccessTokenMethod) {
        Em = authorizationServiceTypeRequestAccessTokenMethod;
    }
}

