/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.asyncsocket;

import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.State;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSelector
implements Runnable {
    private static final EnumSet<a> BE = EnumSet.of(a.BK);
    private static final Logger logger = LoggerFactory.getLogger(AsyncSelector.class);
    State<a> BF = new State<a>(a.BK);
    Selector BG;
    Map<SelectionKey, SelectListener> map = new ConcurrentHashMap<SelectionKey, SelectListener>();
    Thread thread;
    Object BH = new Object();

    private static int b(Set<Interests> set) {
        int n2 = 0;
        for (Interests interests : set) {
            n2 |= interests.BI;
        }
        return n2;
    }

    private static Set<Interests> z(int n2) {
        EnumSet<Interests> enumSet = EnumSet.noneOf(Interests.class);
        if ((n2 & 0x10) != 0) {
            enumSet.add(Interests.ACCEPT);
        }
        if ((n2 & 8) != 0) {
            enumSet.add(Interests.CONNECT);
        }
        if ((n2 & 1) != 0) {
            enumSet.add(Interests.READ);
        }
        if ((n2 & 4) != 0) {
            enumSet.add(Interests.WRITE);
        }
        return enumSet;
    }

    public AsyncSelector() throws IOException {
        this(Selector.open());
    }

    public AsyncSelector(Selector selector) throws IOException {
        this.BG = selector;
        this.thread = new Thread((Runnable)this, StackUtils.SELECTOR_NAME_PATTERN);
        this.thread.setDaemon(true);
        Integer n2 = StackUtils.getAsyncSelectorThreadPriority();
        if (n2 != null) {
            this.thread.setPriority(n2);
        }
        this.thread.start();
    }

    public void close() throws IOException {
        this.BG.close();
        try {
            this.BF.setState(a.BK);
            this.BG.wakeup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Selector getSelector() {
        return this.BG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestOps(SelectableChannel selectableChannel, int n2) throws CancelledKeyException {
        if (selectableChannel != null) {
            SelectionKey selectionKey = selectableChannel.keyFor(this.BG);
            if (selectionKey == null) {
                throw new IllegalArgumentException("Key is not registered to channel");
            }
            if (!selectionKey.isValid()) {
                return;
            }
            SelectableChannel selectableChannel2 = selectableChannel;
            synchronized (selectableChannel2) {
                int n3 = selectionKey.interestOps();
                switch (n2) {
                    case -9: 
                    case -5: 
                    case -2: {
                        n3 &= n2;
                        break;
                    }
                    default: {
                        n3 |= n2;
                    }
                }
                if (n3 != selectionKey.interestOps()) {
                    selectionKey.interestOps(n3);
                    this.BG.wakeup();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SelectableChannel selectableChannel, int n2, SelectListener selectListener) throws ClosedChannelException {
        Object object = this.BH;
        synchronized (object) {
            this.disable();
            try {
                SelectionKey selectionKey = selectableChannel.register(this.BG, n2);
                this.map.put(selectionKey, selectListener);
            }
            finally {
                this.enable();
            }
        }
    }

    @Override
    public void run() {
        try {
            while (this.BG.isOpen()) {
                this.BF.waitForStateUninterruptibly(BE);
                this.BG.select(1000L);
                Set<SelectionKey> set = this.BG.selectedKeys();
                for (SelectionKey selectionKey : set) {
                    try {
                        Integer n2 = selectionKey.interestOps();
                        int n3 = selectionKey.readyOps();
                        SelectListener selectListener = this.map.get(selectionKey);
                        if (selectListener == null) continue;
                        selectListener.onSelected(this, selectionKey.channel(), n3, n2);
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
                set.clear();
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
        }
        catch (IOException iOException) {
            logger.error("Got IOException while selecting", (Throwable)iOException);
            throw new Error(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(SelectableChannel selectableChannel) {
        SelectionKey selectionKey = selectableChannel.keyFor(this.BG);
        if (selectionKey == null || !this.map.containsKey(selectionKey)) {
            return;
        }
        Object object = this.BH;
        synchronized (object) {
            this.disable();
            try {
                selectionKey.cancel();
                this.map.remove(selectionKey);
            }
            finally {
                this.enable();
            }
        }
    }

    private void disable() {
        this.BF.setState(a.BL);
        this.BG.wakeup();
    }

    private void enable() {
        this.BF.setState(a.BK);
    }

    String A(int n2) {
        String string = "[";
        if ((n2 & 1) != 0) {
            string = string + "read";
        }
        if ((n2 & 8) != 0) {
            string = string + "connect";
        }
        if ((n2 & 4) != 0) {
            string = string + "write";
        }
        if ((n2 & 0x10) != 0) {
            string = string + "accept";
        }
        return string + "]";
    }

    private static enum a {
        BK,
        BL;

    }

    public static interface SelectListener {
        public void onSelected(AsyncSelector var1, SelectableChannel var2, int var3, int var4);
    }

    public static enum Interests {
        READ(1),
        WRITE(4),
        CONNECT(8),
        ACCEPT(16);

        private final int BI;

        private Interests(int n3) {
            this.BI = n3;
        }
    }
}

