/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.utils.EncodingLimitsExceededIoException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class LimitedByteArrayOutputStream
extends OutputStream {
    private final ByteArrayOutputStream AW;
    private final int limit;

    public static LimitedByteArrayOutputStream withSizeLimit(int n2) {
        return new LimitedByteArrayOutputStream(n2);
    }

    private LimitedByteArrayOutputStream(int n2) {
        this.limit = n2;
        this.AW = new ByteArrayOutputStream();
    }

    public void reset() {
        this.AW.reset();
    }

    public byte[] toByteArray() {
        return this.AW.toByteArray();
    }

    public String toString() {
        return ByteString.from(this.AW).toHex();
    }

    @Override
    public void write(byte[] byArray) throws EncodingLimitsExceededIoException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws EncodingLimitsExceededIoException {
        if (this.AW.size() >= this.limit - n3) {
            throw new EncodingLimitsExceededIoException("Stream size is " + this.AW.size() + " limit is " + this.limit + ", cannot write " + n3 + " bytes");
        }
        this.AW.write(byArray, n2, n3);
    }

    @Override
    public void write(int n2) throws EncodingLimitsExceededIoException {
        if (this.AW.size() >= this.limit) {
            throw new EncodingLimitsExceededIoException("Stream is at max capasity, " + this.limit + ", cannot write more.");
        }
        this.AW.write(n2);
    }
}

