/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BijectionMap<L, R> {
    private Map<L, R> AH = new HashMap<L, R>();
    private Map<R, L> AI = new HashMap<R, L>();

    public void addAll(BijectionMap<L, R> bijectionMap) {
        for (Map.Entry<L, R> entry : bijectionMap.getEntries()) {
            this.map(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.AH.clear();
        this.AI.clear();
    }

    public boolean contains(L l2, R r2) {
        if (l2 == r2) {
            return true;
        }
        if (l2 == null || r2 == null) {
            return false;
        }
        R r3 = this.AH.get(l2);
        if (r3 == r2) {
            return true;
        }
        return this.AH.get(l2).equals(r3);
    }

    public boolean containsLeft(L l2) {
        return this.AH.containsKey(l2);
    }

    public boolean containsRight(R r2) {
        return this.AI.containsKey(r2);
    }

    public Set<Map.Entry<L, R>> getEntries() {
        return this.AH.entrySet();
    }

    public L getLeft(R r2) {
        return this.AI.get(r2);
    }

    public Set<L> getLeftSet() {
        return Collections.unmodifiableSet(this.AH.keySet());
    }

    public R getRight(L l2) {
        return this.AH.get(l2);
    }

    public Set<R> getRightSet() {
        return Collections.unmodifiableSet(this.AI.keySet());
    }

    public boolean isEmpty() {
        return this.AH.isEmpty();
    }

    public void map(L l2, R r2) {
        R r3 = this.AH.remove(l2);
        if (r3 != null) {
            this.AI.remove(r3);
        } else {
            L l3 = this.AI.remove(r2);
            if (l3 != null) {
                this.AH.remove(l3);
            }
        }
        this.AH.put(l2, r2);
        this.AI.put(r2, l2);
    }

    public R removeWithLeft(L l2) {
        R r2 = this.AH.remove(l2);
        if (r2 != null) {
            this.AI.remove(r2);
        }
        return r2;
    }

    public L removeWithRight(R r2) {
        L l2 = this.AI.remove(r2);
        if (l2 != null) {
            this.AH.remove(l2);
        }
        return l2;
    }

    public boolean retainAllLeft(Collection<L> collection) {
        boolean bl = false;
        for (L l2 : collection) {
            if (this.AH.containsKey(l2)) continue;
            this.removeWithLeft(l2);
            bl = true;
        }
        return bl;
    }

    public boolean retainAllRight(Collection<R> collection) {
        boolean bl = false;
        for (R r2 : collection) {
            if (this.AI.containsKey(r2)) continue;
            this.removeWithRight(r2);
            bl = true;
        }
        return bl;
    }

    public int size() {
        return this.AH.size();
    }

    public String toString() {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Map.Entry<L, R> entry : this.AH.entrySet()) {
            if (n2++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey().toString());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue().toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

