/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.function.CheckedBiConsumer;
import com.prosysopc.ua.function.CheckedFunctionRuntimeException;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.Union;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStructure
implements Structure {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStructure.class);
    public static final StructureSpecification SPECIFICATION = StructureSpecification.builder().setJavaClass(Structure.class).setName("Structure").setStructureType(StructureSpecification.StructureType.NORMAL).setAbstract(true).setTypeId(UaIds.Structure).build();
    private final StructureSpecification specification;
    private Object[] fieldValues;

    private static void validateField(StructureSpecification structureSpecification, FieldSpecification fieldSpecification) {
        if (fieldSpecification.getFieldIndex() >= structureSpecification.getFields().size() || !structureSpecification.getFields().get(fieldSpecification.getFieldIndex()).equals(fieldSpecification)) {
            throw new IllegalArgumentException("The " + structureSpecification + " of the Structure does not contain: " + fieldSpecification);
        }
    }

    private static FieldSpecification validateFieldNameAndGetSpec(StructureSpecification structureSpecification, String string) {
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            if (!fieldSpecification.getName().equals(string)) continue;
            return fieldSpecification;
        }
        throw new IllegalArgumentException("The Structure does not contain field named: " + string);
    }

    private static void validateFieldValue(FieldSpecification fieldSpecification, Object object) {
        if (object == null) {
            return;
        }
        if (!fieldSpecification.getJavaClass().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("For field:" + fieldSpecification + ", the given value:" + object + ", does not have correct type:" + fieldSpecification.getJavaClass() + ", instead it is:" + object.getClass());
        }
    }

    protected AbstractStructure(UaDataTypeSpecification uaDataTypeSpecification) {
        if (!(uaDataTypeSpecification instanceof StructureSpecification)) {
            throw new IllegalStateException("Expected StructureSpecification, but got: " + uaDataTypeSpecification);
        }
        this.specification = InternalArguments.checkNotNull((StructureSpecification)uaDataTypeSpecification, "specification");
        this.fieldValues = new Object[this.specification.getFields().size()];
    }

    @Override
    public void clear() {
        Arrays.fill(this.fieldValues, null);
    }

    @Override
    public AbstractStructure clone() {
        try {
            AbstractStructure abstractStructure = (AbstractStructure)super.clone();
            int n2 = this.fieldValues.length;
            abstractStructure.fieldValues = new Object[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                abstractStructure.fieldValues[i2] = StructureUtils.clone(this.fieldValues[i2]);
            }
            return abstractStructure;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error("Got a CloneNotSupportedException, should be impossible", (Throwable)cloneNotSupportedException);
            throw new Error("Every Structure implementation shall be Cloneable", cloneNotSupportedException);
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractStructure abstractStructure = (AbstractStructure)object;
        if (!this.specification.getTypeId().equals(abstractStructure.specification.getTypeId())) {
            return false;
        }
        return Arrays.deepEquals(this.fieldValues, abstractStructure.fieldValues);
    }

    @Override
    public <E extends Exception> void forEachField(CheckedBiConsumer<FieldSpecification, Object, E> checkedBiConsumer) throws E {
        Object[] objectArray = this.fieldValues;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            checkedBiConsumer.accept(this.specification.getFields().get(i2), objectArray[i2]);
        }
    }

    @Override
    public <E extends Exception> void forEachField(StructureSpecification structureSpecification, CheckedBiConsumer<FieldSpecification, Object, E> checkedBiConsumer) throws E {
        if (this.specification == structureSpecification || this.specification.getTypeId().equals(structureSpecification.getTypeId())) {
            this.forEachField(checkedBiConsumer);
            return;
        }
        try {
            this.toFieldsMap(structureSpecification).forEach(checkedBiConsumer.toBiConsumer());
        }
        catch (CheckedFunctionRuntimeException checkedFunctionRuntimeException) {
            Exception exception = (Exception)checkedFunctionRuntimeException.getCause();
            throw exception;
        }
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        AbstractStructure.validateField(this.specification, fieldSpecification);
        return this.indexGet(fieldSpecification.getFieldIndex());
    }

    @Override
    public Object get(String string) {
        return this.get(AbstractStructure.validateFieldNameAndGetSpec(this.specification, string));
    }

    public final int hashCode() {
        return Arrays.deepHashCode(this.fieldValues);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        AbstractStructure.validateField(this.specification, fieldSpecification);
        AbstractStructure.validateFieldValue(fieldSpecification, object);
        this.indexSet(object, fieldSpecification.getFieldIndex());
    }

    @Override
    public void set(String string, Object object) {
        this.set(AbstractStructure.validateFieldNameAndGetSpec(this.specification, string), object);
    }

    @Override
    public StructureSpecification specification() {
        return this.specification;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = (Builder)this.specification.toInstanceBuilder();
        for (int i2 = 0; i2 < this.fieldValues.length; ++i2) {
            ((Builder)builder).fieldValues[i2] = StructureUtils.clone(this.fieldValues[i2]);
        }
        return builder;
    }

    @Override
    public Map<String, Object> toFieldNamesMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.specification().getFields().size());
        this.toFieldsMap().forEach((fieldSpecification, object) -> linkedHashMap.put(fieldSpecification.getName(), object));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public Map<String, Object> toFieldNamesMap(StructureSpecification structureSpecification) {
        LinkedHashMap linkedHashMap = new LinkedHashMap(this.specification().getFields().size());
        this.toFieldsMap(structureSpecification).forEach((fieldSpecification, object) -> linkedHashMap.put(fieldSpecification.getName(), object));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap() {
        return StructureUtils.createFieldsMap(this.specification, this.fieldValues);
    }

    @Override
    public Map<FieldSpecification, Object> toFieldsMap(StructureSpecification structureSpecification) {
        if (structureSpecification == null) {
            throw new IllegalArgumentException("The given other StructureSpecification cannot be null");
        }
        StructureSpecification structureSpecification2 = this.specification();
        if (structureSpecification2 == structureSpecification || structureSpecification2.getTypeId().equals(structureSpecification.getTypeId())) {
            return this.toFieldsMap();
        }
        boolean bl = this.specification().getSuperTypeIds().contains(structureSpecification.getTypeId());
        boolean bl2 = structureSpecification.getSuperTypeIds().contains(this.specification().getTypeId());
        if (!bl && !bl2) {
            throw new IllegalArgumentException("The given other StructureSpecification is not a super nor a subtype, this: " + this.specification().getTypeId() + ", other: " + structureSpecification.getTypeId());
        }
        Map<FieldSpecification, Object> map = this.toFieldsMap();
        HashMap hashMap = new HashMap();
        map.forEach((fieldSpecification, object) -> hashMap.put(fieldSpecification.getName(), object));
        LinkedHashMap linkedHashMap = new LinkedHashMap(structureSpecification.getFields().size());
        structureSpecification.getFields().forEach(fieldSpecification -> linkedHashMap.put(fieldSpecification, hashMap.get(fieldSpecification.getName())));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.specification.getName());
        stringBuilder.append(" [");
        List<FieldSpecification> list = this.specification.getFields();
        for (int i2 = 0; i2 < this.fieldValues.length; ++i2) {
            FieldSpecification fieldSpecification = list.get(i2);
            Object object = this.fieldValues[i2];
            stringBuilder.append(fieldSpecification.getName());
            stringBuilder.append("=\"");
            if (object == null) {
                stringBuilder.append("null");
            } else if (object.getClass().isArray()) {
                stringBuilder.append(Arrays.deepToString((Object[])object));
            } else {
                stringBuilder.append(object);
            }
            if (i2 == list.size() - 1) {
                stringBuilder.append("\"");
                continue;
            }
            stringBuilder.append("\", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void initFieldsFromBuilder(Object[] objectArray) {
        System.arraycopy(objectArray, 0, this.fieldValues, 0, objectArray.length);
    }

    protected <T> T indexGet(int n2) {
        Object object = this.fieldValues[n2];
        return (T)object;
    }

    protected <T> void indexSet(T t2, int n2) {
        this.fieldValues[n2] = t2;
    }

    public static abstract class Builder
    implements Structure.Builder {
        private final StructureSpecification specification;
        private final Object[] fieldValues;
        private final Supplier<? extends Structure> emptyInstanceSupplier;

        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            if (!(uaDataTypeSpecification instanceof StructureSpecification)) {
                throw new IllegalStateException("Expected StructureSpecification, but got: " + uaDataTypeSpecification);
            }
            this.specification = InternalArguments.checkNotNull((StructureSpecification)uaDataTypeSpecification, "specification");
            this.emptyInstanceSupplier = supplier;
            this.fieldValues = new Object[this.specification.getFields().size()];
        }

        @Override
        public AbstractStructure build() {
            AbstractStructure abstractStructure = (AbstractStructure)this.emptyInstanceSupplier.get();
            if (abstractStructure instanceof Union) {
                for (int i2 = 0; i2 < this.fieldValues.length; ++i2) {
                    Object object = this.fieldValues[i2];
                    if (object == null) continue;
                    abstractStructure.indexSet(object, i2);
                    break;
                }
            } else {
                abstractStructure.initFieldsFromBuilder(this.fieldValues);
            }
            return abstractStructure;
        }

        @Override
        public Builder clear() {
            Arrays.fill(this.fieldValues, null);
            return this;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Builder builder = (Builder)object;
            if (!this.specification.getTypeId().equals(builder.specification.getTypeId())) {
                return false;
            }
            return Arrays.deepEquals(this.fieldValues, builder.fieldValues);
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            AbstractStructure.validateField(this.specification, fieldSpecification);
            return this.indexGet(fieldSpecification.getFieldIndex());
        }

        @Override
        public Object get(String string) {
            return this.get(AbstractStructure.validateFieldNameAndGetSpec(this.specification, string));
        }

        public final int hashCode() {
            return Arrays.deepHashCode(this.fieldValues);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            AbstractStructure.validateField(this.specification, fieldSpecification);
            AbstractStructure.validateFieldValue(fieldSpecification, object);
            this.indexSet(object, fieldSpecification.getFieldIndex());
            return this;
        }

        @Override
        public Builder set(String string, Object object) {
            return this.set(AbstractStructure.validateFieldNameAndGetSpec(this.specification, string), object);
        }

        @Override
        public StructureSpecification specification() {
            return this.specification;
        }

        public String toString() {
            StructureSpecification structureSpecification = this.specification();
            if (structureSpecification == null) {
                logger.warn("StructureSpecification is null, cannot do toString properly");
                return super.toString();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(structureSpecification.getName() + ".Builder");
            stringBuilder.append(" [");
            List<FieldSpecification> list = structureSpecification.getFields();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                FieldSpecification fieldSpecification = list.get(i2);
                stringBuilder.append(fieldSpecification.getName());
                stringBuilder.append("=\"");
                if (fieldSpecification.getValueRank() > 1) {
                    stringBuilder.append(Arrays.deepToString((Object[])this.get(fieldSpecification)));
                } else if (fieldSpecification.getValueRank() == 1) {
                    stringBuilder.append(Arrays.toString((Object[])this.get(fieldSpecification)));
                } else {
                    stringBuilder.append(this.get(fieldSpecification));
                }
                if (i2 == list.size() - 1) {
                    stringBuilder.append("\"");
                    continue;
                }
                stringBuilder.append("\", ");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        protected <T> T indexGet(int n2) {
            Object object = this.fieldValues[n2];
            return (T)object;
        }

        protected <T> void indexSet(T t2, int n2) {
            this.fieldValues[n2] = t2;
        }
    }
}

