/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ChannelSecurityToken;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.OpenSecureChannelResponse;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.transport.AsyncWrite;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.endpoint.AbstractServerSecureChannel;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.nio.InputMessage;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServerConnection;
import com.prosysopc.ua.stack.transport.tcp.nio.PendingRequest;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.EndpointUtil;
import com.prosysopc.ua.stack.utils.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcTcpServerSecureChannel
extends AbstractServerSecureChannel {
    static Logger logger = LoggerFactory.getLogger(OpcTcpServerSecureChannel.class);
    public SecurityConfiguration securityConfiguration;
    AtomicInteger An = new AtomicInteger();
    OpcTcpServerConnection Ao;
    public final AtomicInteger sendSequenceNumber = new AtomicInteger(ThreadLocalRandom.current().nextInt(1024));
    public final AtomicInteger recvSequenceNumber = new AtomicInteger();

    public OpcTcpServerSecureChannel(OpcTcpServerConnection opcTcpServerConnection, int n2) {
        super(n2);
        this.Ao = opcTcpServerConnection;
    }

    @Override
    public void dispose() {
    }

    @Override
    public OpcTcpServerConnection getConnection() {
        return this.Ao;
    }

    @Override
    public String getConnectURL() {
        return this.Ao.zD.endpointUrl;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.Ao.Ad.endpointAddress;
    }

    @Override
    public KeyPair getLocalCertificate() {
        return this.securityConfiguration.getLocalCertificate2();
    }

    @Override
    public void getPendingServiceRequests(Collection<EndpointServiceRequest<?, ?>> collection) {
        collection.addAll(this.Ao.wz.values());
    }

    @Override
    public Cert getRemoteCertificate() {
        return this.securityConfiguration.getRemoteCertificate2();
    }

    @Override
    public Server getServer() {
        return this.Ao.Ad.serviceServer;
    }

    @Override
    public boolean needsCertificate() {
        return this.getMessageSecurityMode() != MessageSecurityMode.None || EndpointUtil.containsSecureUserTokenPolicy(this.getServer().getUserTokenPolicies());
    }

    private SecurityToken a(OpenSecureChannelRequest openSecureChannelRequest, InputMessage inputMessage) throws ServiceResultException {
        ByteString byteString = openSecureChannelRequest.getClientNonce();
        int n2 = this.An.incrementAndGet();
        ByteString byteString2 = CryptoUtil.createNonce(this.securityConfiguration.getSecurityPolicy().getSecureChannelNonceLength());
        UnsignedInteger unsignedInteger = MessageSecurityMode.None.equals(openSecureChannelRequest.getSecurityMode()) ? UnsignedInteger.clamp(openSecureChannelRequest.getRequestedLifetime(), StackUtils.getSecurityTokenLifetimeMin(), UnsignedInteger.MAX_VALUE) : UnsignedInteger.clamp(openSecureChannelRequest.getRequestedLifetime(), StackUtils.getSecurityTokenLifetimeMin(), StackUtils.getSecurityTokenLifetimeMax());
        logger.debug("tokenLifetime: {}", (Object)unsignedInteger);
        SecurityToken securityToken = new SecurityToken(this.securityConfiguration, this.getSecureChannelId(), n2, System.currentTimeMillis(), unsignedInteger.longValue(), byteString2, byteString);
        this.tokens.put(n2, securityToken);
        return securityToken;
    }

    private void a(InputMessage inputMessage, SecurityToken securityToken, SecurityConfiguration securityConfiguration) throws ServiceResultException {
        boolean bl;
        ChannelSecurityToken channelSecurityToken = new ChannelSecurityToken();
        channelSecurityToken.setChannelId(UnsignedInteger.valueOf(this.getSecureChannelId()));
        channelSecurityToken.setCreatedAt(DateTime.currentTime());
        channelSecurityToken.setRevisedLifetime(UnsignedInteger.valueOf(securityToken.getLifeTime()));
        channelSecurityToken.setTokenId(UnsignedInteger.valueOf(securityToken.getTokenId()));
        this.setState(CloseableObjectState.Open);
        if (this.Ao.zF != null && this.Ao.zF != this) {
            IllegalStateException illegalStateException = new IllegalStateException("Internal error, connection already had another secure channel");
            logger.error("Internal error, connection already had another secure channel", (Throwable)illegalStateException);
            throw illegalStateException;
        }
        this.Ao.zF = this;
        OpenSecureChannelRequest openSecureChannelRequest = (OpenSecureChannelRequest)inputMessage.getMessage();
        OpenSecureChannelResponse openSecureChannelResponse = new OpenSecureChannelResponse();
        openSecureChannelResponse.setSecurityToken(channelSecurityToken);
        openSecureChannelResponse.setServerNonce(securityToken.getLocalNonce());
        openSecureChannelResponse.setServerProtocolVersion(UnsignedInteger.valueOf(this.Ao.zB));
        UnsignedInteger unsignedInteger = openSecureChannelRequest.getRequestHeader() == null ? null : openSecureChannelRequest.getRequestHeader().getRequestHandle();
        ResponseHeader responseHeader = new ResponseHeader();
        openSecureChannelResponse.setResponseHeader(responseHeader);
        responseHeader.setRequestHandle(unsignedInteger);
        AsyncWrite asyncWrite = new AsyncWrite(openSecureChannelResponse, null);
        boolean bl2 = bl = inputMessage.getMessageType() == 5132367 || inputMessage.getMessageType() == 5196867;
        if (bl) {
            this.Ao.sendAsymmSecureMessage(asyncWrite, securityConfiguration, securityToken.getSecureChannelId(), inputMessage.getRequestId(), this.sendSequenceNumber);
        } else {
            this.Ao.sendSecureMessage(asyncWrite, this.activeToken, inputMessage.getRequestId(), 4674381, this.sendSequenceNumber);
        }
    }

    protected Collection<PendingRequest> getPendingRequests2() {
        ArrayList<PendingRequest> arrayList = new ArrayList<PendingRequest>();
        for (PendingRequest pendingRequest : this.Ao.wz.values()) {
            if (pendingRequest.Ap != this) continue;
            arrayList.add(pendingRequest);
        }
        return arrayList;
    }

    protected void handleCloseSecureChannelRequest(InputMessage inputMessage, CloseSecureChannelRequest closeSecureChannelRequest) {
        this.close();
        this.Ao.close();
    }

    protected void handleOpenChannel(InputMessage inputMessage, OpenSecureChannelRequest openSecureChannelRequest) throws ServiceResultException {
        SecurityConfiguration securityConfiguration = (SecurityConfiguration)inputMessage.getToken();
        SecurityPolicy securityPolicy = securityConfiguration.getSecurityPolicy();
        MessageSecurityMode messageSecurityMode = openSecureChannelRequest.getSecurityMode();
        SecurityMode securityMode = new SecurityMode(securityPolicy, messageSecurityMode);
        KeyPair keyPair = null;
        Cert cert = securityConfiguration.getRemoteCertificate2();
        if (messageSecurityMode != MessageSecurityMode.None || EndpointUtil.containsSecureUserTokenPolicy(this.getServer().getUserTokenPolicies())) {
            keyPair = securityConfiguration.getLocalCertificate2();
        } else if (cert != null) {
            logger.debug("Client defines a certificate although SecurityPolicy.NONE is defined");
        }
        this.securityConfiguration = new SecurityConfiguration(securityMode, keyPair, cert);
        SecurityToken securityToken = this.a(openSecureChannelRequest, inputMessage);
        this.recvSequenceNumber.set(inputMessage.getSequenceNumbers().get(inputMessage.getSequenceNumbers().size() - 1) + 1);
        this.setState(CloseableObjectState.Opening);
        this.setActiveSecurityToken(securityToken);
        this.a(inputMessage, securityToken, this.securityConfiguration);
        logger.info("SecureChannel opened; {}", (Object)this.getActiveSecurityToken());
    }

    protected void handleRenewSecureChannelRequest(InputMessage inputMessage, OpenSecureChannelRequest openSecureChannelRequest) throws ServiceResultException {
        SecurityToken securityToken = this.a(openSecureChannelRequest, inputMessage);
        this.a(inputMessage, securityToken, (SecurityConfiguration)inputMessage.getToken());
        logger.info("SecureChannel renewed; {}", (Object)securityToken);
    }

    protected void handleSecureMessage(InputMessage inputMessage, IEncodeable iEncodeable) throws ServiceResultException {
        logger.debug("onSecureMessage: server={}", (Object)this.getServer());
        logger.debug("onSecureMessage: endpoint={}", (Object)this.getEndpoint());
        int n2 = inputMessage.getRequestId();
        PendingRequest pendingRequest = new PendingRequest(this, this.getEndpoint(), this.getServer(), inputMessage.getRequestId(), (ServiceRequest)iEncodeable);
        this.Ao.wz.put(n2, pendingRequest);
        this.getServer().getServiceHandlerComposition().serve(pendingRequest);
    }

    @Override
    protected synchronized void onStateTransition(CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        super.onStateTransition(closeableObjectState, closeableObjectState2);
        if (closeableObjectState2 == CloseableObjectState.Closed) {
            logger.info("Secure Channel closed, token={}", (Object)this.activeToken);
            this.Ao.fireSecureChannelDetached(this);
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_SecureChannelClosed);
            for (PendingRequest pendingRequest : this.getPendingRequests2()) {
                AsyncWrite asyncWrite = pendingRequest.wH;
                if (asyncWrite == null) continue;
                asyncWrite.attemptSetError(serviceResultException);
            }
        }
    }
}

