/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import javax.crypto.Mac;

public class SecurityToken {
    private SecurityConfiguration securityConfiguration;
    private int yn;
    private int vi;
    private long yo;
    private long yp;
    private ByteString yq;
    private ByteString yr;
    private byte[] ys;
    private byte[] yt;
    private byte[] yu;
    private byte[] yv;
    private byte[] yw;
    private byte[] yx;

    public SecurityToken(SecurityConfiguration securityConfiguration, int n2, int n3, long l2, long l3, ByteString byteString, ByteString byteString2) throws ServiceResultException {
        if (securityConfiguration == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.vi = n2;
        this.securityConfiguration = securityConfiguration;
        this.yn = n3;
        this.yp = l3;
        this.yo = l2;
        this.yq = byteString;
        this.yr = byteString2;
        boolean bl = securityConfiguration.getMessageSecurityMode() == MessageSecurityMode.None;
        int n4 = this.getSecurityPolicy().getSignatureKeySize();
        int n5 = this.getSecurityPolicy().getEncryptionKeySize();
        int n6 = this.getSecurityPolicy().getEncryptionBlockSize();
        this.ys = bl ? null : this.a(this.getRemoteNonce(), null, this.getLocalNonce(), 0, n4);
        this.yt = bl ? null : this.a(this.getRemoteNonce(), null, this.getLocalNonce(), n4, n5);
        this.yu = bl ? null : this.a(this.getRemoteNonce(), null, this.getLocalNonce(), n4 + n5, n6);
        this.yv = bl ? null : this.a(this.getLocalNonce(), null, this.getRemoteNonce(), 0, n4);
        this.yw = bl ? null : this.a(this.getLocalNonce(), null, this.getRemoteNonce(), n4, n5);
        this.yx = bl ? null : this.a(this.getLocalNonce(), null, this.getRemoteNonce(), n4 + n5, n6);
    }

    public Mac createLocalHmac() throws ServiceResultException {
        return this.createHmac(this.getLocalSigningKey());
    }

    public Mac createRemoteHmac() throws ServiceResultException {
        return this.createHmac(this.getRemoteSigningKey());
    }

    public long getCreationTime() {
        return this.yo;
    }

    public long getLifeTime() {
        return this.yp;
    }

    public byte[] getLocalEncryptingKey() {
        return this.yt;
    }

    public byte[] getLocalInitializationVector() {
        return this.yu;
    }

    public ByteString getLocalNonce() {
        return this.yq;
    }

    public byte[] getLocalSigningKey() {
        return this.ys;
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.securityConfiguration.getMessageSecurityMode();
    }

    public byte[] getRemoteEncryptingKey() {
        return this.yw;
    }

    public byte[] getRemoteInitializationVector() {
        return this.yx;
    }

    public ByteString getRemoteNonce() {
        return this.yr;
    }

    public byte[] getRemoteSigningKey() {
        return this.yv;
    }

    public long getRenewTime() {
        return this.yo + this.yp * 3L / 4L;
    }

    public int getSecureChannelId() {
        return this.vi;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityConfiguration.getSecurityPolicy();
    }

    public int getTokenId() {
        return this.yn;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.yo + this.yp;
    }

    public boolean isTimeToRenew() {
        return this.yo + this.yp * 3L / 4L < System.currentTimeMillis();
    }

    public boolean isValid() {
        return System.currentTimeMillis() < this.yo + this.yp + this.yp / 4L;
    }

    public void setLocalEncryptingKey(byte[] byArray) {
        this.yt = byArray;
    }

    public void setLocalInitializationVector(byte[] byArray) {
        this.yu = byArray;
    }

    public void setLocalSigningKey(byte[] byArray) {
        this.ys = byArray;
    }

    public void setRemoteEncryptingKey(byte[] byArray) {
        this.yw = byArray;
    }

    public void setRemoteInitializationVector(byte[] byArray) {
        this.yx = byArray;
    }

    public void setRemoteSigningKey(byte[] byArray) {
        this.yv = byArray;
    }

    public String toString() {
        return "SecurityToken(Id=" + this.yn + ", secureChannelId=" + this.vi + ", creationTime=" + Instant.ofEpochMilli(this.yo) + ", lifetime=" + this.yp + ")";
    }

    private byte[] a(ByteString byteString, String string, ByteString byteString2, int n2, int n3) throws ServiceResultException {
        Object object;
        byte[] byArray;
        if (byteString == null) {
            throw new IllegalArgumentException("ArgumentNullException: secret");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("ArgumentOutOfRangeException: offset");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("ArgumentOutOfRangeException: offset");
        }
        byte[] byArray2 = byArray = string != null && !string.isEmpty() ? string.getBytes(StandardCharsets.UTF_8) : null;
        if (byteString2 != null && byteString2.getLength() > 0) {
            if (byArray != null) {
                object = ByteBuffer.allocate(byArray.length + byteString2.getLength());
                ((ByteBuffer)object).put(byArray);
                ((ByteBuffer)object).put(byteString2.getValue());
                ((ByteBuffer)object).rewind();
                byArray = ((ByteBuffer)object).array();
            } else {
                byArray = byteString2.getValue();
            }
        }
        if (byArray == null) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "The PSHA algorithm requires a non-null seed.");
        }
        object = this.securityConfiguration.getSecurityPolicy();
        Mac mac = CryptoUtil.createMac(((SecurityPolicy)((Object)object)).getKeyDerivationAlgorithm(), byteString.getValue());
        mac.update(byArray);
        byte[] byArray3 = mac.doFinal();
        byte[] byArray4 = new byte[mac.getMacLength() + byArray.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        byte[] byArray5 = new byte[n3];
        int n4 = 0;
        do {
            mac.update(byArray4);
            byte[] byArray6 = mac.doFinal();
            if (n2 < byArray6.length) {
                for (int i2 = n2; n4 < n3 && i2 < byArray6.length; ++i2) {
                    byArray5[n4++] = byArray6[i2];
                }
            }
            n2 = n2 > byArray6.length ? (n2 -= byArray6.length) : 0;
            mac.update(byArray3);
            byArray3 = mac.doFinal();
            System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        } while (n4 < n3);
        return byArray5;
    }

    protected Mac createHmac(byte[] byArray) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.securityConfiguration.getSecurityPolicy();
        return CryptoUtil.createMac(securityPolicy.getSymmetricSignatureAlgorithm(), byArray);
    }
}

