/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum SecurityPolicy {
    NONE("http://opcfoundation.org/UA/SecurityPolicy#None", null, null, null, null, null, null, 0, 0, 0, 1, 1024, 2048, 0),
    BASIC128RSA15("http://opcfoundation.org/UA/SecurityPolicy#Basic128Rsa15", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.KwRsa15, SecurityAlgorithm.Rsa15, SecurityAlgorithm.PSha1, 20, 16, 16, 16, 1024, 2048, 16),
    BASIC256("http://opcfoundation.org/UA/SecurityPolicy#Basic256", SecurityAlgorithm.HmacSha1, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha1, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha1, 20, 24, 32, 16, 1024, 2048, 32),
    BASIC256SHA256("http://opcfoundation.org/UA/SecurityPolicy#Basic256Sha256", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha256, 32, 32, 32, 16, 2048, 4096, 32),
    AES128_SHA256_RSAOAEP("http://opcfoundation.org/UA/SecurityPolicy#Aes128_Sha256_RsaOaep", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes128, SecurityAlgorithm.RsaSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep, SecurityAlgorithm.PSha256, 32, 32, 16, 16, 2048, 4096, 32),
    AES256_SHA256_RSAPSS("http://opcfoundation.org/UA/SecurityPolicy#Aes256_Sha256_RsaPss", SecurityAlgorithm.HmacSha256, SecurityAlgorithm.Aes256, SecurityAlgorithm.RsaPssSha256, SecurityAlgorithm.KwRsaOaep, SecurityAlgorithm.RsaOaep256, SecurityAlgorithm.PSha256, 32, 32, 32, 16, 2048, 4096, 32);

    @Deprecated
    public static final Set<SecurityPolicy> ALL_SECURE_101;
    @Deprecated
    public static final Set<SecurityPolicy> ALL_SECURE_102;
    @Deprecated
    public static final Set<SecurityPolicy> ALL_SECURE_103;
    public static final Set<SecurityPolicy> ALL_SECURE_104;
    public static final Set<SecurityPolicy> ALL_SECURE_105;
    public static final SecurityPolicy[] EMPTY_ARRAY;
    private static Map<String, SecurityPolicy> xE;
    private final SecurityAlgorithm xF;
    private final SecurityAlgorithm xG;
    private final SecurityAlgorithm xH;
    private final byte[] xI;
    private final int xJ;
    private final int xK;
    private final SecurityAlgorithm xL;
    private final int xm;
    private final int xn;
    private final String xo;
    private final int xM;
    private final SecurityAlgorithm xN;
    private final SecurityAlgorithm xO;
    private final int xP;
    private final String jO;
    private final int xQ;

    @Deprecated
    public static SecurityPolicy[] getAllSecurityPolicies() {
        return SecurityPolicy.values();
    }

    public static SecurityPolicy getSecurityPolicy(String string) throws ServiceResultException {
        if (string == null || string.isEmpty()) {
            return NONE;
        }
        SecurityPolicy securityPolicy = xE.get(string);
        if (securityPolicy == null) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected);
        }
        return securityPolicy;
    }

    private static void a(SecurityPolicy securityPolicy) {
        xE.put(securityPolicy.xo, securityPolicy);
    }

    private SecurityPolicy(String string2, SecurityAlgorithm securityAlgorithm, SecurityAlgorithm securityAlgorithm2, SecurityAlgorithm securityAlgorithm3, SecurityAlgorithm securityAlgorithm4, SecurityAlgorithm securityAlgorithm5, SecurityAlgorithm securityAlgorithm6, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.xF = securityAlgorithm5;
        this.xG = securityAlgorithm4;
        this.xH = securityAlgorithm3;
        this.xL = securityAlgorithm6;
        this.xo = string2;
        this.xN = securityAlgorithm2;
        this.xO = securityAlgorithm;
        this.xI = string2.getBytes(StandardCharsets.UTF_8);
        this.xP = n3;
        this.xM = n4;
        this.xK = n5;
        this.xJ = n6;
        this.xn = n7;
        this.xm = n8;
        this.xQ = n9;
        this.jO = string2.substring(string2.indexOf("#") + 1, string2.length()).replace("_", "");
    }

    public SecurityAlgorithm getAsymmetricEncryptionAlgorithm() {
        return this.xF;
    }

    public SecurityAlgorithm getAsymmetricKeyWrapAlgorithm() {
        return this.xG;
    }

    public SecurityAlgorithm getAsymmetricSignatureAlgorithm() {
        return this.xH;
    }

    public String getDisplayName() {
        return this.jO;
    }

    public byte[] getEncodedPolicyUri() {
        return this.xI;
    }

    public int getEncryptionBlockSize() {
        return this.xJ;
    }

    public int getEncryptionKeySize() {
        return this.xK;
    }

    public SecurityAlgorithm getKeyDerivationAlgorithm() {
        return this.xL;
    }

    public int getMaxAsymmetricKeyLength() {
        return this.xm;
    }

    public int getMinAsymmetricKeyLength() {
        return this.xn;
    }

    public String getPolicyUri() {
        return this.xo;
    }

    public int getSecureChannelNonceLength() {
        return this.xQ;
    }

    public int getSignatureKeySize() {
        return this.xM;
    }

    public SecurityAlgorithm getSymmetricEncryptionAlgorithm() {
        return this.xN;
    }

    public SecurityAlgorithm getSymmetricSignatureAlgorithm() {
        return this.xO;
    }

    public int getSymmetricSignatureSize() {
        return this.xP;
    }

    public boolean isUsableWith(Cert cert) {
        int n2 = cert.getKeySize();
        return n2 >= this.xn && n2 <= this.xm;
    }

    public String toString() {
        return this.xo;
    }

    static {
        ALL_SECURE_101 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256));
        ALL_SECURE_102 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256, BASIC256SHA256));
        ALL_SECURE_103 = Collections.unmodifiableSet(EnumSet.of(BASIC128RSA15, BASIC256, BASIC256SHA256));
        ALL_SECURE_104 = Collections.unmodifiableSet(EnumSet.of(BASIC256SHA256, AES128_SHA256_RSAOAEP, AES256_SHA256_RSAPSS));
        ALL_SECURE_105 = Collections.unmodifiableSet(EnumSet.of(BASIC256SHA256, AES128_SHA256_RSAOAEP, AES256_SHA256_RSAPSS));
        EMPTY_ARRAY = new SecurityPolicy[0];
        xE = new ConcurrentHashMap<String, SecurityPolicy>();
        SecurityPolicy.a(NONE);
        SecurityPolicy.a(BASIC128RSA15);
        SecurityPolicy.a(BASIC256);
        SecurityPolicy.a(BASIC256SHA256);
        SecurityPolicy.a(AES128_SHA256_RSAOAEP);
        SecurityPolicy.a(AES256_SHA256_RSAPSS);
    }
}

