/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.security;

import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfiguration {
    public static final SecurityConfiguration NO_SECURITY;
    static Logger rm;
    SecurityMode xA;
    KeyPair xB = null;
    Cert xC = null;

    public SecurityConfiguration(SecurityMode securityMode, KeyPair keyPair, Cert cert) {
        if (securityMode == null) {
            throw new NullPointerException("SecurityMode mode is null");
        }
        this.xA = securityMode;
        if (securityMode.hasSigning()) {
            if (keyPair == null) {
                throw new NullPointerException("localApplicationInstanceCertificate is null");
            }
            this.xB = keyPair;
            if (cert == null) {
                throw new NullPointerException("remoteCertificate is null");
            }
            this.xC = cert;
        }
    }

    public byte[] getEncodedLocalCertificate() {
        if (this.xB == null) {
            return null;
        }
        return this.xB.getCertificate().getEncoded();
    }

    public byte[] getEncodedLocalCertificateThumbprint() {
        if (this.xB == null) {
            return null;
        }
        return this.xB.getCertificate().getEncodedThumbprint();
    }

    public byte[] getEncodedLocalPrivateKey() {
        if (this.xB == null) {
            return null;
        }
        return this.xB.getPrivateKey().getPrivateKey().getEncoded();
    }

    public byte[] getEncodedRemoteCertificate() {
        if (this.xC == null) {
            return null;
        }
        return this.xC.getEncoded();
    }

    public byte[] getEncodedRemoteCertificateThumbprint() {
        if (this.xC == null) {
            return null;
        }
        return this.xC.getEncodedThumbprint();
    }

    public Certificate getLocalCertificate() {
        if (this.xB == null) {
            return null;
        }
        return this.xB.getCertificate().getCertificate();
    }

    public KeyPair getLocalCertificate2() {
        return this.xB;
    }

    public RSAPrivateKey getLocalPrivateKey() {
        if (this.xB == null) {
            return null;
        }
        return this.xB.getPrivateKey().getPrivateKey();
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.xA.getMessageSecurityMode();
    }

    public Certificate getReceiverCertificate() {
        if (this.xC == null) {
            return null;
        }
        return this.xC.getCertificate();
    }

    public Certificate getRemoteCertificate() {
        if (this.xC == null) {
            return null;
        }
        return this.xC.getCertificate();
    }

    public Cert getRemoteCertificate2() {
        return this.xC;
    }

    public SecurityMode getSecurityMode() {
        return this.xA;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.xA.getSecurityPolicy();
    }

    static {
        rm = LoggerFactory.getLogger(SecurityConfiguration.class);
        NO_SECURITY = new SecurityConfiguration(SecurityMode.NONE, null, null);
    }
}

