/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.https.HttpsClient;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class a<T extends ServiceResponse>
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(a.class);
    HttpsClient vD;
    long vE = System.currentTimeMillis();
    long vF = 0L;
    int requestId;
    AsyncResultImpl<T> vG;
    ServiceRequest<T> vH;
    HttpPost vI;
    UnsignedInteger vJ = null;
    int vi;
    String vK;

    public a(HttpsClient httpsClient, ServiceRequest<T> serviceRequest) {
        long l2;
        this.vD = httpsClient;
        this.vH = serviceRequest;
        this.vG = new AsyncResultImpl();
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l3 = l2 = unsignedInteger != null ? unsignedInteger.longValue() : (long)httpsClient.getOperationTimeout();
        if (l2 != 0L) {
            this.vF = this.vE + l2;
        }
    }

    public void cancel() {
        if (this.vD.vv.remove(this.requestId) == null) {
            return;
        }
        this.vJ = StatusCodes.Bad_RequestCancelledByRequest;
        HttpPost httpPost = this.vI;
        if (httpPost != null) {
            httpPost.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            CloseableHttpResponse closeableHttpResponse;
            if (this.vJ != null) {
                this.vG.setError(new ServiceResultException(this.vJ));
                return;
            }
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(this.vD.vo);
            String string = inetSocketAddress.getHostName();
            int n2 = inetSocketAddress.getPort();
            String string2 = UriUtil.getTransportProtocol(this.vD.vo);
            HttpHost httpHost = new HttpHost(string, n2, string2);
            String string3 = this.vD.vn.getDescription().getEndpointUrl();
            String string4 = string3 == null ? "" : string3;
            this.vI = new HttpPost(string4);
            this.vI.addHeader("OPCUA-SecurityPolicy", this.vD.vu);
            this.vI.addHeader("Content-Type", "application/octet-stream");
            SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
            BinaryEncoder binaryEncoder = new BinaryEncoder(this.vD.vy, sizeCalculationOutputStream);
            InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, this.vH);
            int n3 = sizeCalculationOutputStream.getLength();
            int n4 = this.vD.vy.getMaxMessageSize();
            if (n4 != 0 && n3 > n4) {
                EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n4 + " < " + n3);
                logger.warn("run: failed", (Throwable)encodingException);
                throw encodingException;
            }
            byte[] byArray = new byte[n3];
            BinaryEncoder binaryEncoder2 = new BinaryEncoder(this.vD.vy, byArray);
            InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder2, this.vH);
            this.vI.setEntity((HttpEntity)new NByteArrayEntity(byArray));
            if (this.vJ != null) {
                this.vG.setError(new ServiceResultException(this.vJ));
                return;
            }
            try {
                closeableHttpResponse = this.vD.vt.execute(httpHost, (HttpRequest)this.vI);
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                this.vG.setError(new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, (Throwable)sSLPeerUnverifiedException, "Could not negotiate a TLS security cipher or the server did not provide a valid certificate."));
                this.vD.vv.remove(this.requestId);
                return;
            }
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            int n5 = closeableHttpResponse.getStatusLine().getStatusCode();
            if (n5 != 200) {
                UnsignedInteger unsignedInteger = StatusCodes.Bad_UnknownResponse;
                if (n5 == 501) {
                    unsignedInteger = StatusCodes.Bad_ServiceUnsupported;
                }
                String string5 = EntityUtils.toString((HttpEntity)httpEntity);
                this.vG.setError(new ServiceResultException(unsignedInteger, n5 + ": " + string5));
                return;
            }
            if (this.vJ != null) {
                this.vG.setError(new ServiceResultException(this.vJ));
                return;
            }
            byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
            BinaryDecoder binaryDecoder = new BinaryDecoder(this.vD.vy, byArray);
            IEncodeable iEncodeable = InternalBinaryEncodingsHelper.getMessage(binaryDecoder);
            if (iEncodeable instanceof ErrorMessage) {
                ErrorMessage errorMessage = (ErrorMessage)iEncodeable;
                ServiceResultException serviceResultException = new ServiceResultException(new StatusCode(errorMessage.getError()), errorMessage.getReason());
                this.vG.setError(serviceResultException);
                return;
            }
            try {
                ServiceResponse serviceResponse = (ServiceResponse)iEncodeable;
                this.vG.setResult(serviceResponse);
            }
            catch (ClassCastException classCastException) {
                this.vG.setError(new ServiceResultException(classCastException));
                logger.error("Cannot cast response to ServiceResponse, response=" + iEncodeable.getClass(), (Throwable)classCastException);
            }
        }
        catch (EncodingException encodingException) {
            this.vG.setError(new ServiceResultException(StatusCodes.Bad_EncodingError, (Throwable)encodingException));
        }
        catch (ClientProtocolException clientProtocolException) {
            this.vG.setError(new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)clientProtocolException));
        }
        catch (IOException iOException) {
            if (this.vJ != null) {
                this.vG.setError(new ServiceResultException(this.vJ, (Throwable)iOException));
            } else {
                this.vG.setError(new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException));
            }
        }
        catch (DecodingException decodingException) {
            this.vG.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, (Throwable)decodingException));
        }
        catch (ServiceResultException serviceResultException) {
            this.vG.setError(serviceResultException);
        }
        catch (RuntimeException runtimeException) {
            this.vG.setError(new ServiceResultException(runtimeException));
        }
        catch (StackOverflowError stackOverflowError) {
            this.vG.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, "Stack overflow: " + Arrays.toString(Arrays.copyOf(stackOverflowError.getStackTrace(), 30)) + "..."));
        }
        finally {
            this.vD.vv.remove(this.requestId);
        }
    }

    public void timeout() {
        if (this.vD.vv.remove(this.requestId) == null) {
            return;
        }
        this.vJ = StatusCodes.Bad_Timeout;
        HttpPost httpPost = this.vI;
        if (httpPost != null) {
            httpPost.abort();
        }
        this.vG.setError(new ServiceResultException(this.vJ));
    }
}

