/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.https.HttpsServer;
import com.prosysopc.ua.stack.transport.https.HttpsServerConnection;
import com.prosysopc.ua.stack.transport.https.HttpsServerSecureChannel;
import com.prosysopc.ua.stack.transport.https.b;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsServerEndpointHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HttpsServerEndpointHandler.class);
    EndpointBinding wo;
    HttpsServer wy;
    EndpointConfiguration gw;
    AtomicInteger vm = new AtomicInteger();
    Map<Integer, b> wz = new ConcurrentHashMap<Integer, b>();
    HttpsServerSecureChannel wA;

    public HttpsServerEndpointHandler(EndpointBinding endpointBinding) {
        this.wo = endpointBinding;
        this.wy = (HttpsServer)endpointBinding.endpointServer;
        this.gw = endpointBinding.endpointAddress.getEndpointConfiguration();
        this.wA = new HttpsServerSecureChannel(this, 1);
    }

    public EncoderContext getEncoderContext() {
        return this.wy.getEncoderContext();
    }

    @Override
    public void handle(HttpRequest httpRequest, HttpAsyncExchange httpAsyncExchange, HttpContext httpContext) throws HttpException, IOException {
        String string = httpRequest.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
        if (!string.equals("POST")) {
            throw new MethodNotSupportedException(string + " method not supported");
        }
        b b2 = new b(this, httpAsyncExchange, httpRequest, this.wA, this.vm.getAndIncrement());
        this.wz.put(b2.requestId, b2);
        NHttpServerConnection nHttpServerConnection = (NHttpServerConnection)httpContext.getAttribute("http.connection");
        logger.debug("handle: {} context={}: {}", new Object[]{nHttpServerConnection, nHttpServerConnection.getContext(), httpRequest});
        HttpsServerConnection httpsServerConnection = (HttpsServerConnection)this.wA.getConnection();
        if (httpsServerConnection == null || !nHttpServerConnection.equals(httpsServerConnection.getNHttpServerConnection())) {
            HttpsServerConnection httpsServerConnection2 = new HttpsServerConnection(this.wy, nHttpServerConnection);
            this.wA.setConnection(httpsServerConnection2);
            logger.info("HttpsServerEndpointHandler.handle(): singleSecureChannel.setConnection({})", (Object)nHttpServerConnection);
        }
        b2.run();
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        return new BasicAsyncRequestConsumer();
    }

    void a(CloseSecureChannelRequest closeSecureChannelRequest, b b2) throws ServiceResultException {
        b2.sendFault(ServiceFaultException.createServiceFault(StatusCodes.Bad_ServiceUnsupported));
    }

    void a(b b2) {
        Object Request = b2.getRequest();
        if (Request instanceof OpenSecureChannelRequest) {
            try {
                this.a((OpenSecureChannelRequest)Request, b2);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Channel: ", (Throwable)serviceResultException);
                b2.a(400, serviceResultException.getStatusCode().getValue(), serviceResultException.getMessage());
            }
        } else if (Request instanceof CloseSecureChannelRequest) {
            try {
                this.a((CloseSecureChannelRequest)Request, b2);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Channel: ", (Throwable)serviceResultException);
                b2.a(400, serviceResultException.getStatusCode().getValue(), serviceResultException.getMessage());
            }
        } else if (Request instanceof ServiceRequest) {
            try {
                this.a((ServiceRequest)Request, b2);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Channel: ", (Throwable)serviceResultException);
                b2.a(400, serviceResultException.getStatusCode().getValue(), serviceResultException.getMessage());
            }
        } else {
            String string = b2.getClass().getSimpleName() + " is not a ServiceRequest.";
            logger.info("Channel: {} {}", (Object)b2.getChannel().getSecureChannelId(), (Object)string);
            b2.a(400, StatusCodes.Bad_RequestTypeInvalid, string);
            return;
        }
    }

    void a(OpenSecureChannelRequest openSecureChannelRequest, b b2) throws ServiceResultException {
        b2.sendFault(ServiceFaultException.createServiceFault(StatusCodes.Bad_ServiceUnsupported));
    }

    void a(ServiceRequest serviceRequest, b b2) throws ServiceResultException {
        this.wo.serviceServer.getServiceHandlerComposition().serve(b2);
    }
}

