/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.https;

import com.prosysopc.ua.server.ReverseConnectionParameters;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Server;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.CloseableObject;
import com.prosysopc.ua.stack.transport.CloseableObjectState;
import com.prosysopc.ua.stack.transport.ConnectionMonitor;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.EndpointServer;
import com.prosysopc.ua.stack.transport.ServerConnection;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.https.HttpsServerConnection;
import com.prosysopc.ua.stack.transport.https.HttpsServerEndpointHandler;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.impl.ConnectionCollection;
import com.prosysopc.ua.stack.transport.security.CertValidatorTrustManager;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.AbstractState;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.asyncsocket.AsyncServerSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import org.apache.http.impl.nio.NHttpConnectionBase;
import org.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerResolver;
import org.apache.http.nio.protocol.HttpAsyncService;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ListenerEndpoint;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsServer
extends AbstractState<CloseableObjectState, ServiceResultException>
implements EndpointServer {
    static Logger rm = LoggerFactory.getLogger(HttpsServer.class);
    public static final HttpParams DEFAULT_HTTPPARAMS = new SyncBasicHttpParams().setIntParameter("http.socket.timeout", 0).setIntParameter("http.socket.buffer-size", 8192).setParameter("http.origin-server", (Object)"OpcUA/1.1").setParameter("http.useragent", (Object)"OpcUA/1.1");
    Application application;
    String[] vN;
    String[] vO;
    String[] vA;
    AtomicInteger vP = new AtomicInteger();
    AsyncServerSocket vQ;
    int vs;
    private boolean initialized = false;
    EndpointBindingCollection endpointBindings = new EndpointBindingCollection();
    ConnectionCollection vR = new ConnectionCollection(this);
    Thread vS;
    Thread vT;
    Semaphore vU;
    Semaphore vV;
    HttpAsyncService vW;
    ConnectionReuseStrategy vX;
    a vY;
    NHttpConnectionFactory<DefaultNHttpServerConnection> vZ;
    NHttpConnectionFactory<DefaultNHttpServerConnection> wa;
    SSLEngine wb;
    SSLSetupHandler wc;
    IOEventDispatch wd;
    IOEventDispatch we;
    ListeningIOReactor wf;
    IOReactorConfig wg;
    HttpsSecurityPolicy[] vp;
    Map<SocketAddress, SocketHandle> wh = new HashMap<SocketAddress, SocketHandle>();
    Server discoveryServer;
    HttpsServerEndpointHandler wi;
    private int wj = -1;

    public static TrustManager[] makeTrustManager(CertificateValidator ... certificateValidatorArray) {
        TrustManager[] trustManagerArray = new TrustManager[certificateValidatorArray.length];
        for (int i2 = 0; i2 < trustManagerArray.length; ++i2) {
            trustManagerArray[i2] = new CertValidatorTrustManager(certificateValidatorArray[i2]);
        }
        return trustManagerArray;
    }

    public HttpsServer(Application application) throws ServiceResultException {
        super(CloseableObjectState.Closed, CloseableObjectState.Closed);
        this.application = application;
        this.wg = new IOReactorConfig();
        this.vp = application.getHttpsSettings().getHttpsSecurityPolicies();
        this.wg.setTcpNoDelay(true);
        ImmutableHttpProcessor immutableHttpProcessor = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
        this.vY = new a();
        final Map map = Collections.synchronizedMap(new HashMap());
        this.vX = new DefaultConnectionReuseStrategy();
        this.vW = new HttpAsyncService((HttpProcessor)immutableHttpProcessor, this.vX, (HttpAsyncRequestHandlerResolver)this.vY, this.getHttpParams()){

            @Override
            public void closed(NHttpServerConnection nHttpServerConnection) {
                NHttpConnectionBase nHttpConnectionBase = (NHttpConnectionBase)((Object)nHttpServerConnection);
                rm.info("closed: {} {}<-> {} context={} socketTimeout={}", new Object[]{HttpsServer.this.getBoundSocketAddresses(), nHttpConnectionBase.getLocalAddress(), nHttpConnectionBase.getRemoteAddress(), nHttpConnectionBase.getContext(), nHttpConnectionBase.getSocketTimeout()});
                HttpsServerConnection httpsServerConnection = (HttpsServerConnection)map.remove(nHttpServerConnection);
                HttpsServer.this.vR.removeConnection(httpsServerConnection);
                super.closed(nHttpServerConnection);
            }

            @Override
            public void connected(NHttpServerConnection nHttpServerConnection) {
                NHttpConnectionBase nHttpConnectionBase = (NHttpConnectionBase)((Object)nHttpServerConnection);
                rm.info("connected: {} {}<-> {} context={} socketTimeout={}", new Object[]{HttpsServer.this.getBoundSocketAddresses(), nHttpConnectionBase.getLocalAddress(), nHttpConnectionBase.getRemoteAddress(), nHttpConnectionBase.getContext(), nHttpConnectionBase.getSocketTimeout()});
                HttpsServerConnection httpsServerConnection = new HttpsServerConnection(HttpsServer.this, nHttpServerConnection);
                map.put(nHttpServerConnection, httpsServerConnection);
                HttpsServer.this.vR.addConnection(httpsServerConnection);
                super.connected(nHttpServerConnection);
                ArrayList<ServerConnection> arrayList = new ArrayList<ServerConnection>();
                HttpsServer.this.vR.getConnections(arrayList);
                rm.trace("Checking maximum number of connections, limit: {}, current: {}", (Object)HttpsServer.this.vs, (Object)arrayList.size());
                if (arrayList.size() >= HttpsServer.this.vs) {
                    int n2 = HttpsServer.this.vs - arrayList.size() + 1;
                    rm.trace("We are at max or over limit, closing this connection");
                    try {
                        nHttpServerConnection.shutdown();
                        HttpsServer.this.vR.removeConnection(httpsServerConnection);
                    }
                    catch (IOException iOException) {
                        rm.error("Cannot close opc.https connection properly", (Throwable)iOException);
                    }
                }
            }
        };
        this.discoveryServer = new Server(application);
        this.discoveryServer.setEndpointBindings(this.endpointBindings);
        EndpointBinding endpointBinding = new EndpointBinding(this, discoveryEndpoint, this.discoveryServer);
        this.wi = new HttpsServerEndpointHandler(endpointBinding);
    }

    @Override
    public void addConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.vR.addConnectionListener(connectListener);
    }

    @Override
    public EndpointServer.EndpointHandle bind(SocketAddress socketAddress, EndpointBinding endpointBinding) throws ServiceResultException {
        Object object;
        Object object2;
        String string;
        if (endpointBinding == null || socketAddress == null || endpointBinding.endpointServer != this) {
            throw new IllegalArgumentException();
        }
        this.init();
        String string2 = string = endpointBinding.endpointAddress.getEndpointUrl();
        string2 = UriUtil.getEndpointName(string);
        if (string2 == null) {
            string2 = "";
        }
        if ((object2 = this.vY.lookup(string2)) == null) {
            object = new HttpsServerEndpointHandler(endpointBinding);
            this.vY.a(string2, (HttpsServerEndpointHandler)object);
            this.vY.a("", this.wi);
        } else {
            object = (HttpsServerEndpointHandler)object2;
            if (((HttpsServerEndpointHandler)object).wy != endpointBinding.endpointServer) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind endpoint " + string + " and " + ((HttpsServerEndpointHandler)object).wo.endpointAddress.getEndpointUrl() + " with two different sets of service.");
            }
        }
        string2 = UriUtil.getTransportProtocol(endpointBinding.endpointAddress.getEndpointUrl());
        object2 = this.a(socketAddress, string2);
        object = ((SocketHandle)object2).a(endpointBinding);
        try {
            InetSocketAddress inetSocketAddress;
            SocketHandle socketHandle2;
            int n2;
            int n3;
            this.shutdownReactor();
            this.initReactor();
            if (((SocketHandle)object2).getPort() > 0) {
                SocketHandle[] object3 = this.socketHandleSnapshot();
                n3 = object3.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    socketHandle2 = object3[n2];
                    if (socketHandle2.ws != null) continue;
                    socketHandle2.ws = this.wf.listen(socketHandle2.getSocketAddress());
                    inetSocketAddress = (InetSocketAddress)socketHandle2.getSocketAddress();
                    socketHandle2.setBoundSocketAddress(new InetSocketAddress(inetSocketAddress.getAddress(), inetSocketAddress.getPort()));
                }
            } else if (this.wj > 0 && ((SocketHandle)object2).getPort() == 0) {
                SocketHandle[] serviceResultException = this.socketHandleSnapshot();
                n3 = serviceResultException.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    socketHandle2 = serviceResultException[n2];
                    if (socketHandle2.ws != null) continue;
                    endpointBinding.rewriteEndpointUrlPort(this.wj);
                    inetSocketAddress = (InetSocketAddress)socketHandle2.getSocketAddress();
                    socketHandle2.setBoundSocketAddress(new InetSocketAddress(inetSocketAddress.getAddress(), this.wj));
                    socketHandle2.ws = this.wf.listen(socketHandle2.getBoundSocketAddress());
                }
            }
            if ("opc.https".equals(string2) && (this.vS == null || !this.vS.isAlive())) {
                final ListeningIOReactor listeningIOReactor = this.wf;
                final Semaphore semaphore = this.vU = new Semaphore(0);
                this.vS = new Thread(){

                    @Override
                    public void run() {
                        try {
                            HttpsServer.this.setState((Object)CloseableObjectState.Open);
                            listeningIOReactor.execute(HttpsServer.this.we);
                        }
                        catch (IOException iOException) {
                            HttpsServer.this.setError(new ServiceResultException(iOException));
                        }
                        finally {
                            semaphore.release(9999);
                        }
                    }
                };
                if (!((CloseableObjectState)((Object)this.getState())).isOpen()) {
                    this.setState(CloseableObjectState.Opening);
                }
                this.vS.start();
            }
            if ("http".equals(string2) && (this.vT == null || !this.vT.isAlive())) {
                final ListeningIOReactor listeningIOReactor = this.wf;
                final Semaphore semaphore = this.vV = new Semaphore(0);
                this.vT = new Thread(){

                    @Override
                    public void run() {
                        try {
                            HttpsServer.this.setState((Object)CloseableObjectState.Open);
                            listeningIOReactor.execute(HttpsServer.this.wd);
                        }
                        catch (IOException iOException) {
                            HttpsServer.this.setError(new ServiceResultException(iOException));
                        }
                        finally {
                            semaphore.release(9999);
                        }
                    }
                };
                if (!((CloseableObjectState)((Object)this.getState())).isOpen()) {
                    this.setState(CloseableObjectState.Opening);
                }
                this.vT.start();
            }
            if (((SocketHandle)object2).getPort() == 0 && ((SocketHandle)object2).getBoundSocketAddress() == null) {
                for (SocketHandle socketHandle2 : this.socketHandleSnapshot()) {
                    if (socketHandle2.ws != null) continue;
                    socketHandle2.ws = this.wf.listen(socketHandle2.getSocketAddress());
                    if (socketHandle2.getBoundSocketAddress() != null) continue;
                    try {
                        socketHandle2.ws.waitFor();
                        this.wj = ((InetSocketAddress)socketHandle2.ws.getAddress()).getPort();
                        rm.info("Replace port number 0 in socket addresses with: {}", (Object)this.wj);
                        endpointBinding.rewriteEndpointUrlPort(this.wj);
                        inetSocketAddress = (InetSocketAddress)socketHandle2.getSocketAddress();
                        socketHandle2.setBoundSocketAddress(new InetSocketAddress(inetSocketAddress.getAddress(), this.wj));
                    }
                    catch (InterruptedException interruptedException) {
                        rm.error("InterruptedException", (Throwable)interruptedException);
                    }
                }
            }
        }
        catch (ServiceResultException serviceResultException) {
            ((HttpsEndpointHandle)object).close();
            throw serviceResultException;
        }
        rm.info("HTTPS Socket bound to {}", (Object)(((SocketHandle)object2).getBoundSocketAddress() != null ? ((SocketHandle)object2).getBoundSocketAddress() : ((SocketHandle)object2).getSocketAddress()));
        rm.info("Endpoint bound to {}", (Object)((HttpsEndpointHandle)object).endpointBinding().endpointAddress.getEndpointUrl());
        return object;
    }

    @Override
    public EndpointServer.ReverseEndpointHandle bindReverse(SocketAddress socketAddress, ReverseConnectionParameters reverseConnectionParameters, ScheduledExecutorService scheduledExecutorService) {
        throw new UnsupportedOperationException("HTTPS does not support ReverseHello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableObject close() {
        for (EndpointBinding endpointBinding : this.endpointBindings.getAll()) {
            endpointBinding.endpointServer.getEndpointBindings().remove(endpointBinding);
        }
        this.endpointBindings.clear();
        try {
            this.setState(CloseableObjectState.Closing);
            for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
                socketHandle.close();
            }
        }
        finally {
            try {
                if (this.wf != null) {
                    this.wf.shutdown();
                }
                if (this.vS != null) {
                    this.vS.interrupt();
                    this.vS = null;
                }
                if (this.vT != null) {
                    this.vT.interrupt();
                    this.vT = null;
                }
            }
            catch (IOException iOException) {}
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }

    @Override
    public List<SocketAddress> getBoundSocketAddresses() {
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            arrayList.add(socketHandle.getBoundSocketAddress() != null ? socketHandle.getBoundSocketAddress() : socketHandle.getSocketAddress());
        }
        return arrayList;
    }

    @Override
    public void getConnections(Collection<ServerConnection> collection) {
        this.vR.getConnections(collection);
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    @Override
    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    public HttpsSettings getHttpsSettings() {
        return this.application.getHttpsSettings();
    }

    public Collection<HttpsSecurityPolicy> getSupportedSecurityPolicies() {
        if (this.vp == null) {
            return HttpsSecurityPolicy.getAvailablePolicies().values();
        }
        return Arrays.asList(this.vp);
    }

    public int getWorkerThreadCount() {
        return this.wg.getIoThreadCount();
    }

    @Override
    public void removeConnectionListener(ConnectionMonitor.ConnectListener connectListener) {
        this.vR.removeConnectionListener(connectListener);
    }

    public void setWorkerThreadCount(int n2) {
        if (this.wf != null) {
            throw new RuntimeException("Set workercount before binding the first socket address");
        }
        this.wg.setIoThreadCount(n2);
    }

    public SocketHandle[] socketHandleSnapshot() {
        return this.wh.values().toArray(new SocketHandle[this.wh.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HttpServer");
        stringBuilder.append("(");
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            stringBuilder.append(socketHandle.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private void init() {
        if (!this.initialized) {
            int n2 = this.application.getHttpsSettings().getMaxConnections();
            if (n2 <= 0) {
                throw new IllegalStateException("Maximum number of connections was not configured; must be greater than 0");
            }
            this.vs = n2;
            this.initialized = true;
        }
    }

    protected void initReactor() throws ServiceResultException {
        boolean bl = false;
        boolean bl2 = false;
        for (SocketHandle socketHandle : this.wh.values()) {
            bl |= socketHandle.scheme.equals("opc.https");
            bl2 |= socketHandle.scheme.equals("http");
        }
        try {
            Object[] objectArray;
            if (bl && this.wc == null) {
                try {
                    objectArray = SSLContext.getInstance("TLSv1.2");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    rm.debug("No TLSv1.2 implementation found, trying TLS");
                    objectArray = SSLContext.getInstance("TLS");
                }
                objectArray.init(this.application.getHttpsSettings().getKeyManagers(), this.application.getHttpsSettings().getTrustManagers(), null);
                this.wc = new SSLSetupHandler(){

                    @Override
                    public void initalize(SSLEngine sSLEngine) throws SSLException {
                    }

                    @Override
                    public void verify(IOSession iOSession, SSLSession sSLSession) throws SSLException {
                    }
                };
                this.wa = new SSLNHttpServerConnectionFactory((SSLContext)objectArray, this.wc, this.getHttpParams());
                this.we = new DefaultHttpServerIODispatch<HttpAsyncService>(this.vW, this.wa);
                this.wb = objectArray.createSSLEngine();
                rm.info("Enabled protocols in SSL Engine are {}", (Object)Arrays.toString(this.wb.getEnabledProtocols()));
                this.vN = this.wb.getEnabledCipherSuites();
                rm.info("Enabled CipherSuites in SSL Engine are {}", (Object)Arrays.toString(this.vN));
            }
            if (bl) {
                objectArray = this.vA;
                this.vO = this.eCs();
                this.vA = CryptoUtil.filterCipherSuiteList(this.vN, this.vO);
                this.wb.setEnabledCipherSuites(this.vA);
                if (objectArray == null || !Arrays.equals(objectArray, this.vA)) {
                    rm.info("CipherSuites for policies ({}) are {}", (Object)Arrays.toString((Object[])this.vp), (Object)Arrays.toString(this.vA));
                }
            }
            if (bl2 && this.vZ == null) {
                this.vZ = new DefaultNHttpServerConnectionFactory(this.getHttpParams());
                this.wd = new DefaultHttpServerIODispatch<HttpAsyncService>(this.vW, this.vZ);
            }
            if (this.wf == null) {
                this.wf = new DefaultListeningIOReactor(this.wg, null);
            }
        }
        catch (KeyManagementException keyManagementException) {
            throw new ServiceResultException(keyManagementException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServiceResultException(noSuchAlgorithmException);
        }
        catch (IOReactorException iOReactorException) {
            throw new ServiceResultException(iOReactorException);
        }
    }

    protected void shutdownReactor() {
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            ListenerEndpoint listenerEndpoint = socketHandle.ws;
            if (listenerEndpoint != null) {
                listenerEndpoint.close();
            }
            socketHandle.ws = null;
        }
        if (this.wf != null) {
            try {
                this.wf.shutdown();
            }
            catch (IOException iOException) {
                rm.error("Failed to shutdown ioReactor", (Throwable)iOException);
            }
            this.wf = null;
        }
        if (this.vS != null) {
            this.vS.interrupt();
            try {
                this.vU.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.vU = null;
            this.vS = null;
        }
        if (this.vT != null) {
            this.vT.interrupt();
            try {
                this.vV.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.vV = null;
            this.vT = null;
        }
    }

    String[] eCs() throws ServiceResultException {
        Collection<HttpsSecurityPolicy> collection = this.getSupportedSecurityPolicies();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpsSecurityPolicy httpsSecurityPolicy : collection) {
            String[] stringArray = httpsSecurityPolicy.getCipherSuites();
            if (stringArray == null) continue;
            for (String string : stringArray) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    Set<SecurityPolicy> eCt() {
        HashSet<SecurityPolicy> hashSet = new HashSet<SecurityPolicy>();
        for (EndpointBinding endpointBinding : this.endpointBindings.getAll()) {
            for (SecurityMode securityMode : endpointBinding.endpointAddress.getSecurityModes()) {
                hashSet.add(securityMode.getSecurityPolicy());
            }
        }
        return hashSet;
    }

    int a(Endpoint endpoint) {
        int n2 = 0;
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            for (HttpsEndpointHandle httpsEndpointHandle : socketHandle.endpointHandleSnapshot()) {
                if (!httpsEndpointHandle.wo.endpointAddress.equals(endpoint)) continue;
                ++n2;
            }
        }
        return n2;
    }

    List<HttpsEndpointHandle> av(String string) {
        ArrayList<HttpsEndpointHandle> arrayList = new ArrayList<HttpsEndpointHandle>();
        for (SocketHandle socketHandle : this.socketHandleSnapshot()) {
            socketHandle.b(arrayList);
        }
        return arrayList;
    }

    HttpParams getHttpParams() {
        return this.application.getHttpsSettings().getHttpParams() == null ? DEFAULT_HTTPPARAMS : this.application.getHttpsSettings().getHttpParams();
    }

    synchronized SocketHandle a(SocketAddress socketAddress, String string) throws ServiceResultException {
        SocketHandle socketHandle = this.wh.get(socketAddress);
        if (socketHandle == null) {
            socketHandle = new SocketHandle(socketAddress, string);
            this.wh.put(socketAddress, socketHandle);
        } else if (!string.equals(socketHandle.scheme)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Socket port=" + (socketHandle.getBoundSocketAddress() != null ? socketHandle.getBoundSocketAddress().getPort() : socketHandle.getPort()) + " cannot be bound as http and https.");
        }
        return socketHandle;
    }

    class a
    implements HttpAsyncRequestHandlerResolver {
        Map<String, HttpsServerEndpointHandler> map = new HashMap<String, HttpsServerEndpointHandler>();

        public Map<String, HttpAsyncRequestHandler<?>> getHandlers() {
            return new HashMap(this.map);
        }

        @Override
        public HttpAsyncRequestHandler<?> lookup(String string) {
            HttpAsyncRequestHandler httpAsyncRequestHandler = this.map.get(string);
            if (httpAsyncRequestHandler == null && (string.equals("") || string.equals("/"))) {
                return HttpsServer.this.wi;
            }
            return httpAsyncRequestHandler;
        }

        public void a(String string, HttpsServerEndpointHandler httpsServerEndpointHandler) {
            this.map.put(string, httpsServerEndpointHandler);
        }

        public void setHandlers(Map<String, HttpAsyncRequestHandler<?>> map) {
            this.map.clear();
            for (Map.Entry<String, HttpAsyncRequestHandler<?>> entry : map.entrySet()) {
                this.map.put(entry.getKey(), (HttpsServerEndpointHandler)entry.getValue());
            }
        }

        public void unregister(String string) {
            this.map.remove(string);
        }
    }

    public class SocketHandle {
        private SocketAddress wq;
        private InetSocketAddress wr;
        ListenerEndpoint ws;
        String scheme;
        Map<Endpoint, HttpsEndpointHandle> endpoints = new HashMap<Endpoint, HttpsEndpointHandle>();

        SocketHandle(SocketAddress socketAddress, String string) {
            this.setSocketAddress(socketAddress);
            this.scheme = string;
        }

        public synchronized HttpsEndpointHandle[] endpointHandleSnapshot() {
            return this.endpoints.values().toArray(new HttpsEndpointHandle[this.endpoints.size()]);
        }

        public InetSocketAddress getBoundSocketAddress() {
            return this.wr;
        }

        public SocketAddress getSocketAddress() {
            return this.wq;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.scheme + "(" + (this.getBoundSocketAddress() != null ? this.getBoundSocketAddress() : this.getSocketAddress()) + ", ");
            for (HttpsEndpointHandle httpsEndpointHandle : this.endpoints.values()) {
                stringBuilder.append(httpsEndpointHandle.toString());
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        void close() {
            for (HttpsEndpointHandle httpsEndpointHandle : this.endpoints.values()) {
                httpsEndpointHandle.eCv();
            }
            HttpsServer.this.wh.remove(this.getSocketAddress());
            if (this.ws != null) {
                this.ws.close();
            }
        }

        synchronized void b(Collection<HttpsEndpointHandle> collection) {
            collection.addAll(this.endpoints.values());
        }

        synchronized HttpsEndpointHandle a(EndpointBinding endpointBinding) throws ServiceResultException {
            HttpsEndpointHandle httpsEndpointHandle = this.endpoints.get(endpointBinding.endpointAddress);
            if (httpsEndpointHandle == null) {
                httpsEndpointHandle = new HttpsEndpointHandle(this, endpointBinding);
                this.endpoints.put(endpointBinding.endpointAddress, httpsEndpointHandle);
                HttpsServer.this.endpointBindings.add(endpointBinding);
                endpointBinding.serviceServer.getEndpointBindings().add(endpointBinding);
            } else if (!httpsEndpointHandle.wo.equals(endpointBinding)) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot bind an endpoint address to two different servers.");
            }
            return httpsEndpointHandle;
        }

        int getPort() {
            return ((InetSocketAddress)this.getSocketAddress()).getPort();
        }

        void setBoundSocketAddress(InetSocketAddress inetSocketAddress) {
            this.wr = inetSocketAddress;
        }

        void setSocketAddress(SocketAddress socketAddress) {
            this.wq = socketAddress;
        }
    }

    public class HttpsEndpointHandle
    implements EndpointServer.EndpointHandle {
        EndpointBinding wo;
        SocketHandle wp;

        HttpsEndpointHandle(SocketHandle socketHandle, EndpointBinding endpointBinding) {
            this.wp = socketHandle;
            this.wo = endpointBinding;
        }

        @Override
        public void close() {
            this.eCu();
            this.eCv();
        }

        @Override
        public EndpointBinding endpointBinding() {
            return this.wo;
        }

        @Override
        public SocketAddress socketAddress() {
            return this.wp.getBoundSocketAddress() != null ? this.wp.getBoundSocketAddress() : this.wp.getSocketAddress();
        }

        public String toString() {
            return "(" + this.wo.endpointAddress.toString() + ")";
        }

        void eCu() {
            this.wp.endpoints.remove(this.wo.endpointAddress);
            if (this.wp.endpoints.isEmpty()) {
                this.wp.close();
            }
        }

        void eCv() {
            int n2 = HttpsServer.this.a(this.wo.endpointAddress);
            if (n2 == 0) {
                String string = this.wo.endpointAddress.getEndpointUrl();
                HttpsServer.this.vY.unregister(string);
                HttpsServer.this.vY.unregister("");
                HttpsServer.this.endpointBindings.remove(this.wo);
                this.wo.serviceServer.getEndpointBindings().remove(this.wo);
            }
        }
    }
}

