/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport;

import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriUtil {
    public static final int OPC_TCP_PORT = 4840;
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final int OPC_TCP_DISCOVERY_PORT = 4840;
    public static final int HTTPS_DISCOVERY_PORT = 443;
    public static final int HTTP_DISCOVERY_PORT = 56201;
    public static final String SCHEME_OPCTCP = "opc.tcp";
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "opc.https";
    public static final Pattern PATTERN_HTTPS = Pattern.compile("^opc.https://([^/]+)(/.*)?$", 2);
    public static final Pattern PATTERN_HTTP = Pattern.compile("^http://([^/]+)(/.*)?$", 2);
    public static final Pattern PATTERN_OPCTCP = Pattern.compile("^opc.tcp://([^/]+)(/.*)?$", 2);
    public static final Pattern PATTERN_URI = Pattern.compile("^(\\S+)://([^/]+)(/.*)?$", 2);
    public static final String SOAP_XML_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/soaphttp-wssc-uaxml-uabinary";
    public static final String UATCP_BINARY_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
    public static final String HTTPS_BINARY_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";

    public static int defaultPort(String string) {
        if (SCHEME_OPCTCP.equals(string)) {
            return 4840;
        }
        if (SCHEME_HTTP.equals(string)) {
            return 80;
        }
        if (SCHEME_HTTPS.equals(string)) {
            return 443;
        }
        throw new IllegalArgumentException("Unsupported protocol " + string);
    }

    public static String getEndpointName(String string) {
        Matcher matcher = PATTERN_URI.matcher(string);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        return null;
    }

    public static MessageFormat getMessageFormat(String string) throws ServiceResultException {
        if (PATTERN_OPCTCP.matcher(string).matches()) {
            return MessageFormat.Binary;
        }
        if (PATTERN_HTTPS.matcher(string).matches()) {
            return MessageFormat.Binary;
        }
        if (PATTERN_HTTP.matcher(string).matches()) {
            return MessageFormat.Binary;
        }
        throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
    }

    public static int getPort(String string) {
        try {
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(string);
            int n2 = inetSocketAddress.getPort();
            if (n2 == -1) {
                String string2 = UriUtil.getTransportProtocol(string);
                return UriUtil.defaultPort(string2);
            }
            return n2;
        }
        catch (ServiceResultException serviceResultException) {
            return -1;
        }
    }

    public static InetSocketAddress getSocketAddress(String string) throws ServiceResultException {
        try {
            UaAddress uaAddress = UaAddress.parse(string);
            return new InetSocketAddress(uaAddress.getHost(), uaAddress.getPort());
        }
        catch (RuntimeException runtimeException) {
            try {
                int n2;
                String[] stringArray = string.split("/+");
                String string2 = stringArray[0].split(":")[0];
                String[] stringArray2 = stringArray[1].split(":");
                String string3 = stringArray2[0];
                try {
                    n2 = Integer.parseInt(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = UriUtil.defaultPort(string2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n2 = UriUtil.defaultPort(string2);
                }
                return new InetSocketAddress(string3, n2);
            }
            catch (RuntimeException runtimeException2) {
                throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid, (Throwable)runtimeException2);
            }
        }
    }

    @Deprecated
    public static InetSocketAddress getSocketAddress(URI uRI) {
        String string = uRI.getScheme().toLowerCase();
        String string2 = uRI.getHost();
        int n2 = uRI.getPort();
        if (n2 == -1) {
            n2 = UriUtil.defaultPort(string);
        }
        return new InetSocketAddress(string2, n2);
    }

    public static String getTransportProtocol(String string) {
        int n2 = string.indexOf(58);
        if (n2 < 1) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static enum MessageFormat {
        Binary,
        Xml;

    }
}

