/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.AbstractDecoder;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IDecoder;
import com.prosysopc.ua.stack.encoding.binary.ByteUtils;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.LittleEndianInputStreamReadable;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDecoder
extends AbstractDecoder
implements IDecoder {
    private static final Logger logger = LoggerFactory.getLogger(BinaryDecoder.class);
    private static final Map<Class<?>, a<?>> sS = new HashMap();
    private static final a<?>[] sT = new a[51];
    private static final Class<?>[] sU = new Class[51];
    private static final a<DateTime> sV;
    private static final a<ExtensionObject> sW;
    private static final a<Structure> sX;
    private static final a<Object> sY;
    private static final a<DataValue> sZ;
    private static final a<Variant> ta;
    private static final a<DiagnosticInfo> tb;
    private static final a<Enumeration> tc;
    private static final a<BigDecimal> td;
    private static final a<UaOptionSet> te;
    private static final ExpandedNodeId tf;
    IBinaryReadable tg;
    private BiConsumer<FieldSpecification, Object> th;

    private static <T> void a(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) throws Error {
        if (uaNodeId == null) {
            return;
        }
        Object object = uaNodeId.getValue();
        if (!(object instanceof UnsignedInteger)) {
            throw new Error("Internal error, builtintype UaNodeId was not numeric");
        }
        int n2 = ((UnsignedInteger)object).intValue();
        if (n2 != 50 && n2 > 25) {
            throw new Error("Internal error, DataType " + uaNodeId + " higher index than expected, was: " + n2);
        }
        if (sT[n2] != null) {
            throw new Error("Internal error, DataType " + uaNodeId + " already has a serializer defined");
        }
        BinaryDecoder.sT[n2] = a2;
        if (sU[n2] != null) {
            throw new Error("Internal error, DataType " + uaNodeId + " already has a class defined");
        }
        BinaryDecoder.sU[n2] = clazz;
    }

    private static <T> void b(UaNodeId uaNodeId, Class<T> clazz, a<T> a2) {
        if (!Object.class.equals(clazz) && !Modifier.isFinal(clazz.getModifiers())) {
            throw new Error("Class " + clazz + " is not final, and cannot be put to known final classes serialization helper");
        }
        if (sS.put(clazz, a2) != null) {
            throw new Error("Class " + clazz + " already has a serializer defined");
        }
        BinaryDecoder.a(uaNodeId, clazz, a2);
    }

    private static boolean a(UnsignedInteger unsignedInteger, int n2) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("mask cannot be null");
        }
        if (n2 < 0 || n2 > 31) {
            throw new IllegalArgumentException("position must be between 0-31");
        }
        int n3 = 1 << n2;
        if (UnsignedInteger.ZERO.equals(unsignedInteger)) {
            return false;
        }
        return unsignedInteger.and(n3).equals(UnsignedInteger.valueOf(n3));
    }

    private static DecodingException a(IOException iOException) {
        if (iOException instanceof ClosedChannelException) {
            return new DecodingException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException);
        }
        if (iOException instanceof EOFException) {
            return new DecodingException(StatusCodes.Bad_EndOfStream, (Throwable)iOException);
        }
        if (iOException instanceof ConnectException) {
            return new DecodingException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
        }
        if (iOException instanceof SocketException) {
            return new DecodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
        }
        return new DecodingException(StatusCodes.Bad_UnexpectedError, (Throwable)iOException);
    }

    private static int k(UaNodeId uaNodeId) {
        int n2;
        if (!UaNamespace.STANDARD.equals(uaNodeId.getNamespace())) {
            return -1;
        }
        Object object = uaNodeId.getValue();
        if (object instanceof UnsignedInteger && (n2 = ((UnsignedInteger)object).toIntBits()) > 0 && n2 < 51) {
            return n2;
        }
        return -1;
    }

    public BinaryDecoder(EncoderContext encoderContext, byte[] byArray) {
        super(encoderContext);
        ByteBuffer byteBuffer = ByteBuffer.wrap(InternalArguments.checkNotNull(byArray, "buf"));
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(EncoderContext encoderContext, byte[] byArray, int n2, int n3) {
        super(encoderContext);
        ByteBuffer byteBuffer = ByteBuffer.wrap(InternalArguments.checkNotNull(byArray, "buf"), n2, n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(EncoderContext encoderContext, ByteBuffer byteBuffer) {
        super(encoderContext);
        this.setReadable(new ByteBufferReadable(byteBuffer));
    }

    public BinaryDecoder(EncoderContext encoderContext, ByteString byteString) {
        this(encoderContext, InternalArguments.checkNotNull(byteString).getValue());
    }

    public BinaryDecoder(EncoderContext encoderContext, ByteString byteString, int n2, int n3) {
        this(encoderContext, InternalArguments.checkNotNull(byteString).getValue(), n2, n3);
    }

    public BinaryDecoder(EncoderContext encoderContext, IBinaryReadable iBinaryReadable) {
        super(encoderContext);
        this.setReadable(iBinaryReadable);
    }

    public BinaryDecoder(EncoderContext encoderContext, InputStream inputStream, int n2) {
        super(encoderContext);
        this.setReadable(new LittleEndianInputStreamReadable(inputStream, n2));
    }

    @Override
    public <T> T get(String string, UaNodeId uaNodeId, int n2) throws DecodingException {
        InternalArguments.checkNotNull(uaNodeId, "DataTypeId");
        if (n2 < 0) {
            throw new DecodingException("The given dimensions cannot be negative");
        }
        EncoderContext encoderContext = this.getEncoderContext();
        if (encoderContext == null) {
            throw new IllegalStateException("The EncoderContext is not set");
        }
        UaDataTypeSpecification uaDataTypeSpecification = null;
        uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId);
        if (uaDataTypeSpecification == null) {
            throw new DecodingException("Cannot find UaDataTypeSpecification, cannot decode DataType: " + uaNodeId);
        }
        try {
            T t2 = this.a(uaNodeId, n2, uaDataTypeSpecification);
            return t2;
        }
        catch (Exception exception) {
            throw new DecodingException("Error while trying to decode, DataTypeId: " + uaNodeId, exception);
        }
    }

    @Override
    public int[] getInt32Array_(String string) throws DecodingException {
        return this.eBd();
    }

    public IBinaryReadable getReadable() {
        return this.tg;
    }

    public void setReadable(IBinaryReadable iBinaryReadable) {
        if (iBinaryReadable.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("Readable must be in Little-Ending byte order");
        }
        this.tg = iBinaryReadable;
    }

    public void setStructureFieldDecodeListener(BiConsumer<FieldSpecification, Object> biConsumer) {
        this.th = biConsumer;
    }

    public a<?> tryFindDecoderWithSpecification(UaDataTypeSpecification uaDataTypeSpecification) throws DecodingException {
        a<Object> a2;
        if (uaDataTypeSpecification instanceof SimpleTypeSpecification) {
            int n2 = BinaryDecoder.k(((SimpleTypeSpecification)uaDataTypeSpecification).getBaseTypeId());
            a2 = n2 != -1 ? sT[n2] : null;
        } else if (uaDataTypeSpecification instanceof StructureSpecification) {
            a2 = sX;
        } else if (uaDataTypeSpecification instanceof OptionSetSpecification) {
            a2 = te;
        } else if (uaDataTypeSpecification instanceof EnumerationSpecification) {
            a2 = tc;
        } else {
            throw new DecodingException("Found UaDataTypeSpecification of unknown kind: " + uaDataTypeSpecification);
        }
        if (a2 == null) {
            throw new DecodingException("Cannot find serializer for DataTypeId: " + uaDataTypeSpecification.getTypeId());
        }
        return a2;
    }

    private BigDecimal d(ByteString byteString) {
        byte[] byArray = byteString.getValue();
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(byArray[0]);
        byteBuffer.put(byArray[1]);
        byteBuffer.rewind();
        short s2 = byteBuffer.getShort();
        byte[] byArray2 = Arrays.copyOfRange(byArray, 2, byArray.length);
        byArray2 = ByteUtils.reverse(byArray2);
        BigInteger bigInteger = new BigInteger(byArray2);
        return new BigDecimal(bigInteger, s2);
    }

    private Object a(Object object, Class clazz) throws DecodingException {
        return MultiDimensionArrayUtils.map(object, ExtensionObject.class, clazz, extensionObject -> {
            if (extensionObject == null) {
                return null;
            }
            return clazz.cast(extensionObject.decode(this.getEncoderContext()));
        });
    }

    private UaOptionSet a(OptionSetSpecification optionSetSpecification) throws DecodingException {
        Object t2 = this.get(null, optionSetSpecification.getBaseTypeId(), 0);
        try {
            return (UaOptionSet)new Variant(t2).asOptionSet(optionSetSpecification);
        }
        catch (Exception exception) {
            throw new DecodingException(exception, "Could not resolve the value as UaOptionSet");
        }
    }

    private <T> T a(UaNodeId uaNodeId, int n2, UaDataTypeSpecification uaDataTypeSpecification) throws DecodingException {
        Class<?> clazz;
        a<Object> a2 = null;
        int n3 = BinaryDecoder.k(uaNodeId);
        if (n3 != -1) {
            a2 = sT[n3];
        }
        if (a2 != null) {
            clazz = sU[n3];
            if (clazz == null) {
                throw new DecodingException("Cannot find the class mapping for DataTypeId: " + uaNodeId);
            }
        } else {
            a2 = this.tryFindDecoderWithSpecification(uaDataTypeSpecification);
            clazz = uaDataTypeSpecification.getJavaClass();
        }
        a<Object> a3 = a2;
        if (n2 == 0) {
            return (T)a3.get(this, null, clazz, uaNodeId, uaDataTypeSpecification);
        }
        if (n2 == 1) {
            return this.a(uaNodeId, uaDataTypeSpecification, clazz, a3);
        }
        return this.b(uaNodeId, uaDataTypeSpecification, clazz, a3);
    }

    private <T> T a(UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification, Class<?> clazz, a<Object> a2) throws DecodingException {
        int n2 = this.eBe();
        this.assertArrayLength(n2);
        if (n2 == -1) {
            return null;
        }
        if (n2 == 0) {
            return (T)this.emptyArrayForClass(clazz);
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, n2);
        a<Object> a3 = a2;
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = a3.get(this, null, clazz, uaNodeId, uaDataTypeSpecification);
        }
        return (T)objectArray;
    }

    private <T> T b(UaNodeId uaNodeId, UaDataTypeSpecification uaDataTypeSpecification, Class<?> clazz, a<Object> a2) throws DecodingException {
        int n2;
        int[] nArray = this.eBd();
        if (nArray == null) {
            return null;
        }
        int n22 = 1;
        int[] objectArray = nArray;
        int a3 = objectArray.length;
        for (n2 = 0; n2 < a3; ++n2) {
            int n3 = objectArray[n2];
            if (n3 < 0) {
                return null;
            }
            n22 *= n3;
        }
        this.assertArrayLength(n22);
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n22);
        a<Object> a4 = a2;
        for (n2 = 0; n2 < n22; ++n2) {
            objectArray2[n2] = a4.get(this, null, clazz, uaNodeId, uaDataTypeSpecification);
        }
        return (T)MultiDimensionArrayUtils.demuxArray((Object)objectArray2, nArray, clazz);
    }

    private Boolean eAP() throws DecodingException {
        try {
            if (this.tg.get() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UnsignedByte eAQ() throws DecodingException {
        try {
            return UnsignedByte.getFromBits(this.tg.get());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private ByteString eAR() throws DecodingException {
        try {
            int n2 = this.tg.getInt();
            if (n2 == -1) {
                return null;
            }
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            this.assertByteStringLength(n2);
            byte[] byArray = new byte[n2];
            this.tg.get(byArray);
            return ByteString.valueOf(byArray);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private DataValue eAS() throws DecodingException {
        try {
            byte by = this.tg.get();
            Variant variant = (by & 1) != 0 ? this.eBp() : null;
            StatusCode statusCode = (by & 2) != 0 ? this.eBk() : StatusCode.GOOD;
            DateTime dateTime = (by & 4) != 0 ? this.eAT() : null;
            UnsignedShort unsignedShort = (by & 0x10) != 0 ? this.eBm() : UnsignedShort.MIN_VALUE;
            DateTime dateTime2 = (by & 8) != 0 ? this.eAT() : null;
            UnsignedShort unsignedShort2 = (by & 0x20) != 0 ? this.eBm() : UnsignedShort.MIN_VALUE;
            return new DataValue(variant, statusCode, dateTime, unsignedShort, dateTime2, unsignedShort2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private DateTime eAT() throws DecodingException {
        try {
            long l2 = this.tg.getLong();
            return DateTime.valueOf(l2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private BigDecimal eAU() throws DecodingException {
        ExtensionObject extensionObject = this.eAY();
        if (!this.getEncoderContext().getNamespaceTable().nodeIdEquals(extensionObject.getTypeId(), tf)) {
            logger.error("Encountered a Decimal that does not define correct id, is {}", (Object)extensionObject.getTypeId());
        }
        try {
            return this.d((ByteString)extensionObject.getObject());
        }
        catch (ClassCastException classCastException) {
            throw new DecodingException("Did not get an ExtensionObject with ByteString data for Decimal type", classCastException);
        }
    }

    private DiagnosticInfo eAV() throws DecodingException {
        try {
            byte by = this.tg.get();
            Integer n2 = (by & 1) != 0 ? this.eBc() : null;
            Integer n3 = (by & 2) != 0 ? this.eBc() : null;
            Integer n4 = (by & 8) != 0 ? this.eBc() : null;
            Integer n5 = (by & 4) != 0 ? this.eBc() : null;
            String string = (by & 0x10) != 0 ? this.eBl() : null;
            StatusCode statusCode = (by & 0x20) != 0 ? this.eBk() : null;
            DiagnosticInfo diagnosticInfo = (by & 0x40) != 0 ? this.eAV() : null;
            return new DiagnosticInfo(string, diagnosticInfo, statusCode, n4, n5, n3, n2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Double eAW() throws DecodingException {
        try {
            return this.tg.getDouble();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private <T extends Enumeration> T a(EnumerationSpecification enumerationSpecification) throws DecodingException {
        try {
            int n2 = this.tg.getInt();
            return (T)enumerationSpecification.getByValue(n2);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private ExpandedNodeId eAX() throws DecodingException {
        try {
            Object object;
            int n2;
            byte by = this.tg.get();
            boolean bl = (by & 0x40) == 64;
            boolean bl2 = (by & 0x80) == 128;
            String string = null;
            UnsignedInteger unsignedInteger = null;
            switch (by & 0x3F) {
                case 0: {
                    n2 = 0;
                    object = UnsignedInteger.getFromBits(this.tg.get() & 0xFF);
                    break;
                }
                case 1: {
                    n2 = this.tg.get() & 0xFF;
                    object = UnsignedInteger.getFromBits(this.tg.getShort() & 0xFFFF);
                    break;
                }
                case 2: {
                    n2 = this.tg.getShort() & 0xFFFF;
                    object = UnsignedInteger.getFromBits(this.tg.getInt());
                    break;
                }
                case 3: {
                    n2 = this.tg.getShort() & 0xFFFF;
                    object = this.eBl();
                    break;
                }
                case 5: {
                    n2 = this.tg.getShort() & 0xFFFF;
                    object = this.eAR();
                    break;
                }
                case 4: {
                    n2 = this.tg.getShort() & 0xFFFF;
                    object = this.eBa();
                    break;
                }
                default: {
                    throw new DecodingException("Unsupported/Unexpected (Expanded)NodeId Encoding byte " + by);
                }
            }
            if (bl2) {
                string = this.eBl();
            }
            if (bl) {
                unsignedInteger = this.eBn();
            }
            if (string != null) {
                return new ExpandedNodeId(unsignedInteger, string, object);
            }
            return new ExpandedNodeId(unsignedInteger, n2, object);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private ExtensionObject eAY() throws DecodingException {
        try {
            ExtensionObject extensionObject;
            NodeId nodeId = this.eBh();
            ExpandedNodeId expandedNodeId = this.ctx.getNamespaceTable().toExpandedNodeId(nodeId);
            byte by = this.tg.get();
            if (by == 0) {
                if (nodeId == null || nodeId.equals(NodeId.NULL)) {
                    return null;
                }
                return new ExtensionObject(expandedNodeId);
            }
            if (by == 1) {
                extensionObject = new ExtensionObject(expandedNodeId, this.eAR());
            } else if (by == 2) {
                extensionObject = new ExtensionObject(expandedNodeId, this.eBq());
            } else {
                throw new DecodingException("Unexpected encoding byte (" + by + ") in ExtensionObject");
            }
            if (this.a(extensionObject)) {
                return extensionObject;
            }
            try {
                Structure structure = (Structure)extensionObject.decode(this.getEncoderContext());
                return new ExtensionObject(structure);
            }
            catch (DecodingException decodingException) {
                return extensionObject;
            }
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Float eAZ() throws DecodingException {
        try {
            return Float.valueOf(this.tg.getFloat());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UUID eBa() throws DecodingException {
        try {
            int n2;
            byte[] byArray = new byte[16];
            byArray[3] = this.tg.get();
            byArray[2] = this.tg.get();
            byArray[1] = this.tg.get();
            byArray[0] = this.tg.get();
            byArray[5] = this.tg.get();
            byArray[4] = this.tg.get();
            byArray[7] = this.tg.get();
            byArray[6] = this.tg.get();
            for (int i2 = 8; i2 < 16; ++i2) {
                byArray[i2] = this.tg.get();
            }
            long l2 = 0L;
            long l3 = 0L;
            for (n2 = 0; n2 < 8; ++n2) {
                l2 = l2 << 8 | (long)(byArray[n2] & 0xFF);
            }
            for (n2 = 8; n2 < 16; ++n2) {
                l3 = l3 << 8 | (long)(byArray[n2] & 0xFF);
            }
            return new UUID(l2, l3);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Short eBb() throws DecodingException {
        try {
            return this.tg.getShort();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Integer eBc() throws DecodingException {
        try {
            return this.tg.getInt();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private int[] eBd() throws DecodingException {
        try {
            int n2 = this.tg.getInt();
            if (n2 == -1) {
                return null;
            }
            this.assertArrayLength(n2);
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.eBe();
            }
            return nArray;
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private int eBe() throws DecodingException {
        try {
            return this.tg.getInt();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Long eBf() throws DecodingException {
        try {
            return this.tg.getLong();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private LocalizedText eBg() throws DecodingException {
        try {
            byte by = this.tg.get();
            String string = null;
            String string2 = null;
            if ((by & 1) == 1) {
                string = this.eBl();
            }
            if ((by & 2) == 2) {
                string2 = this.eBl();
            }
            return LocalizedText.from(string2, string);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private NodeId eBh() throws DecodingException {
        try {
            byte by = this.tg.get();
            switch (by) {
                case 0: {
                    return new NodeId(0, UnsignedInteger.getFromBits(this.tg.get() & 0xFF));
                }
                case 1: {
                    return new NodeId(this.tg.get() & 0xFF, UnsignedInteger.getFromBits(this.tg.getShort() & 0xFFFF));
                }
                case 2: {
                    return new NodeId(this.tg.getShort() & 0xFFFF, this.eBn());
                }
                case 3: {
                    return new NodeId(this.tg.getShort() & 0xFFFF, this.eBl());
                }
                case 4: {
                    return new NodeId(this.tg.getShort() & 0xFFFF, this.eBa());
                }
                case 5: {
                    return new NodeId(this.tg.getShort() & 0xFFFF, this.eAR());
                }
            }
            throw new DecodingException("Unsupported/unexpected NodeId Encoding byte " + by);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private QualifiedName eBi() throws DecodingException {
        UnsignedShort unsignedShort = this.eBm();
        String string = this.eBl();
        return QualifiedName.from(unsignedShort, string);
    }

    private Byte eBj() throws DecodingException {
        try {
            return this.tg.get();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private StatusCode eBk() throws DecodingException {
        return StatusCode.valueOf(this.eBn());
    }

    private String eBl() throws DecodingException {
        try {
            int n2 = this.tg.getInt();
            if (n2 == -1) {
                return null;
            }
            if (n2 == 0) {
                return "";
            }
            this.assertStringLength(n2);
            byte[] byArray = new byte[n2];
            this.tg.get(byArray);
            return new String(byArray, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Structure a(StructureSpecification structureSpecification) throws DecodingException {
        switch (structureSpecification.getStructureType()) {
            case OPTIONAL: {
                return this.d(structureSpecification);
            }
            case UNION: 
            case UNION_SUBTYPES: {
                return this.e(structureSpecification);
            }
            case SUBTYPES: {
                return this.b(structureSpecification);
            }
            case NORMAL: {
                return this.c(structureSpecification);
            }
        }
        throw new DecodingException("Unknown StructureType: " + (Object)((Object)structureSpecification.getStructureType()));
    }

    private Structure b(StructureSpecification structureSpecification) throws DecodingException {
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            logger.trace("Field: {}", (Object)fieldSpecification);
            builder.set(fieldSpecification, this.b(fieldSpecification));
        }
        return builder.build();
    }

    private Object b(FieldSpecification fieldSpecification) throws DecodingException {
        Object object2;
        if (!fieldSpecification.isAllowSubTypes()) {
            return this.c(fieldSpecification);
        }
        if (Structure.class.isAssignableFrom(fieldSpecification.getCompositeClass())) {
            object2 = this.a(this.get(null, UaIds.Structure, fieldSpecification.getJavaClassDimensions()), fieldSpecification.getCompositeClass());
        } else {
            try {
                object2 = MultiDimensionArrayUtils.map(this.get(null, UaIds.BaseDataType, fieldSpecification.getJavaClassDimensions()), Object.class, fieldSpecification.getCompositeClass(), object -> object);
            }
            catch (ClassCastException classCastException) {
                throw new DecodingException("Cannot resolve BaseDataType-encoded field to proper type, field " + fieldSpecification, classCastException);
            }
        }
        BiConsumer<FieldSpecification, Object> biConsumer = this.th;
        if (biConsumer != null) {
            biConsumer.accept(fieldSpecification, object2);
        }
        return object2;
    }

    private Object c(FieldSpecification fieldSpecification) throws DecodingException {
        Object object;
        Object object2;
        if (UaIds.Structure.equals(fieldSpecification.getDataTypeId())) {
            object2 = this.a(this.get(null, UaIds.Structure, fieldSpecification.getJavaClassDimensions()), Structure.class);
        } else {
            object = this.get(null, fieldSpecification.getDataTypeId(), fieldSpecification.getJavaClassDimensions());
            if (Object.class.equals(fieldSpecification.getCompositeClass()) && object != null && object.getClass().isArray() && Variant.class.equals(MultiDimensionArrayUtils.getComponentType(object.getClass()))) {
                object = MultiDimensionArrayUtils.map(object, Variant.class, Object.class, variant -> variant == null ? null : variant.getValue());
            }
            object2 = object;
        }
        object = this.th;
        if (object != null) {
            object.accept(fieldSpecification, object2);
        }
        return object2;
    }

    private Structure c(StructureSpecification structureSpecification) throws DecodingException {
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        boolean bl = logger.isTraceEnabled();
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            if (bl) {
                logger.trace("Field: {}", (Object)fieldSpecification);
            }
            InternalStructureUtils.setBuilderFieldUnsafe(builder, fieldSpecification, this.c(fieldSpecification));
        }
        return builder.build();
    }

    private Structure d(StructureSpecification structureSpecification) throws DecodingException {
        UnsignedInteger unsignedInteger = null;
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        unsignedInteger = this.eBn();
        logger.trace("EncodingMask: {}", (Object)unsignedInteger);
        int n2 = -1;
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            logger.trace("Field: {}", (Object)fieldSpecification);
            if (fieldSpecification.isOptional()) {
                if (!BinaryDecoder.a(unsignedInteger, ++n2)) continue;
                builder.set(fieldSpecification, this.c(fieldSpecification));
                continue;
            }
            builder.set(fieldSpecification, this.c(fieldSpecification));
        }
        return builder.build();
    }

    private Structure e(StructureSpecification structureSpecification) throws DecodingException {
        UnsignedInteger unsignedInteger = this.eBn();
        Structure.Builder builder = structureSpecification.toInstanceBuilder();
        long l2 = unsignedInteger.longValue();
        logger.trace("SwitchField: {}", (Object)l2);
        if (l2 < 0L) {
            throw new DecodingException("Union SwitchField must be >= 0");
        }
        if (l2 == 0L) {
            return builder.build();
        }
        long l3 = 0L;
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            if (l2 != ++l3) continue;
            logger.trace("Decoded Union Field: {}, SwitchValue: {}", (Object)fieldSpecification, (Object)l3);
            builder.set(fieldSpecification, this.b(fieldSpecification));
            return builder.build();
        }
        throw new DecodingException("Union SwitchField overflow: " + ++l3);
    }

    private UnsignedShort eBm() throws DecodingException {
        try {
            return UnsignedShort.getFromBits(this.tg.getShort());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UnsignedInteger eBn() throws DecodingException {
        try {
            return UnsignedInteger.getFromBits(this.tg.getInt());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private UnsignedLong eBo() throws DecodingException {
        try {
            return UnsignedLong.getFromBits(this.tg.getLong());
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Variant eBp() throws DecodingException {
        try {
            boolean bl;
            boolean bl2;
            byte by = this.tg.get();
            int n2 = by & 0x3F;
            boolean bl3 = (by & 0x80) == 128;
            boolean bl4 = (by & 0x40) == 64;
            boolean bl5 = bl2 = n2 == 0;
            if (n2 > 25) {
                n2 = 15;
            }
            Object object = bl2 ? null : (bl3 ? this.m(n2) : this.n(n2));
            int[] nArray = bl4 ? this.getInt32Array_(null) : null;
            boolean bl6 = bl = bl3 && nArray != null && nArray.length > 1;
            if (bl4) {
                long l2;
                long l3;
                if (nArray != null && nArray.length != 0) {
                    l3 = 1L;
                    for (int n3 : nArray) {
                        l3 *= (long)n3;
                    }
                } else {
                    l3 = nArray == null ? -1L : 0L;
                }
                Object[] objectArray = object;
                long l4 = l2 = objectArray == null ? -1L : (long)objectArray.length;
                if (l2 != l3) {
                    throw new DecodingException("Variant's ArrayDimensions " + Arrays.toString(nArray) + " total size of " + l3 + " does not match defined ArrayLength of " + l2 + ". Variant value was: " + MultiDimensionArrayUtils.toString(object, this.ctx));
                }
            }
            if (object instanceof ExtensionObject && this.a((ExtensionObject)object)) {
                try {
                    object = this.d((ByteString)((ExtensionObject)object).getObject());
                }
                catch (ClassCastException classCastException) {
                    throw new DecodingException("Did not get an ExtensionObject with ByteString data for Decimal type", classCastException);
                }
            }
            if (object instanceof ExtensionObject) {
                ExtensionObject extensionObject = (ExtensionObject)object;
                try {
                    object = extensionObject.decode(this.ctx);
                }
                catch (DecodingException exception) {
                    object = extensionObject;
                }
            }
            if (bl3) {
                if (object instanceof ExtensionObject[]) {
                    object = this.a((ExtensionObject[])object);
                }
                if (object instanceof ExtensionObject[]) {
                    ExtensionObject[] extensionObjectArray = object;
                    try {
                        object = this.ctx.decode(extensionObjectArray);
                    }
                    catch (Exception exception) {
                        object = extensionObjectArray;
                    }
                }
                if (bl) {
                    try {
                        object = MultiDimensionArrayUtils.demuxArray(object, nArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new DecodingException("The length of ArrayDimensions-field does not match Value-field");
                    }
                }
            }
            return new Variant(object);
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    private Object m(int n2) throws DecodingException {
        switch (n2) {
            case 1: {
                return this.getBooleanArray(null);
            }
            case 2: {
                return this.getSByteArray(null);
            }
            case 3: {
                return this.getByteArray(null);
            }
            case 4: {
                return this.getInt16Array(null);
            }
            case 5: {
                return this.getUInt16Array(null);
            }
            case 6: {
                return this.getInt32Array(null);
            }
            case 7: {
                return this.getUInt32Array(null);
            }
            case 8: {
                return this.getInt64Array(null);
            }
            case 9: {
                return this.getUInt64Array(null);
            }
            case 10: {
                return this.getFloatArray(null);
            }
            case 11: {
                return this.getDoubleArray(null);
            }
            case 12: {
                return this.getStringArray(null);
            }
            case 13: {
                return this.getDateTimeArray(null);
            }
            case 14: {
                return this.getGuidArray(null);
            }
            case 15: {
                return this.getByteStringArray(null);
            }
            case 16: {
                return this.getXmlElementArray(null);
            }
            case 17: {
                return this.getNodeIdArray(null);
            }
            case 18: {
                return this.getExpandedNodeIdArray(null);
            }
            case 19: {
                return this.getStatusCodeArray(null);
            }
            case 20: {
                return this.getQualifiedNameArray(null);
            }
            case 21: {
                return this.getLocalizedTextArray(null);
            }
            case 22: {
                return this.getExtensionObjectArray(null);
            }
            case 23: {
                return this.getDataValueArray(null);
            }
            case 24: {
                return this.getVariantArray(null);
            }
            case 25: {
                return this.getDiagnosticInfoArray(null);
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    private Object n(int n2) throws DecodingException {
        switch (n2) {
            case 1: {
                return this.eAP();
            }
            case 2: {
                return this.eBj();
            }
            case 3: {
                return this.eAQ();
            }
            case 4: {
                return this.eBb();
            }
            case 5: {
                return this.eBm();
            }
            case 6: {
                return this.eBc();
            }
            case 7: {
                return this.eBn();
            }
            case 8: {
                return this.eBf();
            }
            case 9: {
                return this.eBo();
            }
            case 10: {
                return this.eAZ();
            }
            case 11: {
                return this.eAW();
            }
            case 12: {
                return this.eBl();
            }
            case 13: {
                return this.eAT();
            }
            case 14: {
                return this.eBa();
            }
            case 15: {
                return this.eAR();
            }
            case 16: {
                return this.eBq();
            }
            case 17: {
                return this.eBh();
            }
            case 18: {
                return this.eAX();
            }
            case 19: {
                return this.eBk();
            }
            case 20: {
                return this.eBi();
            }
            case 21: {
                return this.eBg();
            }
            case 22: {
                return this.eAY();
            }
            case 23: {
                return this.eAS();
            }
            case 24: {
                return this.eBp();
            }
            case 25: {
                return this.eAV();
            }
        }
        throw new DecodingException("Cannot decode builtin type id " + n2);
    }

    private XmlElement eBq() throws DecodingException {
        ByteString byteString = this.eAR();
        if (byteString == null) {
            return null;
        }
        return new XmlElement(ByteString.asByteArray(byteString));
    }

    private boolean a(ExtensionObject extensionObject) {
        if (extensionObject == null) {
            return false;
        }
        return this.ctx.getNamespaceTable().nodeIdEquals(Identifiers.Decimal, extensionObject.getTypeId());
    }

    private Object a(ExtensionObject[] extensionObjectArray) {
        BigDecimal[] bigDecimalArray = new BigDecimal[extensionObjectArray.length];
        for (int i2 = 0; i2 < extensionObjectArray.length; ++i2) {
            ExtensionObject extensionObject = extensionObjectArray[i2];
            if (!this.a(extensionObject)) {
                return extensionObjectArray;
            }
            bigDecimalArray[i2] = this.d((ByteString)extensionObject.getObject());
        }
        return bigDecimalArray;
    }

    protected long remaining() throws DecodingException {
        try {
            return this.tg.limit() - this.tg.position();
        }
        catch (IOException iOException) {
            throw BinaryDecoder.a(iOException);
        }
    }

    static {
        tf = new ExpandedNodeId("http://opcfoundation.org/UA/", Identifiers.Decimal.getValue());
        BinaryDecoder.b(UaIds.Boolean, Boolean.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAP());
        BinaryDecoder.b(UaIds.SByte, Byte.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBj());
        BinaryDecoder.b(UaIds.Byte, UnsignedByte.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAQ());
        BinaryDecoder.b(UaIds.Int16, Short.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBb());
        BinaryDecoder.b(UaIds.UInt16, UnsignedShort.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBm());
        BinaryDecoder.b(UaIds.Int32, Integer.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBc());
        BinaryDecoder.b(UaIds.UInt32, UnsignedInteger.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBn());
        BinaryDecoder.b(UaIds.Int64, Long.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBf());
        BinaryDecoder.b(UaIds.UInt64, UnsignedLong.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBo());
        BinaryDecoder.b(UaIds.Float, Float.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAZ());
        BinaryDecoder.b(UaIds.Double, Double.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAW());
        BinaryDecoder.b(UaIds.String, String.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBl());
        BinaryDecoder.b(UaIds.Guid, UUID.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBa());
        BinaryDecoder.b(UaIds.ByteString, ByteString.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAR());
        BinaryDecoder.b(UaIds.XmlElement, XmlElement.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBq());
        BinaryDecoder.b(UaIds.NodeId, NodeId.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBh());
        BinaryDecoder.b(UaIds.ExpandedNodeId, ExpandedNodeId.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAX());
        BinaryDecoder.b(UaIds.StatusCode, StatusCode.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBk());
        BinaryDecoder.b(UaIds.QualifiedName, QualifiedName.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBi());
        BinaryDecoder.b(UaIds.LocalizedText, LocalizedText.class, (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBg());
        sV = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAT();
        BinaryDecoder.a(UaIds.DateTime, DateTime.class, sV);
        sW = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAY();
        BinaryDecoder.a(UaIds.Structure, ExtensionObject.class, sW);
        sX = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> {
            if (uaDataTypeSpecification != null) {
                return binaryDecoder.a((StructureSpecification)uaDataTypeSpecification);
            }
            if (uaNodeId == null) {
                throw new DecodingException("DataTypeId is null, class: " + clazz);
            }
            StructureSpecification structureSpecification = binaryDecoder.getEncoderContext().getStructureSpecification(uaNodeId);
            if (structureSpecification == null) {
                throw new DecodingException("Cannot find StructureSpecification for DataType: " + uaNodeId);
            }
            return binaryDecoder.a(structureSpecification);
        };
        sZ = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAS();
        BinaryDecoder.a(UaIds.DataValue, DataValue.class, sZ);
        ta = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eBp();
        tb = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAV();
        BinaryDecoder.a(UaIds.DiagnosticInfo, DiagnosticInfo.class, tb);
        tc = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> {
            if (uaDataTypeSpecification != null) {
                return binaryDecoder.a((EnumerationSpecification)uaDataTypeSpecification);
            }
            if (uaNodeId == null) {
                throw new DecodingException("DataTypeId is null, class: " + clazz);
            }
            EnumerationSpecification enumerationSpecification = binaryDecoder.getEncoderContext().getEnumerationSpecification(uaNodeId);
            if (enumerationSpecification == null) {
                throw new DecodingException("Cannot find EnumerationSpecification for DataType: " + uaNodeId);
            }
            return binaryDecoder.a((EnumerationSpecification)uaDataTypeSpecification);
        };
        td = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> binaryDecoder.eAU();
        BinaryDecoder.a(UaIds.Decimal, BigDecimal.class, td);
        te = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> {
            if (uaDataTypeSpecification != null) {
                return binaryDecoder.a((OptionSetSpecification)uaDataTypeSpecification);
            }
            if (uaNodeId == null) {
                throw new DecodingException("DataTypeId is null, class: " + clazz);
            }
            OptionSetSpecification optionSetSpecification = binaryDecoder.getEncoderContext().getOptionSetSpecification(uaNodeId);
            if (optionSetSpecification == null) {
                throw new DecodingException("Cannot resolve OptionSetSpecification for: " + uaNodeId);
            }
            return binaryDecoder.a(optionSetSpecification);
        };
        sY = (binaryDecoder, string, clazz, uaNodeId, uaDataTypeSpecification) -> ta.get(binaryDecoder, string, Variant.class, uaNodeId, uaDataTypeSpecification).getValue();
        BinaryDecoder.b(null, Object.class, sY);
        BinaryDecoder.sT[24] = sY;
        BinaryDecoder.sU[24] = Object.class;
        BinaryDecoder.sT[22] = sW;
        BinaryDecoder.sU[22] = ExtensionObject.class;
    }

    private static interface a<T> {
        public T get(BinaryDecoder var1, String var2, Class<? extends T> var3, UaNodeId var4, UaDataTypeSpecification var5) throws DecodingException;
    }
}

