/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.StructureField;
import com.prosysopc.ua.stack.core.StructureType;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=99")
public class StructureDefinition
extends DataTypeDefinition {
    public static final StructureSpecification SPECIFICATION;

    public StructureDefinition() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected StructureDefinition(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public StructureDefinition(NodeId nodeId, NodeId nodeId2, StructureType structureType, StructureField[] structureFieldArray) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setDefaultEncodingId(nodeId);
        this.setBaseDataType(nodeId2);
        this.setStructureType(structureType);
        this.setFields(structureFieldArray);
    }

    public NodeId getDefaultEncodingId() {
        return (NodeId)this.indexGet(0);
    }

    public void setDefaultEncodingId(NodeId nodeId) {
        this.indexSet(nodeId, 0);
    }

    public NodeId getBaseDataType() {
        return (NodeId)this.indexGet(1);
    }

    public void setBaseDataType(NodeId nodeId) {
        this.indexSet(nodeId, 1);
    }

    public StructureType getStructureType() {
        return (StructureType)this.indexGet(2);
    }

    public void setStructureType(StructureType structureType) {
        this.indexSet(structureType, 2);
    }

    public StructureField[] getFields() {
        return (StructureField[])this.indexGet(3);
    }

    public void setFields(StructureField[] structureFieldArray) {
        this.indexSet(structureFieldArray, 3);
    }

    @Override
    public StructureDefinition clone() {
        return (StructureDefinition)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new StructureDefinition());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.DefaultEncodingId);
        builder.addField(Fields.BaseDataType);
        builder.addField(Fields.StructureType);
        builder.addField(Fields.Fields);
        builder.setBinaryEncodeId(UaIds.StructureDefinition_DefaultBinary);
        builder.setXmlEncodeId(UaIds.StructureDefinition_DefaultXml);
        builder.setJsonEncodeId(UaIds.StructureDefinition_DefaultJson);
        builder.setTypeId(UaIds.StructureDefinition);
        builder.addSuperTypeId(UaIds.Structure);
        builder.addSuperTypeId(UaIds.DataTypeDefinition);
        builder.setName("StructureDefinition");
        builder.setJavaClass(StructureDefinition.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new StructureDefinition((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(StructureDefinition.class, SPECIFICATION);
    }

    public static class Builder
    extends DataTypeDefinition.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public NodeId getDefaultEncodingId() {
            return (NodeId)this.indexGet(0);
        }

        public Builder setDefaultEncodingId(NodeId nodeId) {
            this.indexSet(nodeId, 0);
            return this;
        }

        public NodeId getBaseDataType() {
            return (NodeId)this.indexGet(1);
        }

        public Builder setBaseDataType(NodeId nodeId) {
            this.indexSet(nodeId, 1);
            return this;
        }

        public StructureType getStructureType() {
            return (StructureType)this.indexGet(2);
        }

        public Builder setStructureType(StructureType structureType) {
            this.indexSet(structureType, 2);
            return this;
        }

        public StructureField[] getFields() {
            return (StructureField[])this.indexGet(3);
        }

        public Builder setFields(StructureField[] structureFieldArray) {
            this.indexSet(structureFieldArray, 3);
            return this;
        }

        @Override
        public StructureDefinition build() {
            return (StructureDefinition)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        DefaultEncodingId(0, "DefaultEncodingId", NodeId.class, false, UaIds.NodeId, -1, null, false, 0),
        BaseDataType(1, "BaseDataType", NodeId.class, false, UaIds.NodeId, -1, null, false, 0),
        StructureType(2, "StructureType", StructureType.class, false, UaIds.StructureType, -1, null, false, 0),
        Fields(3, "Fields", StructureField[].class, false, UaIds.StructureField, 1, UaArrayDimensions.valueOf(0L), false, 1);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

