/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=868")
public class SessionSecurityDiagnosticsDataType
extends DynamicStructure {
    public static final StructureSpecification SPECIFICATION;

    public SessionSecurityDiagnosticsDataType() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected SessionSecurityDiagnosticsDataType(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public SessionSecurityDiagnosticsDataType(NodeId nodeId, String string, String[] stringArray, String string2, String string3, String string4, MessageSecurityMode messageSecurityMode, String string5, ByteString byteString) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setSessionId(nodeId);
        this.setClientUserIdOfSession(string);
        this.setClientUserIdHistory(stringArray);
        this.setAuthenticationMechanism(string2);
        this.setEncoding(string3);
        this.setTransportProtocol(string4);
        this.setSecurityMode(messageSecurityMode);
        this.setSecurityPolicyUri(string5);
        this.setClientCertificate(byteString);
    }

    public NodeId getSessionId() {
        return (NodeId)this.indexGet(0);
    }

    public void setSessionId(NodeId nodeId) {
        this.indexSet(nodeId, 0);
    }

    public String getClientUserIdOfSession() {
        return (String)this.indexGet(1);
    }

    public void setClientUserIdOfSession(String string) {
        this.indexSet(string, 1);
    }

    public String[] getClientUserIdHistory() {
        return (String[])this.indexGet(2);
    }

    public void setClientUserIdHistory(String[] stringArray) {
        this.indexSet(stringArray, 2);
    }

    public String getAuthenticationMechanism() {
        return (String)this.indexGet(3);
    }

    public void setAuthenticationMechanism(String string) {
        this.indexSet(string, 3);
    }

    public String getEncoding() {
        return (String)this.indexGet(4);
    }

    public void setEncoding(String string) {
        this.indexSet(string, 4);
    }

    public String getTransportProtocol() {
        return (String)this.indexGet(5);
    }

    public void setTransportProtocol(String string) {
        this.indexSet(string, 5);
    }

    public MessageSecurityMode getSecurityMode() {
        return (MessageSecurityMode)this.indexGet(6);
    }

    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.indexSet(messageSecurityMode, 6);
    }

    public String getSecurityPolicyUri() {
        return (String)this.indexGet(7);
    }

    public void setSecurityPolicyUri(String string) {
        this.indexSet(string, 7);
    }

    public ByteString getClientCertificate() {
        return (ByteString)this.indexGet(8);
    }

    public void setClientCertificate(ByteString byteString) {
        this.indexSet(byteString, 8);
    }

    @Override
    public SessionSecurityDiagnosticsDataType clone() {
        return (SessionSecurityDiagnosticsDataType)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new SessionSecurityDiagnosticsDataType());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.SessionId);
        builder.addField(Fields.ClientUserIdOfSession);
        builder.addField(Fields.ClientUserIdHistory);
        builder.addField(Fields.AuthenticationMechanism);
        builder.addField(Fields.Encoding);
        builder.addField(Fields.TransportProtocol);
        builder.addField(Fields.SecurityMode);
        builder.addField(Fields.SecurityPolicyUri);
        builder.addField(Fields.ClientCertificate);
        builder.setBinaryEncodeId(UaIds.SessionSecurityDiagnosticsDataType_DefaultBinary);
        builder.setXmlEncodeId(UaIds.SessionSecurityDiagnosticsDataType_DefaultXml);
        builder.setJsonEncodeId(UaIds.SessionSecurityDiagnosticsDataType_DefaultJson);
        builder.setTypeId(UaIds.SessionSecurityDiagnosticsDataType);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("SessionSecurityDiagnosticsDataType");
        builder.setJavaClass(SessionSecurityDiagnosticsDataType.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new SessionSecurityDiagnosticsDataType((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(SessionSecurityDiagnosticsDataType.class, SPECIFICATION);
    }

    public static class Builder
    extends DynamicStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public NodeId getSessionId() {
            return (NodeId)this.indexGet(0);
        }

        public Builder setSessionId(NodeId nodeId) {
            this.indexSet(nodeId, 0);
            return this;
        }

        public String getClientUserIdOfSession() {
            return (String)this.indexGet(1);
        }

        public Builder setClientUserIdOfSession(String string) {
            this.indexSet(string, 1);
            return this;
        }

        public String[] getClientUserIdHistory() {
            return (String[])this.indexGet(2);
        }

        public Builder setClientUserIdHistory(String[] stringArray) {
            this.indexSet(stringArray, 2);
            return this;
        }

        public String getAuthenticationMechanism() {
            return (String)this.indexGet(3);
        }

        public Builder setAuthenticationMechanism(String string) {
            this.indexSet(string, 3);
            return this;
        }

        public String getEncoding() {
            return (String)this.indexGet(4);
        }

        public Builder setEncoding(String string) {
            this.indexSet(string, 4);
            return this;
        }

        public String getTransportProtocol() {
            return (String)this.indexGet(5);
        }

        public Builder setTransportProtocol(String string) {
            this.indexSet(string, 5);
            return this;
        }

        public MessageSecurityMode getSecurityMode() {
            return (MessageSecurityMode)this.indexGet(6);
        }

        public Builder setSecurityMode(MessageSecurityMode messageSecurityMode) {
            this.indexSet(messageSecurityMode, 6);
            return this;
        }

        public String getSecurityPolicyUri() {
            return (String)this.indexGet(7);
        }

        public Builder setSecurityPolicyUri(String string) {
            this.indexSet(string, 7);
            return this;
        }

        public ByteString getClientCertificate() {
            return (ByteString)this.indexGet(8);
        }

        public Builder setClientCertificate(ByteString byteString) {
            this.indexSet(byteString, 8);
            return this;
        }

        @Override
        public SessionSecurityDiagnosticsDataType build() {
            return (SessionSecurityDiagnosticsDataType)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        SessionId(0, "SessionId", NodeId.class, false, UaIds.NodeId, -1, null, false, 0),
        ClientUserIdOfSession(1, "ClientUserIdOfSession", String.class, false, UaIds.String, -1, null, false, 0),
        ClientUserIdHistory(2, "ClientUserIdHistory", String[].class, false, UaIds.String, 1, UaArrayDimensions.valueOf(0L), false, 1),
        AuthenticationMechanism(3, "AuthenticationMechanism", String.class, false, UaIds.String, -1, null, false, 0),
        Encoding(4, "Encoding", String.class, false, UaIds.String, -1, null, false, 0),
        TransportProtocol(5, "TransportProtocol", String.class, false, UaIds.String, -1, null, false, 0),
        SecurityMode(6, "SecurityMode", MessageSecurityMode.class, false, UaIds.MessageSecurityMode, -1, null, false, 0),
        SecurityPolicyUri(7, "SecurityPolicyUri", String.class, false, UaIds.String, -1, null, false, 0),
        ClientCertificate(8, "ClientCertificate", ByteString.class, false, UaIds.ByteString, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

