/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.BuildInfo;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=862")
public class ServerStatusDataType
extends DynamicStructure {
    public static final StructureSpecification SPECIFICATION;

    public ServerStatusDataType() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected ServerStatusDataType(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public ServerStatusDataType(DateTime dateTime, DateTime dateTime2, ServerState serverState, BuildInfo buildInfo, UnsignedInteger unsignedInteger, LocalizedText localizedText) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setStartTime(dateTime);
        this.setCurrentTime(dateTime2);
        this.setState(serverState);
        this.setBuildInfo(buildInfo);
        this.setSecondsTillShutdown(unsignedInteger);
        this.setShutdownReason(localizedText);
    }

    public DateTime getStartTime() {
        return (DateTime)this.indexGet(0);
    }

    public void setStartTime(DateTime dateTime) {
        this.indexSet(dateTime, 0);
    }

    public DateTime getCurrentTime() {
        return (DateTime)this.indexGet(1);
    }

    public void setCurrentTime(DateTime dateTime) {
        this.indexSet(dateTime, 1);
    }

    public ServerState getState() {
        return (ServerState)this.indexGet(2);
    }

    public void setState(ServerState serverState) {
        this.indexSet(serverState, 2);
    }

    public BuildInfo getBuildInfo() {
        return (BuildInfo)this.indexGet(3);
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.indexSet(buildInfo, 3);
    }

    public UnsignedInteger getSecondsTillShutdown() {
        return (UnsignedInteger)this.indexGet(4);
    }

    public void setSecondsTillShutdown(UnsignedInteger unsignedInteger) {
        this.indexSet(unsignedInteger, 4);
    }

    public LocalizedText getShutdownReason() {
        return (LocalizedText)this.indexGet(5);
    }

    public void setShutdownReason(LocalizedText localizedText) {
        this.indexSet(localizedText, 5);
    }

    @Override
    public ServerStatusDataType clone() {
        return (ServerStatusDataType)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new ServerStatusDataType());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.StartTime);
        builder.addField(Fields.CurrentTime);
        builder.addField(Fields.State);
        builder.addField(Fields.BuildInfo);
        builder.addField(Fields.SecondsTillShutdown);
        builder.addField(Fields.ShutdownReason);
        builder.setBinaryEncodeId(UaIds.ServerStatusDataType_DefaultBinary);
        builder.setXmlEncodeId(UaIds.ServerStatusDataType_DefaultXml);
        builder.setJsonEncodeId(UaIds.ServerStatusDataType_DefaultJson);
        builder.setTypeId(UaIds.ServerStatusDataType);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("ServerStatusDataType");
        builder.setJavaClass(ServerStatusDataType.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new ServerStatusDataType((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(ServerStatusDataType.class, SPECIFICATION);
    }

    public static class Builder
    extends DynamicStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public DateTime getStartTime() {
            return (DateTime)this.indexGet(0);
        }

        public Builder setStartTime(DateTime dateTime) {
            this.indexSet(dateTime, 0);
            return this;
        }

        public DateTime getCurrentTime() {
            return (DateTime)this.indexGet(1);
        }

        public Builder setCurrentTime(DateTime dateTime) {
            this.indexSet(dateTime, 1);
            return this;
        }

        public ServerState getState() {
            return (ServerState)this.indexGet(2);
        }

        public Builder setState(ServerState serverState) {
            this.indexSet(serverState, 2);
            return this;
        }

        public BuildInfo getBuildInfo() {
            return (BuildInfo)this.indexGet(3);
        }

        public Builder setBuildInfo(BuildInfo buildInfo) {
            this.indexSet(buildInfo, 3);
            return this;
        }

        public UnsignedInteger getSecondsTillShutdown() {
            return (UnsignedInteger)this.indexGet(4);
        }

        public Builder setSecondsTillShutdown(UnsignedInteger unsignedInteger) {
            this.indexSet(unsignedInteger, 4);
            return this;
        }

        public LocalizedText getShutdownReason() {
            return (LocalizedText)this.indexGet(5);
        }

        public Builder setShutdownReason(LocalizedText localizedText) {
            this.indexSet(localizedText, 5);
            return this;
        }

        @Override
        public ServerStatusDataType build() {
            return (ServerStatusDataType)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        StartTime(0, "StartTime", DateTime.class, false, UaIds.UtcTime, -1, null, false, 0),
        CurrentTime(1, "CurrentTime", DateTime.class, false, UaIds.UtcTime, -1, null, false, 0),
        State(2, "State", ServerState.class, false, UaIds.ServerState, -1, null, false, 0),
        BuildInfo(3, "BuildInfo", BuildInfo.class, false, UaIds.BuildInfo, -1, null, false, 0),
        SecondsTillShutdown(4, "SecondsTillShutdown", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false, 0),
        ShutdownReason(5, "ShutdownReason", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

