/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.AggregateConfiguration;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=650")
public class ReadProcessedDetails
extends HistoryReadDetails {
    public static final StructureSpecification SPECIFICATION;

    public ReadProcessedDetails() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected ReadProcessedDetails(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public ReadProcessedDetails(DateTime dateTime, DateTime dateTime2, Double d2, NodeId[] nodeIdArray, AggregateConfiguration aggregateConfiguration) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setStartTime(dateTime);
        this.setEndTime(dateTime2);
        this.setProcessingInterval(d2);
        this.setAggregateType(nodeIdArray);
        this.setAggregateConfiguration(aggregateConfiguration);
    }

    public DateTime getStartTime() {
        return (DateTime)this.indexGet(0);
    }

    public void setStartTime(DateTime dateTime) {
        this.indexSet(dateTime, 0);
    }

    public DateTime getEndTime() {
        return (DateTime)this.indexGet(1);
    }

    public void setEndTime(DateTime dateTime) {
        this.indexSet(dateTime, 1);
    }

    public Double getProcessingInterval() {
        return (Double)this.indexGet(2);
    }

    public void setProcessingInterval(Double d2) {
        this.indexSet(d2, 2);
    }

    public NodeId[] getAggregateType() {
        return (NodeId[])this.indexGet(3);
    }

    public void setAggregateType(NodeId[] nodeIdArray) {
        this.indexSet(nodeIdArray, 3);
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return (AggregateConfiguration)this.indexGet(4);
    }

    public void setAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
        this.indexSet(aggregateConfiguration, 4);
    }

    @Override
    public ReadProcessedDetails clone() {
        return (ReadProcessedDetails)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new ReadProcessedDetails());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.StartTime);
        builder.addField(Fields.EndTime);
        builder.addField(Fields.ProcessingInterval);
        builder.addField(Fields.AggregateType);
        builder.addField(Fields.AggregateConfiguration);
        builder.setBinaryEncodeId(UaIds.ReadProcessedDetails_DefaultBinary);
        builder.setXmlEncodeId(UaIds.ReadProcessedDetails_DefaultXml);
        builder.setJsonEncodeId(UaIds.ReadProcessedDetails_DefaultJson);
        builder.setTypeId(UaIds.ReadProcessedDetails);
        builder.addSuperTypeId(UaIds.Structure);
        builder.addSuperTypeId(UaIds.HistoryReadDetails);
        builder.setName("ReadProcessedDetails");
        builder.setJavaClass(ReadProcessedDetails.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new ReadProcessedDetails((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(ReadProcessedDetails.class, SPECIFICATION);
    }

    public static class Builder
    extends HistoryReadDetails.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public DateTime getStartTime() {
            return (DateTime)this.indexGet(0);
        }

        public Builder setStartTime(DateTime dateTime) {
            this.indexSet(dateTime, 0);
            return this;
        }

        public DateTime getEndTime() {
            return (DateTime)this.indexGet(1);
        }

        public Builder setEndTime(DateTime dateTime) {
            this.indexSet(dateTime, 1);
            return this;
        }

        public Double getProcessingInterval() {
            return (Double)this.indexGet(2);
        }

        public Builder setProcessingInterval(Double d2) {
            this.indexSet(d2, 2);
            return this;
        }

        public NodeId[] getAggregateType() {
            return (NodeId[])this.indexGet(3);
        }

        public Builder setAggregateType(NodeId[] nodeIdArray) {
            this.indexSet(nodeIdArray, 3);
            return this;
        }

        public AggregateConfiguration getAggregateConfiguration() {
            return (AggregateConfiguration)this.indexGet(4);
        }

        public Builder setAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
            this.indexSet(aggregateConfiguration, 4);
            return this;
        }

        @Override
        public ReadProcessedDetails build() {
            return (ReadProcessedDetails)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        StartTime(0, "StartTime", DateTime.class, false, UaIds.UtcTime, -1, null, false, 0),
        EndTime(1, "EndTime", DateTime.class, false, UaIds.UtcTime, -1, null, false, 0),
        ProcessingInterval(2, "ProcessingInterval", Double.class, false, UaIds.Duration, -1, null, false, 0),
        AggregateType(3, "AggregateType", NodeId[].class, false, UaIds.NodeId, 1, UaArrayDimensions.valueOf(0L), false, 1),
        AggregateConfiguration(4, "AggregateConfiguration", AggregateConfiguration.class, false, UaIds.AggregateConfiguration, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

