/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetStructure;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Optional;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12755")
public class OptionSet
extends AbstractStructure
implements UaOptionSet,
OptionSetStructure {
    public static final OptionSetStructureSpecification SPECIFICATION;

    public OptionSet() {
        super(SPECIFICATION);
    }

    public OptionSet(ByteString byteString, ByteString byteString2) {
        super(SPECIFICATION);
        this.setValue(byteString);
        this.setValidBits(byteString2);
    }

    protected OptionSet(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
        if (!(uaDataTypeSpecification instanceof OptionSetStructureSpecification)) {
            throw new IllegalStateException("Expected OptionSetStructureSpecification, but got: " + uaDataTypeSpecification);
        }
    }

    @Override
    public OptionSet clone() {
        return (OptionSet)super.clone();
    }

    @Override
    public boolean contains(OptionSpecification ... optionSpecificationArray) {
        if (optionSpecificationArray == null) {
            throw new IllegalArgumentException("Null array value not permitted");
        }
        if (optionSpecificationArray.length == 0) {
            return true;
        }
        for (OptionSpecification optionSpecification : Arrays.asList(optionSpecificationArray)) {
            if (this.isValid(optionSpecification)) {
                if (this.getValue().isBitSet(optionSpecification.getBitPosition())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public ByteString getValidBits() {
        return (ByteString)this.indexGet(Fields.ValidBits.getFieldIndex());
    }

    @Override
    public ByteString getValue() {
        return (ByteString)this.indexGet(Fields.Value.getFieldIndex());
    }

    @Override
    public boolean isBitSet(int n2) {
        if (this.getValue() == null) {
            return false;
        }
        return this.getValue().isBitSet(n2);
    }

    @Override
    public final boolean isValid(int n2) {
        if (this.getValidBits() == null) {
            return false;
        }
        return this.getValidBits().isBitSet(n2);
    }

    @Override
    public final boolean isValid(OptionSpecification optionSpecification) {
        if (optionSpecification == null) {
            return false;
        }
        if (!this.specification().getOptions().contains(optionSpecification)) {
            return false;
        }
        return this.isValid(optionSpecification.getBitPosition());
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Value.equals(fieldSpecification)) {
            this.setValue((ByteString)object);
            return;
        }
        if (Fields.ValidBits.equals(fieldSpecification)) {
            this.setValidBits((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void setValid(int n2, boolean bl) {
        Optional<OptionSpecification> optional = this.specification().getOptions().stream().filter(optionSpecification -> optionSpecification.getBitPosition() == n2).findFirst();
        if (optional.isPresent()) {
            this.setValid(optional.get(), bl);
        }
    }

    @Override
    public void setValid(OptionSpecification optionSpecification, boolean bl) {
        BitSet bitSet;
        if (optionSpecification == null) {
            return;
        }
        if (!this.specification().getOptions().contains(optionSpecification)) {
            return;
        }
        ByteString byteString = this.getValidBits();
        BitSet bitSet2 = bitSet = byteString == null ? new BitSet() : byteString.toBitSet();
        if (bl) {
            bitSet.set(optionSpecification.getBitPosition());
        } else {
            bitSet.clear(optionSpecification.getBitPosition());
        }
        if (byteString == null) {
            this.setValidBits(ByteString.fromBitSet(bitSet));
        } else {
            this.setValidBits(ByteString.fromBitSet(bitSet, byteString.getLength()));
        }
    }

    public void setValidBits(ByteString byteString) {
        this.indexSet(byteString, Fields.ValidBits.getFieldIndex());
    }

    public void setValue(ByteString byteString) {
        this.indexSet(byteString, Fields.Value.getFieldIndex());
    }

    @Override
    public OptionSetStructureSpecification specification() {
        return (OptionSetStructureSpecification)super.specification();
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        OptionSetStructureSpecification.Builder<OptionSetStructure.Builder> builder = OptionSetStructureSpecification.builder();
        builder.addField(Fields.Value);
        builder.addField(Fields.ValidBits);
        builder.setTypeId(UaIds.OptionSet);
        builder.setBinaryEncodeId(UaIds.OptionSet_DefaultBinary);
        builder.setXmlEncodeId(UaIds.OptionSet_DefaultXml);
        builder.setJsonEncodeId(UaIds.OptionSet_DefaultJson);
        builder.setName("OptionSet");
        builder.setJavaClass((Class)OptionSet.class);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new OptionSet()));
        SPECIFICATION = builder.build();
    }

    public static enum Fields implements FieldSpecification
    {
        Value(0, "Value", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1, false),
        ValidBits(1, "ValidBits", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1, false);

        private final FieldSpecification delegate;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, boolean bl2) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setFieldIndex(n3);
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n4);
            builder.setAllowSubTypes(bl2);
            this.delegate = builder.build();
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.delegate.getArrayDimensions();
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.delegate.getDataTypeId();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public int getFieldIndex() {
            return this.ordinal();
        }

        @Override
        public Class<?> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public int getJavaClassDimensions() {
            return 0;
        }

        @Override
        public int getMaxStringLength() {
            return this.delegate.getMaxStringLength();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public int getValueRank() {
            return this.delegate.getValueRank();
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.delegate.isAllowSubTypes();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isOptional() {
            return this.delegate.isOptional();
        }
    }

    public static class Builder
    extends AbstractStructure.Builder
    implements UaOptionSet.Builder,
    OptionSetStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
            if (!(uaDataTypeSpecification instanceof OptionSetStructureSpecification)) {
                throw new IllegalStateException("Expected OptionSetStructureSpecification, but got: " + uaDataTypeSpecification);
            }
        }

        @Override
        public Builder add(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null || optionSpecificationArray.length == 0) {
                return this;
            }
            return this.addAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public Builder addAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                return this;
            }
            ByteString byteString = this.getValue();
            BitSet bitSet = byteString == null ? new BitSet() : byteString.toBitSet();
            iterable.forEach(optionSpecification -> this.setValid((OptionSpecification)optionSpecification, true));
            for (OptionSpecification optionSpecification2 : iterable) {
                bitSet.set(optionSpecification2.getBitPosition());
            }
            if (byteString == null) {
                this.setValue(ByteString.fromBitSet(bitSet));
            } else {
                this.setValue(ByteString.fromBitSet(bitSet, byteString.getLength()));
            }
            return this;
        }

        @Override
        public OptionSet build() {
            return (OptionSet)super.build();
        }

        @Override
        public Builder clear() {
            super.clear();
            return this;
        }

        @Override
        public boolean contains(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null) {
                throw new IllegalArgumentException("Null array value not permitted");
            }
            if (optionSpecificationArray.length == 0) {
                return true;
            }
            for (OptionSpecification optionSpecification : Arrays.asList(optionSpecificationArray)) {
                if (!this.isValid(optionSpecification)) {
                    return false;
                }
                if (this.getValue() == null) {
                    return false;
                }
                if (this.getValue().isBitSet(optionSpecification.getBitPosition())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                throw new IllegalArgumentException("Null Iterable is not permitted");
            }
            for (OptionSpecification optionSpecification : iterable) {
                if (!this.isValid(optionSpecification)) {
                    return false;
                }
                if (this.getValue() == null) {
                    return false;
                }
                if (this.getValue().isBitSet(optionSpecification.getBitPosition())) continue;
                return false;
            }
            return true;
        }

        public ByteString getValidBits() {
            return (ByteString)this.indexGet(Fields.ValidBits.getFieldIndex());
        }

        public ByteString getValue() {
            return (ByteString)this.indexGet(Fields.Value.getFieldIndex());
        }

        @Override
        public final boolean isValid(int n2) {
            if (this.getValidBits() == null) {
                return false;
            }
            return this.getValidBits().isBitSet(n2);
        }

        @Override
        public final boolean isValid(OptionSpecification optionSpecification) {
            if (optionSpecification == null) {
                return false;
            }
            if (!this.specification().getOptions().contains(optionSpecification)) {
                return false;
            }
            return this.isValid(optionSpecification.getBitPosition());
        }

        @Override
        public Builder remove(OptionSpecification ... optionSpecificationArray) {
            if (optionSpecificationArray == null || optionSpecificationArray.length == 0) {
                return this;
            }
            return this.removeAll(Arrays.asList(optionSpecificationArray));
        }

        @Override
        public Builder removeAll(Iterable<? extends OptionSpecification> iterable) {
            if (iterable == null) {
                return this;
            }
            ByteString byteString = this.getValue();
            if (byteString == null || byteString.getLength() == 0) {
                return this;
            }
            iterable.forEach(optionSpecification -> this.setValid((OptionSpecification)optionSpecification, true));
            BitSet bitSet = byteString.toBitSet();
            for (OptionSpecification optionSpecification2 : iterable) {
                bitSet.clear(optionSpecification2.getBitPosition());
            }
            this.setValue(ByteString.fromBitSet(bitSet, byteString.getLength()));
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Value.equals(fieldSpecification)) {
                this.setValue((ByteString)object);
                return this;
            }
            if (Fields.ValidBits.equals(fieldSpecification)) {
                this.setValidBits((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Builder setValid(int n2, boolean bl) {
            Optional<OptionSpecification> optional = this.specification().getOptions().stream().filter(optionSpecification -> optionSpecification.getBitPosition() == n2).findFirst();
            if (optional.isPresent()) {
                return this.setValid(optional.get(), bl);
            }
            return this;
        }

        @Override
        public Builder setValid(OptionSpecification optionSpecification, boolean bl) {
            BitSet bitSet;
            if (optionSpecification == null) {
                return this;
            }
            if (!this.specification().getOptions().contains(optionSpecification)) {
                return this;
            }
            ByteString byteString = this.getValidBits();
            BitSet bitSet2 = bitSet = byteString == null ? new BitSet() : byteString.toBitSet();
            if (bl) {
                bitSet.set(optionSpecification.getBitPosition());
            } else {
                bitSet.clear(optionSpecification.getBitPosition());
            }
            if (byteString == null) {
                this.setValidBits(ByteString.fromBitSet(bitSet));
            } else {
                this.setValidBits(ByteString.fromBitSet(bitSet, byteString.getLength()));
            }
            return this;
        }

        public Builder setValidBits(ByteString byteString) {
            this.indexSet(byteString, Fields.ValidBits.getFieldIndex());
            return this;
        }

        public Builder setValue(ByteString byteString) {
            this.indexSet(byteString, Fields.Value.getFieldIndex());
            return this;
        }

        @Override
        public OptionSetStructureSpecification specification() {
            return (OptionSetStructureSpecification)super.specification();
        }
    }
}

