/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=312")
public class EndpointDescription
extends DynamicStructure {
    public static final StructureSpecification SPECIFICATION;

    public EndpointDescription() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected EndpointDescription(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public EndpointDescription(String string, ApplicationDescription applicationDescription, ByteString byteString, MessageSecurityMode messageSecurityMode, String string2, UserTokenPolicy[] userTokenPolicyArray, String string3, UnsignedByte unsignedByte) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setEndpointUrl(string);
        this.setServer(applicationDescription);
        this.setServerCertificate(byteString);
        this.setSecurityMode(messageSecurityMode);
        this.setSecurityPolicyUri(string2);
        this.setUserIdentityTokens(userTokenPolicyArray);
        this.setTransportProfileUri(string3);
        this.setSecurityLevel(unsignedByte);
    }

    public String getEndpointUrl() {
        return (String)this.indexGet(0);
    }

    public void setEndpointUrl(String string) {
        this.indexSet(string, 0);
    }

    public ApplicationDescription getServer() {
        return (ApplicationDescription)this.indexGet(1);
    }

    public void setServer(ApplicationDescription applicationDescription) {
        this.indexSet(applicationDescription, 1);
    }

    public ByteString getServerCertificate() {
        return (ByteString)this.indexGet(2);
    }

    public void setServerCertificate(ByteString byteString) {
        this.indexSet(byteString, 2);
    }

    public MessageSecurityMode getSecurityMode() {
        return (MessageSecurityMode)this.indexGet(3);
    }

    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.indexSet(messageSecurityMode, 3);
    }

    public String getSecurityPolicyUri() {
        return (String)this.indexGet(4);
    }

    public void setSecurityPolicyUri(String string) {
        this.indexSet(string, 4);
    }

    public UserTokenPolicy[] getUserIdentityTokens() {
        return (UserTokenPolicy[])this.indexGet(5);
    }

    public void setUserIdentityTokens(UserTokenPolicy[] userTokenPolicyArray) {
        this.indexSet(userTokenPolicyArray, 5);
    }

    public String getTransportProfileUri() {
        return (String)this.indexGet(6);
    }

    public void setTransportProfileUri(String string) {
        this.indexSet(string, 6);
    }

    public UnsignedByte getSecurityLevel() {
        return (UnsignedByte)this.indexGet(7);
    }

    public void setSecurityLevel(UnsignedByte unsignedByte) {
        this.indexSet(unsignedByte, 7);
    }

    @Override
    public EndpointDescription clone() {
        return (EndpointDescription)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new EndpointDescription());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.EndpointUrl);
        builder.addField(Fields.Server);
        builder.addField(Fields.ServerCertificate);
        builder.addField(Fields.SecurityMode);
        builder.addField(Fields.SecurityPolicyUri);
        builder.addField(Fields.UserIdentityTokens);
        builder.addField(Fields.TransportProfileUri);
        builder.addField(Fields.SecurityLevel);
        builder.setBinaryEncodeId(UaIds.EndpointDescription_DefaultBinary);
        builder.setXmlEncodeId(UaIds.EndpointDescription_DefaultXml);
        builder.setJsonEncodeId(UaIds.EndpointDescription_DefaultJson);
        builder.setTypeId(UaIds.EndpointDescription);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("EndpointDescription");
        builder.setJavaClass(EndpointDescription.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new EndpointDescription((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(EndpointDescription.class, SPECIFICATION);
    }

    public static class Builder
    extends DynamicStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public String getEndpointUrl() {
            return (String)this.indexGet(0);
        }

        public Builder setEndpointUrl(String string) {
            this.indexSet(string, 0);
            return this;
        }

        public ApplicationDescription getServer() {
            return (ApplicationDescription)this.indexGet(1);
        }

        public Builder setServer(ApplicationDescription applicationDescription) {
            this.indexSet(applicationDescription, 1);
            return this;
        }

        public ByteString getServerCertificate() {
            return (ByteString)this.indexGet(2);
        }

        public Builder setServerCertificate(ByteString byteString) {
            this.indexSet(byteString, 2);
            return this;
        }

        public MessageSecurityMode getSecurityMode() {
            return (MessageSecurityMode)this.indexGet(3);
        }

        public Builder setSecurityMode(MessageSecurityMode messageSecurityMode) {
            this.indexSet(messageSecurityMode, 3);
            return this;
        }

        public String getSecurityPolicyUri() {
            return (String)this.indexGet(4);
        }

        public Builder setSecurityPolicyUri(String string) {
            this.indexSet(string, 4);
            return this;
        }

        public UserTokenPolicy[] getUserIdentityTokens() {
            return (UserTokenPolicy[])this.indexGet(5);
        }

        public Builder setUserIdentityTokens(UserTokenPolicy[] userTokenPolicyArray) {
            this.indexSet(userTokenPolicyArray, 5);
            return this;
        }

        public String getTransportProfileUri() {
            return (String)this.indexGet(6);
        }

        public Builder setTransportProfileUri(String string) {
            this.indexSet(string, 6);
            return this;
        }

        public UnsignedByte getSecurityLevel() {
            return (UnsignedByte)this.indexGet(7);
        }

        public Builder setSecurityLevel(UnsignedByte unsignedByte) {
            this.indexSet(unsignedByte, 7);
            return this;
        }

        @Override
        public EndpointDescription build() {
            return (EndpointDescription)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        EndpointUrl(0, "EndpointUrl", String.class, false, UaIds.String, -1, null, false, 0),
        Server(1, "Server", ApplicationDescription.class, false, UaIds.ApplicationDescription, -1, null, false, 0),
        ServerCertificate(2, "ServerCertificate", ByteString.class, false, UaIds.ApplicationInstanceCertificate, -1, null, false, 0),
        SecurityMode(3, "SecurityMode", MessageSecurityMode.class, false, UaIds.MessageSecurityMode, -1, null, false, 0),
        SecurityPolicyUri(4, "SecurityPolicyUri", String.class, false, UaIds.String, -1, null, false, 0),
        UserIdentityTokens(5, "UserIdentityTokens", UserTokenPolicy[].class, false, UaIds.UserTokenPolicy, 1, UaArrayDimensions.valueOf(0L), false, 1),
        TransportProfileUri(6, "TransportProfileUri", String.class, false, UaIds.String, -1, null, false, 0),
        SecurityLevel(7, "SecurityLevel", UnsignedByte.class, false, UaIds.Byte, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

