/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24210")
public enum Duplex implements Enumeration
{
    Full(0),
    Half(1),
    Unknown(2);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<Duplex> NONE;
    public static final EnumSet<Duplex> ALL;
    private static final Map<Integer, Duplex> map;
    private final int value;

    private Duplex(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static Duplex valueOf(int n2) {
        return map.get(n2);
    }

    public static Duplex valueOf(Integer n2) {
        return n2 == null ? null : Duplex.valueOf((int)n2);
    }

    public static Duplex valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : Duplex.valueOf(unsignedInteger.intValue());
    }

    public static Duplex[] valueOf(int[] nArray) {
        Duplex[] duplexArray = new Duplex[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            duplexArray[i2] = Duplex.valueOf(nArray[i2]);
        }
        return duplexArray;
    }

    public static Duplex[] valueOf(Integer[] integerArray) {
        Duplex[] duplexArray = new Duplex[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            duplexArray[i2] = Duplex.valueOf(integerArray[i2]);
        }
        return duplexArray;
    }

    public static Duplex[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        Duplex[] duplexArray = new Duplex[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            duplexArray[i2] = Duplex.valueOf(unsignedIntegerArray[i2]);
        }
        return duplexArray;
    }

    public static UnsignedInteger getMask(Duplex ... duplexArray) {
        int n2 = 0;
        for (Duplex duplex : duplexArray) {
            n2 |= duplex.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<Duplex> collection) {
        int n2 = 0;
        for (Duplex duplex : collection) {
            n2 |= duplex.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<Duplex> getSet(UnsignedInteger unsignedInteger) {
        return Duplex.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<Duplex> getSet(int n2) {
        ArrayList<Duplex> arrayList = new ArrayList<Duplex>();
        for (Duplex duplex : Duplex.values()) {
            if ((n2 & duplex.value) != duplex.value) continue;
            arrayList.add(duplex);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = Duplex.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(Duplex.class);
        ALL = EnumSet.allOf(Duplex.class);
        map = new HashMap<Integer, Duplex>();
        for (Duplex duplex : Duplex.values()) {
            map.put(duplex.value, duplex);
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName("Duplex");
        builder.setJavaClass(Duplex.class);
        builder.setTypeId(UaIds.Duplex);
        builder.addMapping(0, "Full");
        builder.addMapping(1, "Half");
        builder.addMapping(2, "Unknown");
        builder.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return Duplex.builder();
            }
        });
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(Duplex.class, SPECIFICATION);
    }

    public static class Builder
    implements Enumeration.Builder {
        private Duplex value;

        private Builder() {
        }

        @Override
        public Duplex build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = Duplex.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum Duplex int value: " + n2);
            }
            return this;
        }
    }
}

