/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.DataTypeSchemaHeader;
import com.prosysopc.ua.stack.core.EnumDescription;
import com.prosysopc.ua.stack.core.FieldMetaData;
import com.prosysopc.ua.stack.core.SimpleTypeDescription;
import com.prosysopc.ua.stack.core.StructureDescription;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.UUID;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14523")
public class DataSetMetaDataType
extends DataTypeSchemaHeader {
    public static final StructureSpecification SPECIFICATION;

    public DataSetMetaDataType() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected DataSetMetaDataType(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public DataSetMetaDataType(String string, LocalizedText localizedText, FieldMetaData[] fieldMetaDataArray, UUID uUID, ConfigurationVersionDataType configurationVersionDataType) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setName(string);
        this.setDescription(localizedText);
        this.setFields(fieldMetaDataArray);
        this.setDataSetClassId(uUID);
        this.setConfigurationVersion(configurationVersionDataType);
    }

    public DataSetMetaDataType(String[] stringArray, StructureDescription[] structureDescriptionArray, EnumDescription[] enumDescriptionArray, SimpleTypeDescription[] simpleTypeDescriptionArray, String string, LocalizedText localizedText, FieldMetaData[] fieldMetaDataArray, UUID uUID, ConfigurationVersionDataType configurationVersionDataType) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setNamespaces(stringArray);
        this.setStructureDataTypes(structureDescriptionArray);
        this.setEnumDataTypes(enumDescriptionArray);
        this.setSimpleDataTypes(simpleTypeDescriptionArray);
        this.setName(string);
        this.setDescription(localizedText);
        this.setFields(fieldMetaDataArray);
        this.setDataSetClassId(uUID);
        this.setConfigurationVersion(configurationVersionDataType);
    }

    public String getName() {
        return (String)this.indexGet(4);
    }

    public void setName(String string) {
        this.indexSet(string, 4);
    }

    public LocalizedText getDescription() {
        return (LocalizedText)this.indexGet(5);
    }

    public void setDescription(LocalizedText localizedText) {
        this.indexSet(localizedText, 5);
    }

    public FieldMetaData[] getFields() {
        return (FieldMetaData[])this.indexGet(6);
    }

    public void setFields(FieldMetaData[] fieldMetaDataArray) {
        this.indexSet(fieldMetaDataArray, 6);
    }

    public UUID getDataSetClassId() {
        return (UUID)this.indexGet(7);
    }

    public void setDataSetClassId(UUID uUID) {
        this.indexSet(uUID, 7);
    }

    public ConfigurationVersionDataType getConfigurationVersion() {
        return (ConfigurationVersionDataType)this.indexGet(8);
    }

    public void setConfigurationVersion(ConfigurationVersionDataType configurationVersionDataType) {
        this.indexSet(configurationVersionDataType, 8);
    }

    @Override
    public DataSetMetaDataType clone() {
        return (DataSetMetaDataType)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new DataSetMetaDataType());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Namespaces);
        builder.addField(Fields.StructureDataTypes);
        builder.addField(Fields.EnumDataTypes);
        builder.addField(Fields.SimpleDataTypes);
        builder.addField(Fields.Name);
        builder.addField(Fields.Description);
        builder.addField(Fields.Fields);
        builder.addField(Fields.DataSetClassId);
        builder.addField(Fields.ConfigurationVersion);
        builder.setBinaryEncodeId(UaIds.DataSetMetaDataType_DefaultBinary);
        builder.setXmlEncodeId(UaIds.DataSetMetaDataType_DefaultXml);
        builder.setJsonEncodeId(UaIds.DataSetMetaDataType_DefaultJson);
        builder.setTypeId(UaIds.DataSetMetaDataType);
        builder.addSuperTypeId(UaIds.Structure);
        builder.addSuperTypeId(UaIds.DataTypeSchemaHeader);
        builder.setName("DataSetMetaDataType");
        builder.setJavaClass(DataSetMetaDataType.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new DataSetMetaDataType((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(DataSetMetaDataType.class, SPECIFICATION);
    }

    public static class Builder
    extends DataTypeSchemaHeader.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        @Override
        public String[] getNamespaces() {
            return (String[])this.indexGet(0);
        }

        @Override
        public Builder setNamespaces(String[] stringArray) {
            this.indexSet(stringArray, 0);
            return this;
        }

        @Override
        public StructureDescription[] getStructureDataTypes() {
            return (StructureDescription[])this.indexGet(1);
        }

        @Override
        public Builder setStructureDataTypes(StructureDescription[] structureDescriptionArray) {
            this.indexSet(structureDescriptionArray, 1);
            return this;
        }

        @Override
        public EnumDescription[] getEnumDataTypes() {
            return (EnumDescription[])this.indexGet(2);
        }

        @Override
        public Builder setEnumDataTypes(EnumDescription[] enumDescriptionArray) {
            this.indexSet(enumDescriptionArray, 2);
            return this;
        }

        @Override
        public SimpleTypeDescription[] getSimpleDataTypes() {
            return (SimpleTypeDescription[])this.indexGet(3);
        }

        @Override
        public Builder setSimpleDataTypes(SimpleTypeDescription[] simpleTypeDescriptionArray) {
            this.indexSet(simpleTypeDescriptionArray, 3);
            return this;
        }

        public String getName() {
            return (String)this.indexGet(4);
        }

        public Builder setName(String string) {
            this.indexSet(string, 4);
            return this;
        }

        public LocalizedText getDescription() {
            return (LocalizedText)this.indexGet(5);
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.indexSet(localizedText, 5);
            return this;
        }

        public FieldMetaData[] getFields() {
            return (FieldMetaData[])this.indexGet(6);
        }

        public Builder setFields(FieldMetaData[] fieldMetaDataArray) {
            this.indexSet(fieldMetaDataArray, 6);
            return this;
        }

        public UUID getDataSetClassId() {
            return (UUID)this.indexGet(7);
        }

        public Builder setDataSetClassId(UUID uUID) {
            this.indexSet(uUID, 7);
            return this;
        }

        public ConfigurationVersionDataType getConfigurationVersion() {
            return (ConfigurationVersionDataType)this.indexGet(8);
        }

        public Builder setConfigurationVersion(ConfigurationVersionDataType configurationVersionDataType) {
            this.indexSet(configurationVersionDataType, 8);
            return this;
        }

        @Override
        public DataSetMetaDataType build() {
            return (DataSetMetaDataType)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Namespaces(0, "Namespaces", String[].class, false, UaIds.String, 1, UaArrayDimensions.valueOf(0L), false, 1),
        StructureDataTypes(1, "StructureDataTypes", StructureDescription[].class, false, UaIds.StructureDescription, 1, UaArrayDimensions.valueOf(0L), false, 1),
        EnumDataTypes(2, "EnumDataTypes", EnumDescription[].class, false, UaIds.EnumDescription, 1, UaArrayDimensions.valueOf(0L), false, 1),
        SimpleDataTypes(3, "SimpleDataTypes", SimpleTypeDescription[].class, false, UaIds.SimpleTypeDescription, 1, UaArrayDimensions.valueOf(0L), false, 1),
        Name(4, "Name", String.class, false, UaIds.String, -1, null, false, 0),
        Description(5, "Description", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false, 0),
        Fields(6, "Fields", FieldMetaData[].class, false, UaIds.FieldMetaData, 1, UaArrayDimensions.valueOf(0L), false, 1),
        DataSetClassId(7, "DataSetClassId", UUID.class, false, UaIds.Guid, -1, null, false, 0),
        ConfigurationVersion(8, "ConfigurationVersion", ConfigurationVersionDataType.class, false, UaIds.ConfigurationVersionDataType, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

