/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.BitField;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.StatusCodeDescriptions;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class StatusCode
implements BitField {
    @Deprecated
    public static final NodeId ID;
    public static final StatusCode[] EMPTY_ARRAY;
    public static final int SEVERITY_MASK = -1073741824;
    public static final int SEVERITY_GOOD;
    public static final int SEVERITY_UNCERTAIN;
    public static final int SEVERITY_BAD;
    public static final StatusCode GOOD;
    public static final StatusCode BAD;
    public static final int RES1_MASK = 0x30000000;
    public static final int SUBCODE_MASK = 0xFFF0000;
    private static final Map<Integer, String> toStringCache;
    public static final int STRUCTURECHANGED_MASK = 32768;
    public static final int SEMANTICSCHANGED_MASK = 16384;
    public static final int RES2_MASK = 12288;
    public static final int INFOTYPE_MASK = 3072;
    public static final int INFOTYPE_DATAVALUE = 1024;
    public static final int INFOBITS_MASK = 1023;
    public static final int LIMITBITS_MASK = 768;
    public static final int LIMITBITS_NONE = 0;
    public static final int LIMITBITS_LOW = 256;
    public static final int LIMITBITS_HIGH = 512;
    public static final int LIMITBITS_CONSTANT = 768;
    public static final int OVERFLOW_MASK = 1152;
    public static final int OVERFLOW_BIT = 128;
    public static final int HISTORIANBITS_MASK = 31;
    public static final int HISTORIANBITS_RAW = 0;
    public static final int HISTORIANBITS_CALCULATED = 1;
    public static final int HISTORIANBITS_INTERPOLATED = 2;
    public static final int HISTORIANBITS_RESERVED = 3;
    public static final int HISTORIANBITS_PARTIAL = 4;
    public static final int HISTORIANBITS_EXTRADATA = 8;
    public static final int HISTORIANBITS_MULTIVALUE = 16;
    private final int value;
    private final String toStringValue;

    public static StatusCode getFromBits(int n2) {
        return new StatusCode(n2);
    }

    public static StatusCode parseStatusCode(String string) {
        try {
            return StatusCode.valueOf(UnsignedInteger.parseUnsignedInteger(string));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return StatusCode.getFromBits(CryptoUtil.hexToInt(string));
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    String string2 = string.split(" ")[0];
                    return StatusCode.valueOf(StatusCodes.getStatusCodeFromErrorName(string2));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Cannot parse string to a StatusCode: " + string);
                }
            }
        }
    }

    public static StatusCode valueOf(UnsignedInteger unsignedInteger) {
        if (UnsignedInteger.ZERO.equals(unsignedInteger)) {
            return GOOD;
        }
        return new StatusCode(unsignedInteger);
    }

    private static String calculateToString(int n2) {
        return String.format(Locale.ROOT, "%s (0x%08X) \"%s\"", StatusCode.nameForCode(n2), n2, StatusCode.descriptionForCode(n2));
    }

    private static String descriptionForCode(int n2) {
        String string = StatusCodeDescriptions.getStatusCodeDescription(n2);
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String nameForCode(int n2) {
        if (n2 == SEVERITY_GOOD) {
            return "GOOD";
        }
        if (n2 == SEVERITY_BAD) {
            return "BAD";
        }
        String string = StatusCodeDescriptions.getStatusCode(n2);
        if (string == null) {
            return "";
        }
        return string;
    }

    @Deprecated
    public StatusCode(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("Parameter value must be non-null");
        }
        this.value = unsignedInteger.intValue();
        this.toStringValue = this.calcToString();
    }

    private StatusCode(int n2) {
        this.value = n2;
        this.toStringValue = this.calcToString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof StatusCode)) {
            return false;
        }
        StatusCode statusCode = (StatusCode)object;
        return this.value == statusCode.value;
    }

    public boolean equalsStatusCode(StatusCode statusCode) {
        return this.isStatusCode(statusCode.getValue());
    }

    public String getDescription() {
        return StatusCode.descriptionForCode(this.value);
    }

    public int getHistorianBits() {
        return this.value & 0x1F;
    }

    public int getInfotype() {
        return this.value & 0xC00;
    }

    public int getLimitBits() {
        return this.value & 0x300;
    }

    public String getName() {
        return StatusCode.nameForCode(this.value);
    }

    public int getSeverity() {
        return this.value & 0xC0000000;
    }

    public int getSubcode() {
        return this.value & 0xFFF0000;
    }

    public UnsignedInteger getValue() {
        return UnsignedInteger.getFromBits(this.value);
    }

    public int getValueAsIntBits() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean isBad() {
        return (this.value & 0xC0000000) == SEVERITY_BAD;
    }

    @Override
    public boolean isBitSet(int n2) {
        return this.getValue().isBitSet(n2);
    }

    public boolean isGood() {
        return (this.value & 0xC0000000) == SEVERITY_GOOD;
    }

    public boolean isNotBad() {
        return (this.value & 0xC0000000) != SEVERITY_BAD;
    }

    public boolean isNotGood() {
        return (this.value & 0xC0000000) != SEVERITY_GOOD;
    }

    public boolean isNotUncertain() {
        return (this.value & 0xC0000000) != SEVERITY_UNCERTAIN;
    }

    public boolean isOverflow() {
        return (this.value & 0x480) != 0;
    }

    public boolean isSemanticsChanged() {
        return (this.value & 0x4000) != 0;
    }

    public boolean isStatusCode(UnsignedInteger unsignedInteger) {
        int n2 = -805371904;
        return (unsignedInteger.intValue() & n2) == (this.value & n2);
    }

    public boolean isStructureChanged() {
        return (this.value & 0x8000) != 0;
    }

    public boolean isUncertain() {
        return (this.value & 0xC0000000) == SEVERITY_UNCERTAIN;
    }

    public String toString() {
        return this.toStringValue;
    }

    private String calcToString() {
        String string = toStringCache.get(this.value);
        if (string == null) {
            string = StatusCode.calculateToString(this.value);
        }
        return string;
    }

    static {
        EMPTY_ARRAY = new StatusCode[0];
        SEVERITY_GOOD = 0;
        SEVERITY_UNCERTAIN = 0x40000000;
        SEVERITY_BAD = Integer.MIN_VALUE;
        toStringCache = new HashMap<Integer, String>();
        toStringCache.put(StatusCodes.Good.intValue(), StatusCode.calculateToString(StatusCodes.Good.intValue()));
        toStringCache.put(StatusCodes.Bad.intValue(), StatusCode.calculateToString(StatusCodes.Bad.intValue()));
        StatusCodes.getKnownStatusCodes().forEach(unsignedInteger -> toStringCache.putIfAbsent(unsignedInteger.intValue(), StatusCode.calculateToString(unsignedInteger.intValue())));
        GOOD = StatusCode.getFromBits(SEVERITY_GOOD);
        BAD = StatusCode.getFromBits(SEVERITY_BAD);
        ID = Identifiers.StatusCode;
    }
}

