/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.UaNamespaceTranslateable;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.encoding.json.JsonDecoder;
import com.prosysopc.ua.stack.encoding.json.JsonEncoder;
import com.prosysopc.ua.stack.encoding.xml.XmlDecoder;
import com.prosysopc.ua.stack.encoding.xml.XmlEncoder;
import com.prosysopc.ua.stack.utils.LimitedByteArrayOutputStream;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionObject
implements UaNamespaceTranslateable<ExtensionObject>,
Cloneable {
    public static final ExtensionObject[] EMPTY_ARRAY = new ExtensionObject[0];
    private static Logger logger = LoggerFactory.getLogger(ExtensionObject.class);
    private Object object;
    private final ExpandedNodeId typeId;
    private final EncodeType encodeType;

    public static ExtensionObject binaryEncode(Structure structure, EncoderContext encoderContext) throws EncodingException {
        return ExtensionObject.binaryEncodeImpl(structure, encoderContext, null);
    }

    public static ExtensionObject binaryEncode(Structure structure, EncoderContext encoderContext, List<Locale> list) throws EncodingException {
        return ExtensionObject.binaryEncodeImpl(structure, encoderContext, list);
    }

    public static ExtensionObject encode(Structure structure, QualifiedName qualifiedName, EncoderContext encoderContext) throws EncodingException {
        if (structure == null) {
            return null;
        }
        if (qualifiedName.equals(QualifiedName.DEFAULT_BINARY_ENCODING)) {
            return ExtensionObject.binaryEncode(structure, encoderContext);
        }
        if (qualifiedName.equals(QualifiedName.DEFAULT_XML_ENCODING)) {
            return ExtensionObject.xmlEncode(structure, encoderContext);
        }
        throw new EncodingException(StatusCodes.Bad_DataEncodingUnsupported);
    }

    public static ExtensionObject jsonEncode(Structure structure, EncoderContext encoderContext) throws EncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
        JsonEncoder jsonEncoder = new JsonEncoder(encoderContext, outputStreamWriter);
        jsonEncoder.put(null, structure, structure.specification().getTypeId(), 0);
        jsonEncoder.close();
        String string = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        return new ExtensionObject(structure.specification().getJsonEncodeId().asExpandedNodeId(), string);
    }

    public static ExtensionObject xmlEncode(Structure structure, EncoderContext encoderContext) throws EncodingException {
        return ExtensionObject.xmlEncode(structure, encoderContext, false);
    }

    public static ExtensionObject xmlEncode(Structure structure, EncoderContext encoderContext, boolean bl) throws EncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
        XmlEncoder xmlEncoder = new XmlEncoder(encoderContext, bl);
        xmlEncoder.setOmitXmlDeclaration(true);
        xmlEncoder.put(structure.specification().getName(), structure, structure.specification().getTypeId(), 0);
        xmlEncoder.write(outputStreamWriter);
        String string = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        return new ExtensionObject(structure.specification().getXmlEncodeId().asExpandedNodeId(), new XmlElement(string));
    }

    private static ExtensionObject binaryEncodeImpl(Structure structure, EncoderContext encoderContext, List<Locale> list) throws EncodingException {
        int n2;
        if (list == null) {
            list = Collections.emptyList();
        }
        if ((n2 = encoderContext.getMaxByteStringLength()) == 0) {
            n2 = encoderContext.getMaxMessageSize();
        }
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        LimitedByteArrayOutputStream limitedByteArrayOutputStream = LimitedByteArrayOutputStream.withSizeLimit(n2);
        BinaryEncoder binaryEncoder = new BinaryEncoder(encoderContext, limitedByteArrayOutputStream);
        binaryEncoder.getLocales().addAll(list);
        binaryEncoder.put(null, structure, structure.specification().getTypeId(), 0);
        return new ExtensionObject(structure.specification().getBinaryEncodeId().asExpandedNodeId(), ByteString.valueOf(limitedByteArrayOutputStream.toByteArray()));
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.typeId = expandedNodeId;
        this.object = null;
        this.encodeType = null;
    }

    @Deprecated
    public ExtensionObject(ExpandedNodeId expandedNodeId, byte[] byArray) {
        this(expandedNodeId, ByteString.valueOf(byArray));
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId, ByteString byteString) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.typeId = expandedNodeId;
        if (byteString != null) {
            this.object = byteString;
            this.encodeType = EncodeType.Binary;
        } else {
            this.object = null;
            this.encodeType = null;
        }
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId, String string) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.typeId = expandedNodeId;
        if (string != null) {
            this.object = string;
            this.encodeType = EncodeType.Json;
        } else {
            this.object = null;
            this.encodeType = null;
        }
    }

    public ExtensionObject(ExpandedNodeId expandedNodeId, XmlElement xmlElement) {
        if (expandedNodeId == null) {
            throw new IllegalArgumentException("typeId argument must not be null");
        }
        this.object = xmlElement == null ? new XmlElement("") : xmlElement;
        this.typeId = expandedNodeId;
        this.encodeType = EncodeType.Xml;
    }

    public ExtensionObject(Structure structure) {
        this.encodeType = null;
        this.typeId = null;
        this.object = structure;
    }

    private ExtensionObject(ExpandedNodeId expandedNodeId, EncodeType encodeType, Object object) {
        this.typeId = expandedNodeId;
        this.encodeType = encodeType;
        this.object = object;
    }

    public ExtensionObject clone() {
        try {
            ExtensionObject extensionObject = (ExtensionObject)super.clone();
            extensionObject.object = StructureUtils.clone(extensionObject.object);
            return extensionObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error("Got a CloneNotSupportedException, should be impossible", (Throwable)cloneNotSupportedException);
            throw new Error("Every ExtensionObject implementation shall be Cloneable", cloneNotSupportedException);
        }
    }

    public <T extends IEncodeable> T decode(EncoderContext encoderContext) throws DecodingException {
        return this.decode(encoderContext, encoderContext.getNamespaceTable());
    }

    public <T extends IEncodeable> T decode(EncoderContext encoderContext, Class<T> clazz, UnsignedInteger unsignedInteger) throws StatusException {
        try {
            return (T)((IEncodeable)clazz.cast(this.decode(encoderContext)));
        }
        catch (Exception exception) {
            throw new StatusException(unsignedInteger, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IEncodeable> T decode(EncoderContext encoderContext, NamespaceTable namespaceTable) throws DecodingException {
        if (this.object instanceof Structure) {
            IEncodeable iEncodeable = (IEncodeable)this.object;
            return (T)iEncodeable;
        }
        UaNodeId uaNodeId = UaNodeId.fromLocal(this.typeId);
        StructureSpecification structureSpecification = encoderContext.getStructureSpecification(uaNodeId);
        if (structureSpecification == null) {
            throw new DecodingException("Cannot decode, could not find StructureSpecification for " + uaNodeId);
        }
        if (this.object == null) {
            return (T)structureSpecification.toInstanceBuilder().build();
        }
        if (this.object instanceof Structure) {
            IEncodeable iEncodeable = (IEncodeable)this.object;
            return (T)iEncodeable;
        }
        if (this.object instanceof XmlElement) {
            IEncodeable iEncodeable;
            xmlDecoder.setNamespaceTable(namespaceTable);
            try (XmlDecoder xmlDecoder = new XmlDecoder((XmlElement)this.object, encoderContext);){
                boolean bl = xmlDecoder.peek(structureSpecification.getName());
                if (bl) {
                    xmlDecoder.getStartElement();
                }
                iEncodeable = (IEncodeable)xmlDecoder.get(null, structureSpecification.getTypeId(), 0);
                if (bl) {
                    xmlDecoder.getEndElement();
                }
            }
            return (T)iEncodeable;
        }
        if (this.object instanceof ByteString) {
            BinaryDecoder binaryDecoder = new BinaryDecoder(encoderContext, ((ByteString)this.object).getValue());
            return (T)((IEncodeable)binaryDecoder.get(null, structureSpecification.getTypeId(), 0));
        }
        if (this.object instanceof String) {
            JsonDecoder jsonDecoder = new JsonDecoder(encoderContext);
            jsonDecoder.setReadable(new ByteArrayInputStream(((String)this.object).getBytes(StandardCharsets.UTF_8)));
            return (T)((IEncodeable)jsonDecoder.get(null, structureSpecification.getTypeId(), 0));
        }
        throw new DecodingException("unexpected data, not null, Structure, ByteString or XmlElement, was: " + this.object.getClass());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ExtensionObject)) {
            return false;
        }
        ExtensionObject extensionObject = (ExtensionObject)object;
        if (!Objects.equals(this.typeId, extensionObject.typeId)) {
            return false;
        }
        return Objects.equals(this.object, extensionObject.object);
    }

    public EncodeType getEncodeType() {
        return this.encodeType;
    }

    public Object getObject() {
        return this.object;
    }

    public ExpandedNodeId getTypeId() {
        return this.typeId;
    }

    public int hashCode() {
        if (this.object == null) {
            return 0;
        }
        return this.object.hashCode();
    }

    public boolean isEncoded() {
        if (this.object == null) {
            return true;
        }
        return !(this.object instanceof Structure);
    }

    public String toString() {
        return "ExtensionObject [typeId=" + this.typeId + ", encodeType=" + (Object)((Object)this.encodeType) + ", object=" + this.object + "]";
    }

    @Override
    public ExtensionObject withTranslatedNamespaces(UaNamespaceTranslateable.Context context) {
        if (this.object instanceof Structure) {
            return new ExtensionObject(((Structure)this.object).withTranslatedNamespaces(context));
        }
        return new ExtensionObject(this.typeId.withTranslatedNamespaces(context), this.encodeType, StructureUtils.clone(this.object));
    }
}

