/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.UaExpandedNodeId;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNamespaceTranslateable;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExpandedNodeId
implements UaNamespaceTranslateable<ExpandedNodeId>,
Comparable<ExpandedNodeId> {
    private static final Logger logger = LoggerFactory.getLogger(ExpandedNodeId.class);
    public static final ExpandedNodeId NULL_NUMERIC = new ExpandedNodeId(NodeId.NULL_NUMERIC);
    public static final ExpandedNodeId NULL_STRING = new ExpandedNodeId(NodeId.NULL_STRING);
    public static final ExpandedNodeId NULL_GUID = new ExpandedNodeId(NodeId.NULL_GUID);
    public static final ExpandedNodeId NULL_OPAQUE = new ExpandedNodeId(NodeId.NULL_OPAQUE);
    public static final ExpandedNodeId NULL = NULL_NUMERIC;
    @Deprecated
    public static final NodeId ID = Identifiers.ExpandedNodeId;
    public static final ExpandedNodeId[] EMPTY_ARRAY = new ExpandedNodeId[0];
    final IdType rN;
    final int namespaceIndex;
    final UnsignedInteger ba;
    final boolean isNull;
    final int hash;
    final String namespaceUri;
    final Object value;

    public static ExpandedNodeId[] arrayFrom(UaExpandedNodeId[] uaExpandedNodeIdArray, ServerTable serverTable) {
        if (uaExpandedNodeIdArray == null) {
            return null;
        }
        if (uaExpandedNodeIdArray.length == 0) {
            return EMPTY_ARRAY;
        }
        ExpandedNodeId[] expandedNodeIdArray = new ExpandedNodeId[uaExpandedNodeIdArray.length];
        for (int i2 = 0; i2 < uaExpandedNodeIdArray.length; ++i2) {
            expandedNodeIdArray[i2] = ExpandedNodeId.from(uaExpandedNodeIdArray[i2], serverTable);
        }
        return expandedNodeIdArray;
    }

    public static ExpandedNodeId from(UaExpandedNodeId uaExpandedNodeId, ServerTable serverTable) {
        if (uaExpandedNodeId == null) {
            return null;
        }
        return uaExpandedNodeId.asExpandedNodeId(serverTable);
    }

    public static boolean isNull(ExpandedNodeId expandedNodeId) {
        return expandedNodeId == null || expandedNodeId.isNullNodeId();
    }

    public static ExpandedNodeId parseExpandedNodeId(String string) {
        String string2;
        int n2;
        int n3 = 0;
        int n4 = 0;
        String string3 = null;
        String string4 = string;
        if (string.startsWith("svr=")) {
            n2 = string.indexOf(59);
            if (n2 < 0) {
                ExpandedNodeId.throwExpandedNodeIdIllegalArgumentException(string);
            }
            string2 = string.substring(4, n2);
            n3 = Integer.parseInt(string2);
            string4 = string.substring(n2 + 1);
        }
        if (string4.startsWith("nsu=")) {
            n2 = string4.indexOf(59);
            if (n2 < 0) {
                ExpandedNodeId.throwExpandedNodeIdIllegalArgumentException(string);
            }
            string3 = string4.substring(4, n2);
            string4 = string4.substring(n2 + 1);
        } else if (string4.startsWith("ns=")) {
            n2 = string4.indexOf(59);
            if (n2 < 0) {
                ExpandedNodeId.throwExpandedNodeIdIllegalArgumentException(string);
            }
            string2 = string4.substring(3, n2);
            n4 = Integer.parseInt(string2);
            string4 = string4.substring(n2 + 1);
        }
        if (!(string4.startsWith("i=") || string4.startsWith("s=") || string4.startsWith("g=") || string4.startsWith("b="))) {
            ExpandedNodeId.throwExpandedNodeIdIllegalArgumentException(string);
        }
        NodeId nodeId = NodeId.parseNodeId(string4);
        if (string3 != null) {
            return new ExpandedNodeId(UnsignedInteger.valueOf(n3), ExpandedNodeId.decodeNamespaceUri(string3), nodeId.getValue());
        }
        return new ExpandedNodeId(UnsignedInteger.valueOf(n3), n4, nodeId.getValue());
    }

    private static IdType calcIdType(Object object) {
        IdType idType;
        if (object == null) {
            idType = IdType.String;
        } else if (object instanceof UnsignedInteger) {
            idType = IdType.Numeric;
        } else if (object instanceof String) {
            idType = IdType.String;
        } else if (object instanceof UUID) {
            idType = IdType.Guid;
        } else if (object instanceof ByteString) {
            idType = IdType.Opaque;
        } else {
            throw new IllegalArgumentException("value cannot be " + object.getClass().getName());
        }
        return idType;
    }

    private static String decodeNamespaceUri(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("%3B", ";").replace("%25", "%");
    }

    private static String encodeNamespaceUri(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("%", "%25").replace(";", "%3B");
    }

    private static void throwExpandedNodeIdIllegalArgumentException(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("String is not a valid ExpandedNodeId: " + string);
    }

    public ExpandedNodeId(NodeId nodeId) {
        this.hash = nodeId.hash;
        this.isNull = nodeId.isNull;
        this.ba = UnsignedInteger.ZERO;
        this.value = nodeId.getValue();
        this.rN = this.value == null ? ExpandedNodeId.calcIdType(this.value) : nodeId.rN;
        this.namespaceUri = null;
        this.namespaceIndex = nodeId.getNamespaceIndex();
    }

    public ExpandedNodeId(String string, Object object) {
        this(UnsignedInteger.ZERO, string, object);
    }

    public ExpandedNodeId(UnsignedInteger unsignedInteger, int n2, Object object) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("namespaceIndex out of bounds");
        }
        UnsignedInteger unsignedInteger2 = this.ba = unsignedInteger == null ? UnsignedInteger.ZERO : unsignedInteger;
        if (object instanceof Integer) {
            object = UnsignedInteger.getFromBits((Integer)object);
        }
        if (object instanceof byte[]) {
            object = ByteString.valueOf((byte[])object);
        }
        this.value = object;
        this.namespaceIndex = n2;
        this.namespaceUri = null;
        this.rN = ExpandedNodeId.calcIdType(object);
        this.isNull = this.calcIsNull();
        this.hash = this.calcHashCode();
    }

    public ExpandedNodeId(UnsignedInteger unsignedInteger, NodeId nodeId) {
        this(unsignedInteger, nodeId.getNamespaceIndex(), nodeId.getValue());
    }

    public ExpandedNodeId(UnsignedInteger unsignedInteger, String string, Object object) {
        if (string == null) {
            throw new NullPointerException("namespaceUri; value=" + object);
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("namespaceUri not defined");
        }
        UnsignedInteger unsignedInteger2 = this.ba = unsignedInteger == null ? UnsignedInteger.ZERO : unsignedInteger;
        if (object instanceof Integer) {
            object = UnsignedInteger.valueOf(((Integer)object).intValue());
        }
        if (object instanceof byte[]) {
            object = ByteString.valueOf((byte[])object);
        }
        this.value = object;
        this.namespaceUri = string;
        this.namespaceIndex = 0;
        this.rN = ExpandedNodeId.calcIdType(object);
        this.isNull = this.calcIsNull();
        this.hash = this.calcHashCode();
    }

    @Override
    public int compareTo(ExpandedNodeId expandedNodeId) {
        if (this == expandedNodeId) {
            return 0;
        }
        int n2 = this.namespaceUri != null && expandedNodeId.namespaceUri != null ? this.namespaceUri.compareTo(expandedNodeId.namespaceUri) : this.namespaceIndex - expandedNodeId.namespaceIndex;
        if (n2 == 0) {
            n2 = this.rN.getValue() - expandedNodeId.rN.getValue();
        }
        if (n2 == 0) {
            switch (this.rN) {
                case Numeric: {
                    n2 = ((UnsignedInteger)this.value).compareTo((UnsignedInteger)expandedNodeId.value);
                    break;
                }
                case String: {
                    n2 = ((String)this.value).compareTo((String)expandedNodeId.value);
                    break;
                }
                case Guid: {
                    n2 = ((UUID)this.value).compareTo((UUID)expandedNodeId.value);
                    break;
                }
                case Opaque: {
                    n2 = ((ByteString)this.value).compareTo((ByteString)expandedNodeId.value);
                }
            }
        }
        return n2;
    }

    @Deprecated
    public boolean equals(NodeId nodeId) {
        return this.equalsImpl(nodeId);
    }

    @Deprecated
    public boolean equals(Object object) {
        return this.equalsImpl(object);
    }

    public IdType getIdType() {
        return this.rN;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public UnsignedInteger getServerIndex() {
        return this.ba;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAbsolute() {
        return this.namespaceUri != null && !this.namespaceUri.isEmpty() || !this.isLocal();
    }

    public boolean isLocal() {
        return this.ba == null || this.ba.getValue() == 0L;
    }

    public boolean isNullNodeId() {
        return this.isNull;
    }

    public String toString() {
        String string;
        String string2;
        String string3 = string2 = !this.isLocal() ? "svr=" + this.ba + ";" : "";
        String string4 = this.namespaceUri != null ? "nsu=" + ExpandedNodeId.encodeNamespaceUri(this.namespaceUri) + ";" : (string = this.namespaceIndex > 0 ? "ns=" + this.namespaceIndex + ";" : "");
        if (this.rN == IdType.Numeric) {
            return string2 + string + "i=" + this.value;
        }
        if (this.rN == IdType.String) {
            return string2 + string + "s=" + this.value;
        }
        if (this.rN == IdType.Guid) {
            return string2 + string + "g=" + this.value;
        }
        if (this.rN == IdType.Opaque) {
            if (this.value == null) {
                return string2 + string + "b=null";
            }
            return string2 + string + "b=" + new String(CryptoUtil.base64Encode(((ByteString)this.value).getValue()));
        }
        return "error";
    }

    @Override
    public ExpandedNodeId withTranslatedNamespaces(UaNamespaceTranslateable.Context context) {
        UnsignedInteger unsignedInteger = context.getServerIndexTranslation().apply(this.getServerIndex());
        if (this.getNamespaceUri() != null) {
            return new ExpandedNodeId(unsignedInteger, context.getNamespaceTranslation().apply(UaNamespace.from(this.getNamespaceUri())).getURI(), this.getValue());
        }
        return new ExpandedNodeId(unsignedInteger, context.getNamespaceIndexTranslation().apply(this.getNamespaceIndex()), this.getValue());
    }

    private int calcHashCode() {
        if (this.isNull) {
            return 0;
        }
        int n2 = 13 * this.namespaceIndex;
        if (this.value != null) {
            n2 += 3 * this.value.hashCode();
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean calcIsNull() {
        int n2;
        if (this.namespaceUri != null && !this.namespaceUri.isEmpty()) {
            if (!"http://opcfoundation.org/UA/".equals(this.namespaceUri)) return false;
            n2 = 0;
            return NodeId.a(n2, this.rN, this.value);
        } else {
            n2 = this.namespaceIndex;
        }
        return NodeId.a(n2, this.rN, this.value);
    }

    private boolean equalsImpl(Object object) {
        if (object == null) {
            return this.isNull;
        }
        if (object instanceof NodeId) {
            if (this.namespaceUri != null && this.namespaceUri != "http://opcfoundation.org/UA/" || !this.isLocal()) {
                return false;
            }
            NodeId nodeId = (NodeId)object;
            if (nodeId.namespaceIndex != this.namespaceIndex || nodeId.rN != this.rN) {
                return false;
            }
            if (this.value == nodeId.value) {
                return true;
            }
            return nodeId.value.equals(this.value);
        }
        if (object instanceof ExpandedNodeId) {
            ExpandedNodeId expandedNodeId = (ExpandedNodeId)object;
            if (this.hash != expandedNodeId.hash) {
                return false;
            }
            if (this.namespaceUri != null) {
                if (expandedNodeId.namespaceUri == null || !expandedNodeId.namespaceUri.equals(this.namespaceUri)) {
                    return false;
                }
            } else {
                if (expandedNodeId.namespaceUri != null) {
                    return false;
                }
                if (expandedNodeId.namespaceIndex != this.namespaceIndex) {
                    return false;
                }
            }
            if (!this.isLocal() ? expandedNodeId.isLocal() || !expandedNodeId.ba.equals(this.ba) : !expandedNodeId.isLocal()) {
                return false;
            }
            if (expandedNodeId.rN != this.rN) {
                return false;
            }
            if (this.value == expandedNodeId.value) {
                return true;
            }
            if (expandedNodeId.value != null) {
                return expandedNodeId.value.equals(this.value);
            }
            return this.value == null;
        }
        return false;
    }
}

