/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.server.nodes.c;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaServerReference
extends UaReference {
    private static Logger logger = LoggerFactory.getLogger(UaServerReference.class);
    private UaNode rc;
    private final NodeId ew;
    private Boolean rd = null;
    private final UaNode qX;
    private final UaNode qY;
    private final int hash;

    public static UaServerReference getReferenceInstance(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        UaServerReference uaServerReference = UaServerReference.a(nodeId, uaNode, uaNode2);
        if (uaServerReference != null) {
            return uaServerReference;
        }
        return new UaServerReference(nodeId, uaNode, uaNode2);
    }

    public static UaServerReference getReferenceInstance(UaReferenceType uaReferenceType, UaNode uaNode, UaNode uaNode2) {
        UaServerReference uaServerReference = UaServerReference.a(uaReferenceType.getNodeId(), uaNode, uaNode2);
        if (uaServerReference != null) {
            return uaServerReference;
        }
        return new UaServerReference(uaReferenceType, uaNode, uaNode2);
    }

    private static UaServerReference a(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        if (nodeId == null) {
            throw new NullPointerException("referenceTypeId");
        }
        if (uaNode == null) {
            throw new NullPointerException("sourceNode");
        }
        if (uaNode2 == null) {
            throw new NullPointerException("targetNode");
        }
        AtomicReference<UaServerReference> atomicReference = new AtomicReference<UaServerReference>();
        if (UaServerReference.a(nodeId, uaNode, uaNode2, atomicReference)) {
            return atomicReference.get();
        }
        UaReference[] uaReferenceArray = uaNode.getReferences(nodeId, false);
        if (uaReferenceArray != null) {
            for (UaReference uaReference : uaReferenceArray) {
                if (!uaReference.getTargetId().equals(uaNode2.getNodeId())) continue;
                return (UaServerReference)uaReference;
            }
        }
        return null;
    }

    private static boolean a(NodeId nodeId, UaNode uaNode, UaNode uaNode2, AtomicReference<UaServerReference> atomicReference) {
        if (!(uaNode instanceof ServerNode) || !(uaNode2 instanceof ServerNode)) {
            return false;
        }
        ServerNode serverNode = (ServerNode)uaNode;
        c c2 = (c)serverNode.getReferenceList();
        if (!c2.ctg()) {
            return false;
        }
        if (Identifiers.HasProperty.equals(nodeId)) {
            if (uaNode instanceof BaseNode && uaNode2 instanceof UaProperty) {
                atomicReference.set((UaServerReference)((BaseNode)uaNode).getPropertyReference(uaNode2.getBrowseName()));
            } else {
                return false;
            }
        }
        atomicReference.set((UaServerReference)c2.asMap().get(new UaServerReference(nodeId, uaNode, uaNode2)));
        return true;
    }

    public UaServerReference(NodeId nodeId, UaNode uaNode, UaNode uaNode2) {
        this.ew = InternalArguments.checkNotNull(nodeId, "ReferenceTypeId");
        this.qX = InternalArguments.checkNotNull(uaNode, "SourceNode");
        this.qY = InternalArguments.checkNotNull(uaNode2, "TargetNode");
        this.hash = this.calcHashCode();
    }

    public UaServerReference(UaReferenceType uaReferenceType, UaNode uaNode, UaNode uaNode2) {
        this(uaReferenceType.getNodeId(), uaNode, uaNode2);
        this.rc = uaReferenceType;
    }

    @Override
    public int compareTo(UaReference uaReference) {
        if (this == uaReference) {
            return 0;
        }
        if (!(uaReference instanceof UaServerReference)) {
            return super.compareTo(uaReference);
        }
        UaServerReference uaServerReference = (UaServerReference)uaReference;
        int n2 = 0;
        if (this.qX != uaServerReference.qX) {
            n2 = this.qX.getNodeId().compareTo(uaServerReference.qX.getNodeId());
        }
        if (n2 == 0 && this.qY != uaServerReference.qY) {
            n2 = this.qY.getNodeId().compareTo(uaServerReference.qY.getNodeId());
        }
        if (n2 == 0) {
            n2 = this.ew.compareTo(uaServerReference.ew);
        }
        return n2;
    }

    @Override
    public void delete() {
        this.qX.deleteReference(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaServerReference uaServerReference = (UaServerReference)object;
        if (this.hash != uaServerReference.hash) {
            return false;
        }
        if (this.qY == null ? uaServerReference.qY != null : this.qY != uaServerReference.qY) {
            return false;
        }
        if (this.qX == null ? uaServerReference.qX != null : this.qX != uaServerReference.qX) {
            return false;
        }
        return !(this.ew == null ? uaServerReference.ew != null : !this.ew.equals(uaServerReference.ew));
    }

    @Override
    public boolean getIsInverse(NodeId nodeId) {
        boolean bl;
        if (this.isSymmetric()) {
            return false;
        }
        boolean bl2 = bl = !this.qX.getNodeId().equals(nodeId);
        if (bl && !this.qY.getNodeId().equals(nodeId)) {
            throw new IllegalArgumentException("getIsInverse: node is neither targetNode nor sourceNode");
        }
        return bl;
    }

    @Override
    public boolean getIsInverse(UaNode uaNode) {
        boolean bl;
        if (uaNode == this.qX) {
            return false;
        }
        if (this.isSymmetric()) {
            return false;
        }
        if (uaNode == this.qY) {
            return true;
        }
        boolean bl2 = bl = !this.qX.getNodeId().equals(uaNode.getNodeId());
        if (bl && !this.qY.getNodeId().equals(uaNode.getNodeId())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "getIsInverse: node (%s) is neither targetNode (%s) nor sourceNode (%s); referenceType=%s", uaNode.getNodeId(), this.getTargetId(), this.getSourceId(), this.getReferenceType().getBrowseName()));
        }
        return bl;
    }

    @Override
    public UaNode getOppositeNode(UaNode uaNode) {
        if (uaNode == this.qX) {
            return this.qY;
        }
        if (uaNode == this.qY) {
            return this.qX;
        }
        return super.getOppositeNode(uaNode);
    }

    @Override
    public UaReferenceType getReferenceType() {
        if (this.rc == null) {
            try {
                ServerNode serverNode = null;
                if (this.qX instanceof ServerNode) {
                    serverNode = (ServerNode)this.qX;
                } else if (this.qY instanceof ServerNode) {
                    serverNode = (ServerNode)this.qY;
                }
                if (serverNode != null) {
                    this.rc = serverNode.getNodeManager().getNode(this.ew);
                }
            }
            catch (StatusException statusException) {
                logger.debug("ReferenceType {} could not be found", (Object)this.ew);
                return null;
            }
        }
        if (this.rc instanceof UaReferenceType) {
            return (UaReferenceType)this.rc;
        }
        return null;
    }

    @Override
    public NodeId getReferenceTypeId() {
        return this.ew;
    }

    @Override
    public ExpandedNodeId getSourceId() {
        return new ExpandedNodeId(this.qX.getNodeId());
    }

    @Override
    public UaNode getSourceNode() {
        return this.qX;
    }

    @Override
    public ExpandedNodeId getTargetId() {
        return new ExpandedNodeId(this.qY.getNodeId());
    }

    @Override
    public UaNode getTargetNode() {
        return this.qY;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isSymmetric() {
        this.cth();
        return this.rd != null && this.rd != false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        UaReferenceType uaReferenceType = this.getReferenceType();
        if (uaReferenceType != null) {
            stringBuilder.append(" ReferenceType=");
            stringBuilder.append(uaReferenceType.getBrowseName());
        }
        if (!(this.qX instanceof UaExternalNode)) {
            stringBuilder.append(" SourceNode=");
            stringBuilder.append(this.qX.getBrowseName());
        }
        if (!(this.qY instanceof UaExternalNode)) {
            stringBuilder.append(" TargetNode=");
            stringBuilder.append(this.qY.getBrowseName());
        }
        return super.toString() + stringBuilder.toString();
    }

    private int calcHashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.ew.hashCode();
        n3 = 31 * n3 + this.qY.getNodeId().hashCode();
        n3 = 31 * n3 + this.qX.getNodeId().hashCode();
        return n3;
    }

    private void cth() {
        UaReferenceType uaReferenceType;
        if (this.rd == null && (uaReferenceType = this.getReferenceType()) != null) {
            this.rd = uaReferenceType.getSymmetric() != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
    }
}

