/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainVariable<T>
extends UaVariableNode {
    private static final StatusCode qJ = new StatusCode(StatusCodes.Bad_WaitingForInitialData);
    private static Logger logger = LoggerFactory.getLogger(PlainVariable.class);
    private volatile T qO;
    private volatile DateTime qP;
    private volatile UnsignedShort qQ = UnsignedShort.ZERO;
    private volatile DateTime qK = INITIALIZATION_TIME;
    private volatile StatusCode fZ = qJ;

    public PlainVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public PlainVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    protected PlainVariable(UaNode.Parameters parameters) {
        super(parameters);
    }

    public final T getCurrentValue() {
        return this.qO;
    }

    public DateTime getServerTimestamp() {
        return this.qP;
    }

    public DateTime getSourceTimestamp() {
        return this.qK;
    }

    @Override
    public StatusCode getStatus() {
        return this.fZ;
    }

    @Override
    public DataValue getValue() {
        DataValue dataValue = this.qO == null ? new DataValue(this.fZ) : new DataValue(new Variant(this.qO), this.fZ);
        dataValue.setServerTimestamp(this.qP);
        dataValue.setSourceTimestamp(this.qK);
        dataValue.setSourcePicoseconds(this.qQ);
        return dataValue;
    }

    public Class<?> getValueClass() {
        return this.qO.getClass();
    }

    public boolean setCurrentValue(T t2) {
        return this.setCurrentValue(t2, DateTime.currentTime());
    }

    public boolean setCurrentValue(T t2, DateTime dateTime) {
        return this.setCurrentValue(t2, StatusCode.GOOD, dateTime, null);
    }

    public boolean setCurrentValue(T t2, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) {
        boolean bl = !Objects.equals(t2, this.getCurrentValue());
        try {
            this.updateValue(t2, statusCode, dateTime, unsignedShort);
            if (bl) {
                if (NodeId.isNull(this.getDataTypeId())) {
                    Structure[] structureArray;
                    Class<Structure[]> clazz;
                    DataValue dataValue;
                    if (t2 instanceof Structure) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(((Structure)t2).specification().getTypeId().asExpandedNodeId()));
                    } else if (t2.getClass().isArray() && !(dataValue = this.getValue()).isNull() && (clazz = dataValue.getValue().getCompositeClass()).isAssignableFrom(Structure[].class) && (structureArray = (Structure[])dataValue.getValue().getValue()).length > 0) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(structureArray[0].specification().getTypeId().asExpandedNodeId()));
                    }
                }
                if (this.getValueRank() == -2) {
                    if (t2.getClass().isArray()) {
                        this.setArrayDimensions(new UnsignedInteger[]{UnsignedInteger.ZERO});
                        this.setValueRank(0);
                    } else {
                        this.setValueRank(-1);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return bl;
    }

    @Override
    public void setStatus(StatusCode statusCode) {
        this.fZ = statusCode;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            this.qO = null;
            this.qK = null;
            this.qP = DateTime.currentTime();
        } else {
            this.qO = dataValue.isNull() ? null : dataValue.getValue().getValue();
            this.fZ = dataValue.getStatusCode();
            this.qK = dataValue.getSourceTimestamp();
            this.qQ = dataValue.getSourcePicoseconds();
            this.qP = dataValue.getServerTimestamp();
            if (this.qP == null) {
                this.qP = DateTime.currentTime();
            }
        }
    }

    @Override
    protected void updateValue(Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        super.updateValue(object, statusCode, dateTime, unsignedShort);
    }
}

