/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.InstanceVariable;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainInstanceVariable<T>
extends InstanceVariable {
    private static Logger logger = LoggerFactory.getLogger(PlainInstanceVariable.class);
    private T qO;
    private DateTime qP;
    private UnsignedShort qQ = UnsignedShort.ZERO;
    private DateTime qK = INITIALIZATION_TIME;
    private StatusCode fZ = new StatusCode(StatusCodes.Bad_WaitingForInitialData);

    public PlainInstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, NodeId nodeId2) throws StatusException {
        super(nodeManagerUaNode, nodeId, nodeId2);
    }

    public PlainInstanceVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, UaVariable uaVariable) {
        super(nodeManagerUaNode, nodeId, uaVariable);
    }

    public final T getCurrentValue() {
        return this.qO;
    }

    public DateTime getServerTimestamp() {
        return this.qP;
    }

    public DateTime getSourceTimestamp() {
        return this.qK;
    }

    @Override
    public StatusCode getStatus() {
        return this.fZ;
    }

    @Override
    public DataValue getValue() {
        DataValue dataValue = this.qO == null ? new DataValue(this.fZ) : new DataValue(new Variant(this.qO), this.fZ);
        dataValue.setServerTimestamp(this.qP);
        dataValue.setSourceTimestamp(this.qK);
        dataValue.setSourcePicoseconds(this.qQ);
        return dataValue;
    }

    public Class<?> getValueClass() {
        if (this.qO == null) {
            return null;
        }
        return this.qO.getClass();
    }

    public boolean setCurrentValue(T t2) {
        return this.setCurrentValue(t2, DateTime.currentTime());
    }

    public boolean setCurrentValue(T t2, DateTime dateTime) {
        return this.setCurrentValue(t2, StatusCode.GOOD, dateTime, null);
    }

    public boolean setCurrentValue(T t2, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) {
        boolean bl;
        boolean bl2 = bl = !Objects.equals(t2, this.getCurrentValue());
        if (bl) {
            if (dateTime == null) {
                dateTime = DateTime.currentTime();
            }
            try {
                this.setValue(new DataValue(new Variant(t2), statusCode, dateTime, unsignedShort, null, null));
            }
            catch (StatusException statusException) {
                throw new IllegalArgumentException(statusException);
            }
            if (NodeId.isNull(this.getDataTypeId())) {
                try {
                    Structure[] structureArray;
                    Class<Structure[]> clazz;
                    DataValue dataValue;
                    if (t2 instanceof Structure) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(((Structure)t2).specification().getTypeId().asExpandedNodeId()));
                    } else if (t2.getClass().isArray() && !(dataValue = this.getValue()).isNull() && (clazz = dataValue.getValue().getCompositeClass()).isAssignableFrom(Structure[].class) && (structureArray = (Structure[])dataValue.getValue().getValue()).length > 0) {
                        this.setDataTypeId(this.nodeManager.getNamespaceTable().toNodeId(structureArray[0].specification().getTypeId().asExpandedNodeId()));
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if (this.getValueRank() == -2) {
                if (t2.getClass().isArray()) {
                    this.setArrayDimensions(new UnsignedInteger[]{UnsignedInteger.ZERO});
                    this.setValueRank(0);
                } else {
                    this.setValueRank(-1);
                }
            }
        }
        return bl;
    }

    @Override
    public void setStatus(StatusCode statusCode) {
        this.fZ = statusCode;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            this.qO = null;
            this.qK = DateTime.currentTime();
            this.qP = DateTime.currentTime();
            this.fZ = StatusCode.BAD;
        } else {
            this.qO = dataValue.isNull() ? null : dataValue.getValue().getValue();
            this.fZ = dataValue.getStatusCode();
            this.qK = dataValue.getSourceTimestamp();
            this.qQ = dataValue.getSourcePicoseconds();
            this.qP = dataValue.getServerTimestamp();
            if (this.qP == null) {
                this.qP = DateTime.currentTime();
            }
        }
    }
}

