/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.RequestHeader;

public class ServiceContext {
    public static final ServiceContext INTERNAL_OPERATION_CONTEXT = new ServiceContext(Session.INTERNAL_SESSION, null);
    final RequestHeader lq;
    final Session lr;

    public ServiceContext(Session session, RequestHeader requestHeader) {
        this.lr = session;
        this.lq = requestHeader;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ServiceContext)) {
            return false;
        }
        ServiceContext serviceContext = (ServiceContext)object;
        if (this.lq == null) {
            return serviceContext.lq == null;
        }
        if (serviceContext.lq == null) {
            return false;
        }
        if (this.lq.getRequestHandle() != null && this.lq.getRequestHandle().getValue() != 0L) {
            return this.lq.getRequestHandle().equals(serviceContext.lq.getRequestHandle());
        }
        if (this.lq.getRequestHandle() != null && this.lq.getTimestamp() != null) {
            return this.lq.getTimestamp().equals(serviceContext.lq.getTimestamp());
        }
        return false;
    }

    public String getAuditEntryId() {
        return this.lq.getAuditEntryId();
    }

    public UnsignedInteger getReturnDiagnostics() {
        return this.lq.getReturnDiagnostics();
    }

    public Session getSession() {
        return this.lr;
    }

    public UnsignedInteger getTimeoutHint() {
        return this.lq.getTimeoutHint();
    }

    public DateTime getTimestamp() {
        return this.lq.getTimestamp();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.lq == null ? 0 : this.lq.hashCode());
        n3 = 31 * n3 + (this.lr == null ? 0 : this.lr.hashCode());
        return n3;
    }

    public boolean isInternal() {
        return this.equals(INTERNAL_OPERATION_CONTEXT);
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.getTimestamp().getTimeInMillis() + this.getTimeoutHint().getValue();
    }
}

