/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.DataTypeConverter;
import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.UaException;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaNodeSet;
import com.prosysopc.ua.UaNodeSetException;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.ExternalNodeManager;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.HistoryManager;
import com.prosysopc.ua.server.HistoryResult;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.ModelParser;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerTableListener;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaNodeSetLoadOptions;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.a;
import com.prosysopc.ua.server.b;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchyCache;
import com.prosysopc.ua.server.instantiation.TypeDefinitionBasedNodeBuilderConfiguration;
import com.prosysopc.ua.server.instantiation.UaNodeBuilderConfiguration;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.AggregateFilterResult;
import com.prosysopc.ua.stack.core.BrowseDirection;
import com.prosysopc.ua.stack.core.BrowsePathTarget;
import com.prosysopc.ua.stack.core.BrowseResultMask;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateResult;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.QueryFirstRequest;
import com.prosysopc.ua.stack.core.QueryFirstResponse;
import com.prosysopc.ua.stack.core.QueryNextRequest;
import com.prosysopc.ua.stack.core.QueryNextResponse;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.ViewDescription;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class NodeManagerTable
implements UaAddressSpace {
    private static final Logger logger = LoggerFactory.getLogger(NodeManagerTable.class);
    static boolean kC = false;
    private DataTypeConverter er;
    private final ExternalNodeManager kD;
    private final InstanceDeclarationHierarchyCache kE = new InstanceDeclarationHierarchyCache();
    private NodeManagerTableListener kF = null;
    private boolean kG;
    private final b kH = new b();
    private final UaServer hF;
    private final AtomicReference<UaNodeBuilderConfiguration> kI;

    public NodeManagerTable(UaServer uaServer) {
        this.hF = uaServer;
        TypeDefinitionBasedNodeBuilderConfiguration typeDefinitionBasedNodeBuilderConfiguration = TypeDefinitionBasedNodeBuilderConfiguration.builder().build();
        this.kI = new AtomicReference<TypeDefinitionBasedNodeBuilderConfiguration>(typeDefinitionBasedNodeBuilderConfiguration);
        this.kD = new ExternalNodeManager(this);
    }

    @Override
    public void addNode(UaNode uaNode) {
        NodeManager nodeManager = this.kH.g(uaNode.getNodeId().getNamespaceIndex());
        if (nodeManager != null) {
            try {
                nodeManager.addNode(uaNode);
            }
            catch (StatusException statusException) {
                logger.error("Could not add node", (Throwable)statusException);
                throw new IllegalStateException("Could not add node", statusException);
            }
        }
    }

    public int addNodeManager(int n2, NodeManager nodeManager) {
        String string = nodeManager.getNamespaceUri();
        int n3 = this.getNamespaceTable().getIndex(string);
        if (n3 == -1) {
            n3 = this.getNamespaceTable().add(n2, string);
        }
        this.kH.a(n3, nodeManager);
        if (this.hF.isRunning()) {
            this.hF.updateNamespaceArray();
        }
        return n3;
    }

    public void close() {
        for (NodeManager nodeManager : this.kH.values()) {
            nodeManager.close();
        }
    }

    @Override
    public UaNode findNode(NodeId nodeId) {
        if (NodeId.isNull(nodeId)) {
            return null;
        }
        try {
            return this.getNodeManager(nodeId).findNode(nodeId);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    public UaDataType getDataType(NodeId nodeId) throws StatusException {
        return (UaDataType)this.getNode(nodeId);
    }

    @Override
    public DataTypeConverter getDataTypeConverter() {
        if (this.er == null) {
            this.er = new DataTypeConverter(this);
        }
        return this.er;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.hF.getEncoderContext();
    }

    public UaNode getExternalNode(NodeId nodeId) throws StatusException {
        return this.kD.getNode(nodeId);
    }

    public ExternalNodeManager getExternalNodeManager() {
        return this.kD;
    }

    public HistoryManager getHistoryManager(NodeId nodeId) throws StatusException {
        HistoryManager historyManager = this.getNodeManager(nodeId).getHistoryManager();
        if (historyManager == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return historyManager;
    }

    public InstanceDeclarationHierarchyCache getInstanceDeclarationHierarchyCache() {
        return this.kE;
    }

    public IoManager getIoManager(NodeId nodeId) throws StatusException {
        IoManager ioManager = this.getNodeManager(nodeId).getIoManager();
        if (ioManager == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return ioManager;
    }

    public NodeManagerTableListener getListener() {
        return this.kF;
    }

    @Override
    public NamespaceTable getNamespaceTable() {
        return this.getServer().getNamespaceTable();
    }

    @Override
    public UaNode getNode(ExpandedNodeId expandedNodeId) throws StatusException {
        if (ExpandedNodeId.isNull(expandedNodeId)) {
            throw new StatusException("nodeId==null", StatusCodes.Bad_NodeIdUnknown);
        }
        try {
            return this.getNode(this.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    @Override
    public <T extends UaNode> T getNode(ExpandedNodeId expandedNodeId, Class<T> clazz) throws StatusException {
        UaNode uaNode = this.getNode(expandedNodeId);
        return (T)uaNode;
    }

    @Override
    public UaNode getNode(NodeId nodeId) throws StatusException {
        if (NodeId.isNull(nodeId)) {
            throw new StatusException("nodeId==null", StatusCodes.Bad_NodeIdUnknown);
        }
        NodeManager nodeManager = this.getNodeManager(nodeId);
        UaNode uaNode = nodeManager.findNode(nodeId);
        if ((uaNode == null || uaNode instanceof UaExternalNode) && nodeManager.requireUaNode() || !nodeManager.hasNode(nodeId)) {
            logger.debug("getNode: nodeId={} nodeManager={}", (Object)nodeId, (Object)nodeManager);
            throw new StatusException("nodeId=" + nodeId, StatusCodes.Bad_NodeIdUnknown);
        }
        return uaNode;
    }

    @Override
    public <T extends UaNode> T getNode(NodeId nodeId, Class<T> clazz) throws StatusException {
        ExpandedNodeId expandedNodeId = this.getNamespaceTable().toExpandedNodeId(nodeId);
        return this.getNode(expandedNodeId, clazz);
    }

    @Override
    public UaNode getNode(UaNodeId uaNodeId) throws StatusException {
        if (ExpandedNodeId.isNull(uaNodeId.asLocalExpandedNodeId())) {
            throw new StatusException("nodeId==null", StatusCodes.Bad_NodeIdUnknown);
        }
        try {
            return this.getNode(this.getNamespaceTable().toNodeId(uaNodeId.asLocalExpandedNodeId()));
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    @Override
    public <T extends UaNode> T getNode(UaNodeId uaNodeId, Class<T> clazz) throws StatusException {
        UaNode uaNode = this.getNode(uaNodeId);
        return (T)uaNode;
    }

    public UaNodeBuilderConfiguration getNodeBuilderConfiguration() {
        return this.kI.get();
    }

    public NodeClass getNodeClass(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        try {
            return this.getNodeManager(expandedNodeId).getNodeClass(expandedNodeId, uaNode);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    public NodeClass getNodeClass(NodeId nodeId, UaNode uaNode) {
        try {
            return this.getNodeManager(nodeId).getNodeClass(nodeId, uaNode);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    public boolean getNodeManagementEnabled() {
        return this.kG;
    }

    public NodeManager getNodeManager(ExpandedNodeId expandedNodeId) throws StatusException {
        int n2 = expandedNodeId.getNamespaceIndex();
        if (n2 == 0) {
            try {
                n2 = this.getNamespaceTable().toNodeId(expandedNodeId).getNamespaceIndex();
            }
            catch (ServiceResultException serviceResultException) {
                throw new StatusException(serviceResultException);
            }
        }
        return this.getNodeManager(n2);
    }

    public NodeManager getNodeManager(int n2) throws StatusException {
        NodeManager nodeManager = this.kH.g(n2);
        if (nodeManager == null) {
            throw new StatusException(StatusCodes.Bad_NodeIdUnknown);
        }
        return nodeManager;
    }

    public NodeManager getNodeManager(NodeId nodeId) throws StatusException {
        return this.getNodeManager(nodeId.getNamespaceIndex());
    }

    public NodeManager getNodeManager(String string) throws StatusException {
        return this.getNodeManager(this.getNamespaceTable().getIndex(string));
    }

    public NodeManagerRoot getNodeManagerRoot() {
        return this.hF.getNodeManagerRoot();
    }

    public UaNode getNodeOrExternal(NodeId nodeId) throws StatusException {
        try {
            UaNode uaNode = this.getNodeManager(nodeId).findNode(nodeId);
            if (uaNode == null) {
                return this.getExternalNode(nodeId);
            }
            return uaNode;
        }
        catch (StatusException statusException) {
            return this.kD.getNode(nodeId);
        }
    }

    public UaNode getNodeOrExternalIfExist(NodeId nodeId) throws StatusException {
        try {
            UaNode uaNode = this.getNodeManager(nodeId).findNode(nodeId);
            if (uaNode != null) {
                return uaNode;
            }
            if (this.kD.hasNode(nodeId)) {
                return this.kD.getNode(nodeId);
            }
            return null;
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    @Override
    public FolderTypeNode getObjectsFolder() {
        return (FolderTypeNode)this.getNodeManagerRoot().getObjectsFolder();
    }

    @Override
    public FolderTypeNode getRoot() {
        return (FolderTypeNode)this.getNodeManagerRoot().getRoot();
    }

    public UaServer getServer() {
        return this.hF;
    }

    public ServerTable getServerTable() {
        return this.getEncoderContext().getServerTable();
    }

    public UaType getType(NodeId nodeId) throws StatusException {
        return (UaType)this.getNode(nodeId);
    }

    public boolean hasNode(NodeId nodeId) {
        try {
            return this.getNodeManager(nodeId).hasNode(nodeId);
        }
        catch (StatusException statusException) {
            return false;
        }
    }

    public boolean hasNodeManager(String string) {
        return this.kH.g(this.getNamespaceTable().getIndex(string)) != null;
    }

    public void invalidatePreviousNodeCaches() {
        this.kH.values().forEach(nodeManager -> nodeManager.invalidatePreviousNodeCache());
    }

    public boolean isTypeOf(NodeId nodeId, UaType uaType, NodeId nodeId2, UaType uaType2) throws StatusException {
        return this.getNodeManager(nodeId).getIsOfType(nodeId, uaType, nodeId2, uaType2);
    }

    @Override
    public void loadModel(InputStream inputStream) throws SAXException, IOException, ModelException {
        if (kC) {
            try {
                UaNodeSet uaNodeSet = UaNodeSet.parseXml(inputStream);
                this.loadModel(uaNodeSet);
            }
            catch (Exception exception) {
                throw new ModelException(exception.getMessage(), exception);
            }
        } else {
            this.loadModel(inputStream, null, false);
        }
    }

    public void loadModel(InputStream inputStream, Collection<ExpandedNodeId> collection, boolean bl) throws SAXException, ModelException, IOException {
        ModelParser modelParser = this.createModelParser();
        modelParser.setIgnoredNodes(collection);
        logger.debug("loadModel: Parsing XML");
        modelParser.parseFile(inputStream);
        logger.debug("loadModel: Creating model");
        try {
            modelParser.createModel(bl);
            logger.debug("loadModel: Completed");
        }
        catch (ServiceException serviceException) {
            logger.warn("Failed to load model from stream", (Throwable)serviceException);
            throw new RuntimeException(serviceException);
        }
    }

    public void loadModel(UaNodeSet ... uaNodeSetArray) throws UaException {
        this.loadModel(UaNodeSetLoadOptions.defaults(), uaNodeSetArray);
    }

    public void loadModel(UaNodeSetLoadOptions uaNodeSetLoadOptions, UaNodeSet ... uaNodeSetArray) throws UaException {
        for (UaNodeSet uaNodeSet : uaNodeSetArray) {
            if (!uaNodeSetLoadOptions.isIgnoreErrors() && uaNodeSet.getLog().getErrorCount() > 0L) {
                throw new UaNodeSetException("Given UaNodeSet(s) contained errors");
            }
            if (uaNodeSetLoadOptions.isIgnoreWarnings() || uaNodeSet.getLog().getWarningCount() <= 0L) continue;
            throw new UaNodeSetException("Given UaNodeSet(s) contained warnings");
        }
        a a2 = a.a(this.getEncoderContext(), uaNodeSetLoadOptions, uaNodeSetArray);
        a2.cpS().a(this, false);
    }

    @Override
    public void loadModel(URI uRI) throws SAXException, IOException, ModelException {
        logger.info("Loading model from {}", (Object)uRI);
        this.loadModel(uRI.toURL().openStream());
    }

    public synchronized void loadModel(URI uRI, Collection<ExpandedNodeId> collection, boolean bl) throws SAXException, IOException, ModelException {
        logger.info("Loading model from {}", (Object)uRI);
        ModelParser modelParser = this.createModelParser();
        modelParser.setIgnoredNodes(collection);
        logger.debug("loadModel: Parsing XML");
        modelParser.parseFile(uRI);
        logger.debug("loadModel: Creating model");
        try {
            modelParser.createModel(bl);
            logger.debug("loadModel: Completed");
        }
        catch (ServiceException serviceException) {
            logger.warn("Failed to load model from " + uRI, (Throwable)serviceException);
            throw new RuntimeException(serviceException);
        }
    }

    public NodeManager removeNodeManager(int n2) {
        return this.removeNodeManager(n2, true);
    }

    public NodeManager removeNodeManager(int n2, boolean bl) {
        if (bl) {
            this.getNamespaceTable().remove(n2);
            this.hF.updateNamespaceArray();
        }
        return this.kH.h(n2);
    }

    public void setListener(NodeManagerTableListener nodeManagerTableListener) {
        this.kF = nodeManagerTableListener;
    }

    public void setNodeBuilderConfiguration(UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        this.kI.set(uaNodeBuilderConfiguration);
    }

    public void setNodeManagementEnabled(boolean bl) {
        this.kG = bl;
    }

    @Override
    public BrowsePathTarget[] translateBrowsePathToNodeIds(NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        return this.translateBrowsePath(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, relativePath);
    }

    private void a(ServiceContext serviceContext, AddReferencesItem addReferencesItem, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
        this.getNodeManager(addReferencesItem.getSourceNodeId()).addReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
    }

    protected NodeId addNode(ServiceContext serviceContext, AddNodesItem addNodesItem) throws StatusException {
        ExpandedNodeId expandedNodeId = addNodesItem.getRequestedNewNodeId();
        NodeId nodeId = null;
        NodeId nodeId2 = null;
        try {
            try {
                nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
                try {
                    this.getNodeManager(nodeId);
                }
                catch (Exception exception) {
                    logger.debug("addNode: NodeManager for namespace {} not found: trying to create", (Object)expandedNodeId.getNamespaceUri());
                    this.createNewNodeManager(serviceContext, expandedNodeId.getNamespaceUri());
                }
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("addNode: NodeManager for namespace {} not found: trying to create", (Object)expandedNodeId.getNamespaceUri());
                this.createNewNodeManager(serviceContext, expandedNodeId.getNamespaceUri());
                nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.error("addNode: ", (Throwable)serviceResultException);
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        try {
            nodeId2 = this.getNamespaceTable().toNodeId(addNodesItem.getParentNodeId());
        }
        catch (ServiceResultException serviceResultException) {
            logger.error("addNode: ", (Throwable)serviceResultException);
            throw new StatusException(StatusCodes.Bad_ParentNodeIdInvalid);
        }
        NodeAttributes nodeAttributes = (NodeAttributes)addNodesItem.getNodeAttributes();
        ExpandedNodeId expandedNodeId2 = addNodesItem.getTypeDefinition();
        QualifiedName qualifiedName = addNodesItem.getBrowseName();
        NodeClass nodeClass = addNodesItem.getNodeClass();
        NodeId nodeId3 = addNodesItem.getReferenceTypeId();
        return this.addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId2, nodeAttributes, nodeId3);
    }

    protected NodeId addNode(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId nodeId3) throws StatusException {
        return this.getNodeManager(nodeId).addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId, nodeAttributes, nodeId3);
    }

    protected void addReference(ServiceContext serviceContext, AddReferencesItem addReferencesItem) throws StatusException {
        NodeId nodeId = addReferencesItem.getSourceNodeId();
        ExpandedNodeId expandedNodeId = addReferencesItem.getTargetNodeId();
        NodeId nodeId2 = addReferencesItem.getReferenceTypeId();
        boolean bl = addReferencesItem.getIsForward();
        NodeClass nodeClass = addReferencesItem.getTargetNodeClass();
        String string = addReferencesItem.getTargetServerUri();
        this.a(serviceContext, addReferencesItem, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
    }

    protected void afterCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).afterCreateMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterCreateMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).afterCreateMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void afterDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.getNodeManager(monitoredItem.getNodeId()).afterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void afterModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).afterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterModifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).afterModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected BrowseContinuationPoint browseNode(ServiceContext serviceContext, List<ReferenceDescription> list, NodeId nodeId, int n2, BrowseDirection browseDirection, NodeId nodeId2, Boolean bl, QualifiedName qualifiedName, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2, ViewDescription viewDescription, int n3) throws ServiceException, StatusException {
        return this.getNodeManager(nodeId).browseNode(serviceContext, list, nodeId, n2, browseDirection, nodeId2, bl, qualifiedName, enumSet, enumSet2, viewDescription, n3);
    }

    protected Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        logger.debug("callMethod: objectId={}; methodId={}", (Object)nodeId, (Object)nodeId2);
        logger.debug(" inputArguments={}", (Object)Arrays.toString(variantArray));
        return this.getNodeManager(nodeId).callMethod(serviceContext, nodeId, nodeId2, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    protected void checkNodeManagementEnabled() throws ServiceException {
        if (!this.getNodeManagementEnabled()) {
            throw new ServiceException(StatusCodes.Bad_ServiceUnsupported);
        }
    }

    protected ModelParser createModelParser() {
        return new ModelParser(this);
    }

    protected void createMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult, MonitoringMode monitoringMode) throws StatusException {
        this.getNodeManager(nodeId).createMonitoredDataItem(serviceContext, subscription, nodeId, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult, monitoringMode);
    }

    protected void createMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getNodeManager(nodeId).createMonitoredEventItem(serviceContext, subscription, nodeId, eventFilter, eventFilterResult);
    }

    protected void createNewNodeManager(ServiceContext serviceContext, String string) throws StatusException {
        NodeManager nodeManager;
        if (serviceContext.isInternal() || this.getNodeManagementEnabled()) {
            nodeManager = this.hF.createNewNodeManager(serviceContext, string);
            if (nodeManager == null) {
                throw new StatusException(StatusCodes.Bad_NodeIdRejected);
            }
        } else {
            throw new StatusException(StatusCodes.Bad_NodeIdRejected);
        }
        int n2 = nodeManager.getNamespaceIndex();
        this.addNodeManager(n2, nodeManager);
        this.hF.updateNamespaceArray();
        logger.debug("createNewNodeManager: newNodeManager={}", (Object)nodeManager);
    }

    protected void deleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.getNodeManager(monitoredItem.getNodeId()).deleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void deleteNode(ServiceContext serviceContext, ExpandedNodeId expandedNodeId, boolean bl) throws StatusException {
        NodeId nodeId;
        try {
            nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        this.getNodeManager(expandedNodeId).deleteNode(serviceContext, nodeId, bl);
    }

    protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        this.getNodeManager(nodeId).deleteNode(serviceContext, nodeId, bl);
    }

    protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
        this.getNodeManager(nodeId).deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        if (!this.getNamespaceTable().namespaceEquals(nodeId, expandedNodeId)) {
            this.getNodeManager(expandedNodeId).deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        }
    }

    protected HistoryResult historyRead(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, NumericRange numericRange, HistoryContinuationPoint historyContinuationPoint, HistoryReadDetails historyReadDetails, int n2) throws StatusException {
        return this.getHistoryManager(nodeId).historyRead(serviceContext, object, timestampsToReturn, nodeId, numericRange, historyContinuationPoint, historyReadDetails, n2);
    }

    protected void historyUpdate(ServiceContext serviceContext, Object object, HistoryUpdateDetails historyUpdateDetails, HistoryUpdateResult historyUpdateResult) throws StatusException {
        this.getHistoryManager(HistoryManager.getNodeIdFromHistoryUpdateDetails(historyUpdateDetails)).historyUpdate(serviceContext, object, historyUpdateDetails, historyUpdateResult);
    }

    protected void init() throws StatusException, UaNodeFactoryException {
        for (NodeManager nodeManager : this.kH.values()) {
            logger.debug("Initializing NodeManager: {}", (Object)nodeManager);
            nodeManager.init();
        }
    }

    protected void initializeMonitoredDataItem(ServiceContext serviceContext, MonitoredDataItem monitoredDataItem, DataValue dataValue) throws StatusException {
        this.getIoManager(monitoredDataItem.getNodeId()).initializeMonitoredDataItem(serviceContext, monitoredDataItem, dataValue);
    }

    protected void modifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).modifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, monitoringParameters, monitoringFilter, aggregateFilterResult);
    }

    protected void modifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).modifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
    }

    protected void queryFirst(ServiceContext serviceContext, QueryFirstRequest queryFirstRequest, QueryFirstResponse queryFirstResponse) throws ServiceException {
        if (this.kF == null) {
            throw new ServiceException(StatusCodes.Bad_NotImplemented);
        }
        this.kF.queryFirst(serviceContext, queryFirstRequest, queryFirstResponse);
    }

    protected void queryNext(ServiceContext serviceContext, QueryNextRequest queryNextRequest, QueryNextResponse queryNextResponse) throws ServiceException {
        if (this.kF == null) {
            throw new ServiceException(StatusCodes.Bad_NotImplemented);
        }
        this.kF.queryNext(serviceContext, queryNextRequest, queryNextResponse);
    }

    protected void readAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        this.getIoManager(nodeId).readAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, timestampsToReturn, dateTime, dataValue);
    }

    protected NodeId registerNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        return this.getNodeManager(nodeId).registerNode(serviceContext, nodeId);
    }

    protected void releaseHistoryContinuationPoint(ServiceContext serviceContext, NodeId nodeId, ByteString byteString) throws StatusException {
        this.getHistoryManager(nodeId).releaseHistoryContinuationPoint(serviceContext, nodeId, byteString);
    }

    protected void start() throws StatusException, UaNodeFactoryException {
        for (NodeManager nodeManager : this.kH.values()) {
            nodeManager.start();
        }
    }

    protected BrowsePathTarget[] translateBrowsePath(ServiceContext serviceContext, NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        return this.getNodeManager(nodeId).translateBrowsePath(serviceContext, nodeId, relativePath);
    }

    protected void unregisterNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        this.getNodeManager(nodeId).unregisterNode(serviceContext, nodeId);
    }

    protected boolean writeAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DataValue dataValue) throws StatusException {
        return this.getIoManager(nodeId).writeAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, dataValue);
    }

    b cqg() {
        return this.kH;
    }
}

