/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.AnnotationException;
import com.prosysopc.ua.AnnotationUtils;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.server.io.TypeIoManagerListener;
import com.prosysopc.ua.server.io.UaNodeIoListener;
import com.prosysopc.ua.server.io.UaTypeIoListener;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.OptionSet;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.types.opcua.BaseInstanceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoManagerUaNode
extends IoManager {
    private static Logger logger = LoggerFactory.getLogger(IoManagerUaNode.class);
    private final TypeIoManagerListener jM = new TypeIoManagerListener();

    public IoManagerUaNode(NodeManager nodeManager) {
        super(nodeManager);
        this.setListeners(this.getNodeListener(), this.getTypeListener(), this.getDefaultListener());
    }

    public void addNodeListener(UaNode uaNode, UaNodeIoListener uaNodeIoListener) {
        this.addNodeListener(uaNode.getNodeId(), uaNodeIoListener);
    }

    public void addTypeListener(Class<? extends BaseInstanceType> clazz, UaTypeIoListener uaTypeIoListener) throws AnnotationException, ServiceResultException {
        this.addTypeListener(this.getNodeManager().getNamespaceTable().toNodeId(AnnotationUtils.readTypeDefinitionId(clazz)), uaTypeIoListener);
    }

    public void addTypeListener(NodeId nodeId, UaTypeIoListener uaTypeIoListener) {
        this.jM.addListener(nodeId, uaTypeIoListener);
    }

    public IoManagerListener getTypeListener() {
        return this.jM;
    }

    @Override
    protected void readNonValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        uaNode.readAttribute(unsignedInteger, dataValue, serviceContext.getSession().getDefaultLocale());
        logger.debug("readValue({}): {}", (Object)nodeId, (Object)dataValue);
    }

    @Override
    protected void readValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        logger.debug("readValue: nodeId={} indexRange={} minTimestamp={}", new Object[]{nodeId, numericRange, dateTime});
        logger.debug("readValue: value={}", (Object)dataValue);
        uaValueNode.readAttribute(Attributes.Value, dataValue, serviceContext.getSession().getDefaultLocale());
        DateTime dateTime2 = dataValue.getServerTimestamp();
        if (dateTime2 == null || dateTime2.toInstant().isBefore(dateTime.toInstant())) {
            dataValue.setServerTimestamp(DateTime.currentTime());
        }
        IoManagerUaNode.applyIndexRangeToReadValue(dataValue, numericRange);
        logger.debug("readValue: result={}", (Object)dataValue);
    }

    @Override
    protected boolean requireUaNode() {
        return true;
    }

    @Override
    protected boolean writeNonValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        return uaNode.writeAttribute(unsignedInteger, dataValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean writeValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
        boolean bl;
        if (dataValue.getValue() != null && dataValue.getValue().getValue() instanceof OptionSet) {
            int n2;
            OptionSet optionSet = (OptionSet)uaValueNode.getValue().getValue().getValue();
            OptionSet optionSet2 = (OptionSet)dataValue.getValue().getValue();
            if (optionSet == null || optionSet2 == null) throw new StatusException(StatusCodes.Bad_NotSupported);
            byte[] byArray = optionSet.getValue().getValue();
            byte[] byArray2 = optionSet.getValidBits().getValue();
            byte[] byArray3 = optionSet2.getValue().getValue();
            byte[] byArray4 = optionSet2.getValidBits().getValue();
            if (byArray3 == null || byArray4 == null || byArray == null || byArray2 == null) throw new StatusException(StatusCodes.Bad_NotSupported);
            int n3 = byArray3.length;
            if (byArray4.length < n3) {
                n3 = byArray4.length;
            }
            if (byArray.length < n3) {
                n3 = byArray.length;
            }
            if (byArray2.length < n3) {
                n3 = byArray2.length;
            }
            byte[] byArray5 = new byte[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                byArray5[i2] = (byte)(byArray2[i2] & byArray4[i2]);
            }
            byte[] byArray6 = new byte[byArray.length];
            for (n2 = 0; n2 < n3; ++n2) {
                byArray6[n2] = (byte)(byArray[n2] & ~byArray5[n2] | byArray5[n2] & byArray3[n2]);
            }
            for (n2 = n3; n2 < byArray.length; ++n2) {
                byArray6[n2] = byArray[n2];
            }
            optionSet2.setValue(ByteString.valueOf(byArray6));
            optionSet2.setValidBits(ByteString.valueOf(byArray2));
        }
        logger.debug("writeValue: nodeId={} value={}", (Object)nodeId, (Object)dataValue);
        dataValue = IoManagerUaNode.applyIndexRangeToWriteValue(uaValueNode.getValue(), dataValue, numericRange);
        try {
            bl = uaValueNode.writeAttribute(Attributes.Value, dataValue);
        }
        catch (StatusException statusException) {
            logger.debug("writeAttribute failed", (Throwable)statusException);
            throw statusException;
        }
        logger.debug("writeValue: returnValue={}", (Object)bl);
        return bl;
    }
}

