/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.CallableListener;
import com.prosysopc.ua.server.EventManagerListener;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceManagerBase;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventManager
extends ServiceManagerBase
implements CallableListener {
    private static final EventManagerListener iL = new EventManagerListener(){};
    protected static final Logger logger = LoggerFactory.getLogger(EventManager.class);
    protected static final EventFilterResult RESULT_OK = null;
    private final NodeManager iM;
    protected final AtomicReference<EventManagerListener> listener = new AtomicReference<EventManagerListener>(iL);

    @Deprecated
    public static ByteString createEventId(long l2) {
        return ByteString.fromLong(l2);
    }

    public static ByteString createFullEventId(ByteString byteString) {
        ByteString byteString2 = ByteString.fromUUID(UUID.randomUUID());
        if (byteString != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byteString2.getValue(), 0, byteString2.getLength());
            byteArrayOutputStream.write(byteString.getValue(), 0, byteString.getLength());
            return ByteString.from(byteArrayOutputStream);
        }
        return byteString2;
    }

    public static ByteString extractUserEventId(ByteString byteString) {
        byte[] byArray;
        byte[] byArray2 = byArray = byteString == null ? null : byteString.getValue();
        if (byArray == null || byArray.length < 17) {
            return null;
        }
        return ByteString.valueOf(Arrays.copyOfRange(byArray, 16, byArray.length));
    }

    public EventManager(NodeManager nodeManager) {
        super(nodeManager.getServer());
        nodeManager.setEventManager(this);
        this.iM = nodeManager;
    }

    public EventManagerListener getListener() {
        return this.listener.get();
    }

    public NodeManager getNodeManager() {
        return this.iM;
    }

    @Override
    public boolean onCall(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, NodeId nodeId2, UaMethod uaMethod, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, Variant[] variantArray2) throws StatusException {
        return false;
    }

    public void setListener(EventManagerListener eventManagerListener) {
        this.listener.set(eventManagerListener != null ? eventManagerListener : iL);
    }

    protected void afterCreateMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        this.getListener().onAfterCreateMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void afterDeleteMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        this.getListener().onAfterDeleteMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void afterModifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        this.getListener().onAfterModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void createMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getListener().onCreateMonitoredEventItem(serviceContext, nodeId, eventFilter, eventFilterResult);
    }

    protected void deleteMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        this.getListener().onDeleteMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void fireConditionRefresh(ServiceContext serviceContext, Subscription subscription) throws StatusException {
        this.getListener().onConditionRefresh(serviceContext, subscription);
    }

    protected void fireConditionRefresh2(ServiceContext serviceContext, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.getListener().onConditionRefresh2(serviceContext, monitoredEventItem);
    }

    protected boolean methodEqualsIdOrName(UaMethod uaMethod, NodeId nodeId, String string) {
        return uaMethod.getNodeId().equals(nodeId) || uaMethod.getBrowseName().equals(new QualifiedName(string));
    }

    protected void modifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getListener().onModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
    }

    protected abstract void refreshItem(MonitoredEventItem var1);

    protected void refreshItems(ServiceContext serviceContext, Subscription subscription) throws StatusException {
        this.fireConditionRefresh(serviceContext, subscription);
        for (MonitoredItemBase monitoredItemBase : subscription.getItems()) {
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            this.refreshItem((MonitoredEventItem)monitoredItemBase);
        }
    }
}

