/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.nodes;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.a;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.DataTypeIdentifiers;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.DynamicUIntOptionSet;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UaDataType
extends UaType {
    public static final Logger logger = LoggerFactory.getLogger(UaDataType.class);

    public DataTypeDefinition getDataTypeDefinition();

    default public Class<?> getJavaClass() {
        UaNodeId uaNodeId = UaNodeId.fromLocal(this.getNodeId(), this.getAddressSpace().getNamespaceTable());
        UaDataTypeSpecification uaDataTypeSpecification = this.getAddressSpace().getEncoderContext().getDataTypeSpecifications().get(uaNodeId);
        if (uaDataTypeSpecification != null) {
            return uaDataTypeSpecification.getJavaClass();
        }
        if (this.inheritsFrom(Identifiers.Structure)) {
            return ((UaDataType)this.getSuperType()).getJavaClass();
        }
        HashSet<UaNodeId> hashSet = new HashSet<UaNodeId>();
        hashSet.add(UaIds.Enumeration);
        HashSet<UaNodeId> hashSet2 = new HashSet<UaNodeId>();
        hashSet2.add(UaIds.Byte);
        hashSet2.add(UaIds.UInt16);
        hashSet2.add(UaIds.UInt32);
        hashSet2.add(UaIds.UInt64);
        hashSet.addAll(hashSet2);
        UaNodeId uaNodeId2 = this.inheritsFromAny(hashSet);
        if (uaNodeId2 == null) {
            UaDataType uaDataType = (UaDataType)this.getSuperType();
            if (uaDataType == null) {
                if (!DataTypeIdentifiers.BaseDataType.equals(this.getNodeId())) {
                    a.cpv().warn("A non-BaseDataType node {}, has no supertype", (Object)this.getNodeId());
                    return null;
                }
                return Object.class;
            }
            return uaDataType.getJavaClass();
        }
        if (UaIds.Enumeration.equals(uaNodeId2)) {
            return DynamicEnumeration.class;
        }
        if (hashSet2.contains(uaNodeId2)) {
            UaProperty uaProperty = this.getProperty(new QualifiedName("OptionSetValues"));
            if (uaProperty != null) {
                return DynamicUIntOptionSet.class;
            }
            return ((UaDataType)this.getSuperType()).getJavaClass();
        }
        throw new IllegalStateException("getJavaClass reached an invalid internal state");
    }
}

