/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaClientReference;
import com.prosysopc.ua.client.nodes.UaNodeImpl;
import com.prosysopc.ua.nodes.MethodArgumentException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Argument;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.MethodAttributes;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.encoding.DecodingException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UaMethodImpl
extends UaNodeImpl
implements UaMethod {
    private static final QualifiedName INPUT_ARGUMENTS = new QualifiedName("InputArguments");
    private static final QualifiedName OUTPUT_ARGUMENTS = new QualifiedName("OutputArguments");
    Boolean hO = true;
    Boolean hP = true;

    public UaMethodImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    public UaMethodImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, AttributeWriteMask attributeWriteMask, AttributeWriteMask attributeWriteMask2, UaClientReference[] uaClientReferenceArray, UaProperty[] uaPropertyArray, Boolean bl, Boolean bl2) {
        super(addressSpace, nodeId, qualifiedName, localizedText, localizedText2, attributeWriteMask, attributeWriteMask2, uaClientReferenceArray, uaPropertyArray);
        this.hO = bl;
        this.hP = bl2;
    }

    public UaMethodImpl(AddressSpace addressSpace, NodeId nodeId, String string, Locale locale) {
        super(addressSpace, nodeId, string, locale);
    }

    protected UaMethodImpl(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new MethodAttributes());
    }

    @Override
    public Boolean getExecutable() {
        return this.hO;
    }

    @Override
    public Argument[] getInputArguments() throws MethodArgumentException {
        return this.a(this.getProperty(INPUT_ARGUMENTS));
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.Method;
    }

    @Override
    public Argument[] getOutputArguments() throws MethodArgumentException {
        return this.a(this.getProperty(OUTPUT_ARGUMENTS));
    }

    @Override
    public Boolean getUserExecutable() {
        return this.hP;
    }

    public void setAttributes(MethodAttributes methodAttributes) {
        super.setAttributes(methodAttributes);
        this.setExecutable(methodAttributes.getExecutable());
    }

    @Override
    public void setExecutable(Boolean bl) {
        this.hO = bl;
    }

    @Override
    public void setUserExecutable(Boolean bl) {
        this.hP = bl;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private Argument[] a(UaProperty uaProperty) throws MethodArgumentException {
        Object[] objectArray;
        if (uaProperty == null || uaProperty.getValue().isNull()) {
            return new Argument[0];
        }
        if (uaProperty.getValue().getValue().getValue() instanceof BigDecimal[] && ((objectArray = (BigDecimal[])uaProperty.getValue().getValue().getValue()) == null || objectArray.length == 0)) {
            return new Argument[0];
        }
        if (!uaProperty.getValue().getValue().isArray()) {
            throw new MethodArgumentException("Property is not an array: " + uaProperty.getBrowseName());
        }
        objectArray = (Object[])uaProperty.getValue().getValue().getValue();
        if (objectArray instanceof Argument[]) {
            return (Argument[])objectArray;
        }
        int n2 = objectArray.length;
        Argument[] argumentArray = new Argument[n2];
        if (objectArray instanceof Structure[]) {
            Structure[] structureArray = (Structure[])objectArray;
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    argumentArray[i2] = (Argument)structureArray[i2];
                    continue;
                }
                catch (ClassCastException classCastException) {
                    throw new MethodArgumentException("Cannot cast argument value #" + i2 + " " + structureArray[i2]);
                }
            }
        } else if (objectArray instanceof ExtensionObject[]) {
            ExtensionObject[] extensionObjectArray = (ExtensionObject[])objectArray;
            for (int i3 = 0; i3 < n2; ++i3) {
                try {
                    argumentArray[i3] = (Argument)extensionObjectArray[i3].decode(this.addressSpace.getClient().getEncoderContext());
                    continue;
                }
                catch (DecodingException decodingException) {
                    throw new MethodArgumentException("Cannot decode argument value #" + i3);
                }
            }
        } else {
            throw new MethodArgumentException("Cannot cast arguments from " + objectArray);
        }
        return argumentArray;
    }

    protected NodeAttributes getAttributes(MethodAttributes methodAttributes) {
        super.getAttributes(methodAttributes);
        methodAttributes.setExecutable(this.getExecutable());
        methodAttributes.setUserExecutable(this.getUserExecutable());
        return methodAttributes;
    }

    @Override
    protected void getAttributesMap(Map<UnsignedInteger, Object> map) {
        super.getAttributesMap(map);
        map.put(Attributes.Executable, this.getExecutable());
        map.put(Attributes.UserExecutable, this.getUserExecutable());
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Executable);
        list.add(Attributes.UserExecutable);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals(Attributes.Executable)) {
            dataValue.setValue(new Variant(this.hO));
        } else if (unsignedInteger.equals(Attributes.UserExecutable)) {
            dataValue.setValue(new Variant(this.hP));
        } else {
            super.readAttributeValue(unsignedInteger, dataValue);
        }
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (unsignedInteger.equals(Attributes.Executable)) {
            this.hO = (Boolean)object;
        } else if (unsignedInteger.equals(Attributes.UserExecutable)) {
            this.hP = (Boolean)object;
        } else {
            super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
        }
    }
}

