/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.MonitoredItemErrorListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.core.MonitoringMode;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitoredItem
extends MonitoredItemBase {
    private static AtomicInteger fv = new AtomicInteger(0);
    protected static final Logger logger = LoggerFactory.getLogger(MonitoredItem.class);
    private StatusCode fw;
    private ExpandedNodeId fx;
    private boolean modified;
    private boolean fy;
    private Subscription fz;
    private StatusCode fA = null;
    private volatile MonitoredItemErrorListener fB = null;

    private static UnsignedInteger cot() {
        return UnsignedInteger.valueOf(fv.incrementAndGet());
    }

    protected MonitoredItem(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        super(MonitoredItem.cot(), null, null, unsignedInteger, monitoringMode);
        this.fx = expandedNodeId;
    }

    protected MonitoredItem(NodeId nodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        super(MonitoredItem.cot(), null, nodeId, unsignedInteger, monitoringMode);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            MonitoredItem monitoredItem = (MonitoredItem)object;
            return this.fz == monitoredItem.fz;
        }
        return false;
    }

    public StatusCode getErrorCode() {
        return this.fw;
    }

    public MonitoredItemErrorListener getErrorListener() {
        return this.fB;
    }

    public ExpandedNodeId getExpandedNodeId() {
        return this.fx;
    }

    public StatusCode getInitialStatus() {
        return this.fA;
    }

    @Override
    public NodeId getNodeId() {
        if (this.fx != null) {
            try {
                return this.getSubscription().getClient().getNamespaceTable().toNodeId(this.fx);
            }
            catch (ServiceResultException serviceResultException) {
                throw new RuntimeException(serviceResultException);
            }
        }
        return super.getNodeId();
    }

    public Subscription getSubscription() {
        return this.fz;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isMonitoringModeModified() {
        return this.fy;
    }

    public void setErrorListener(MonitoredItemErrorListener monitoredItemErrorListener) {
        this.fB = monitoredItemErrorListener;
    }

    protected void clearModified() {
        this.modified = false;
    }

    protected void clearMonitoringModeModified() {
        this.fy = false;
    }

    protected void fireError(StatusCode statusCode) {
        MonitoredItemErrorListener monitoredItemErrorListener = this.fB;
        if (monitoredItemErrorListener != null) {
            monitoredItemErrorListener.onError(this, statusCode);
        }
    }

    @Override
    protected String getNodeIdAsString() {
        if (this.fx != null) {
            return this.fx.toString();
        }
        return super.getNodeIdAsString();
    }

    protected void itemChanged() throws ServiceException {
        if (this.fz != null) {
            if (this.fz.isConnected()) {
                this.modified = true;
            }
            this.fz.itemChanged(this);
        }
    }

    @Override
    protected void monitoringModeChanged() throws ServiceException {
        super.monitoringModeChanged();
        if (this.fz != null) {
            if (this.fz.isConnected()) {
                this.fy = true;
            }
            this.fz.monitoringModeChanged(this);
        }
    }

    protected void setClientHandle(int n2) {
        this.clientHandle = UnsignedInteger.valueOf(n2);
    }

    protected void setErrorCode(StatusCode statusCode) {
        StatusCode statusCode2 = this.fw;
        this.fw = statusCode;
        if (this.fA == null) {
            this.fA = statusCode;
        }
        if (!Objects.equals(statusCode, statusCode2)) {
            this.fireError(statusCode);
        }
    }

    @Override
    protected void setFilterResult(MonitoringFilterResult monitoringFilterResult) {
        super.setFilterResult(monitoringFilterResult);
    }

    @Override
    protected void setMonitoredItemId(UnsignedInteger unsignedInteger) {
        super.setMonitoredItemId(unsignedInteger);
    }

    protected void setRevisedQueueSize(UnsignedInteger unsignedInteger) {
        this.queueSize = unsignedInteger.longValue();
    }

    @Override
    protected void updateFilter() throws ServiceException {
        super.updateFilter();
        this.itemChanged();
    }

    @Override
    protected void updateQueue() throws ServiceException {
        super.updateQueue();
        this.itemChanged();
    }

    void a(Subscription subscription) {
        this.fz = subscription;
    }
}

