/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNamespaceTranslateable;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.InternalNamespaceUtils;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.util.Objects;
import java.util.UUID;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UaNodeId
implements UaNamespaceTranslateable<UaNodeId>,
Comparable<UaNodeId> {
    private static final UaNodeId[] dg = new UaNodeId[0];
    private final UaNamespace cW;
    private final ExpandedNodeId dh;
    private final int hash;

    public static UaNodeId[] arrayFromLocal(ExpandedNodeId[] expandedNodeIdArray) {
        if (expandedNodeIdArray == null) {
            return null;
        }
        if (expandedNodeIdArray.length == 0) {
            return dg;
        }
        UaNodeId[] uaNodeIdArray = new UaNodeId[expandedNodeIdArray.length];
        for (int i2 = 0; i2 < expandedNodeIdArray.length; ++i2) {
            uaNodeIdArray[i2] = UaNodeId.fromLocal(expandedNodeIdArray[i2]);
        }
        return uaNodeIdArray;
    }

    public static UaNodeId[] arrayFromLocal(ExpandedNodeId[] expandedNodeIdArray, NamespaceTable namespaceTable) {
        if (expandedNodeIdArray == null) {
            return null;
        }
        if (expandedNodeIdArray.length == 0) {
            return dg;
        }
        UaNodeId[] uaNodeIdArray = new UaNodeId[expandedNodeIdArray.length];
        for (int i2 = 0; i2 < expandedNodeIdArray.length; ++i2) {
            uaNodeIdArray[i2] = UaNodeId.fromLocal(expandedNodeIdArray[i2], namespaceTable);
        }
        return uaNodeIdArray;
    }

    public static UaNodeId[] arrayFromLocal(NodeId[] nodeIdArray, NamespaceTable namespaceTable) {
        if (nodeIdArray == null) {
            return null;
        }
        if (nodeIdArray.length == 0) {
            return dg;
        }
        UaNodeId[] uaNodeIdArray = new UaNodeId[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            uaNodeIdArray[i2] = UaNodeId.fromLocal(nodeIdArray[i2], namespaceTable);
        }
        return uaNodeIdArray;
    }

    public static UaNodeId from(String string, Object object) {
        return new UaNodeId(UaNamespace.from(string), object);
    }

    public static UaNodeId from(UaNamespace uaNamespace, Object object) {
        return new UaNodeId(uaNamespace, object);
    }

    public static UaNodeId fromLocal(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId == null) {
            return null;
        }
        if (!expandedNodeId.isLocal()) {
            throw new IllegalArgumentException("The given ExpandedNodeId.isLocal is not true");
        }
        if (expandedNodeId.getNamespaceUri() == null) {
            throw new IllegalArgumentException("The given ExpandedNode does not have namespace uri");
        }
        return UaNodeId.from(expandedNodeId.getNamespaceUri(), expandedNodeId.getValue());
    }

    public static UaNodeId fromLocal(ExpandedNodeId expandedNodeId, NamespaceTable namespaceTable) {
        if (expandedNodeId == null) {
            return null;
        }
        if (!expandedNodeId.isLocal()) {
            throw new IllegalArgumentException("The given ExpandedNodeId.isLocal is not true");
        }
        UaNamespace uaNamespace = expandedNodeId.getNamespaceUri() == null ? InternalNamespaceUtils.getNamespaceOrUseInvalidPattern(expandedNodeId.getNamespaceIndex(), namespaceTable) : InternalNamespaceUtils.getNamespace(expandedNodeId.getNamespaceUri(), namespaceTable);
        return UaNodeId.from(uaNamespace, expandedNodeId.getValue());
    }

    public static UaNodeId fromLocal(NodeId nodeId, NamespaceTable namespaceTable) {
        if (nodeId == null) {
            return null;
        }
        UaNamespace uaNamespace = InternalNamespaceUtils.getNamespaceOrUseInvalidPattern(nodeId.getNamespaceIndex(), namespaceTable);
        return UaNodeId.from(uaNamespace, nodeId.getValue());
    }

    public static UaNodeId fromStandard(NodeId nodeId) {
        if (nodeId.getNamespaceIndex() != 0) {
            throw new IllegalArgumentException("Given NodeId contains NamespaceIndex other than 0, was: " + nodeId.getNamespaceIndex());
        }
        return UaNodeId.from("http://opcfoundation.org/UA/", nodeId.getValue());
    }

    public static UaNodeId guid(UaNamespace uaNamespace, UUID uUID) {
        return UaNodeId.from(uaNamespace, (Object)uUID);
    }

    public static UaNodeId numeric(UaNamespace uaNamespace, long l2) {
        return UaNodeId.numeric(uaNamespace, UnsignedInteger.valueOf(l2));
    }

    public static UaNodeId numeric(UaNamespace uaNamespace, UnsignedInteger unsignedInteger) {
        return UaNodeId.from(uaNamespace, (Object)unsignedInteger);
    }

    public static UaNodeId opaque(UaNamespace uaNamespace, ByteString byteString) {
        return UaNodeId.from(uaNamespace, (Object)byteString);
    }

    public static UaNodeId parse(String string) {
        return UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId(string));
    }

    public static UaNodeId parse(String string, String string2) {
        NodeId nodeId = NodeId.parseNodeId(string2);
        return UaNodeId.from(string, nodeId.getValue());
    }

    public static UaNodeId parse(UaNamespace uaNamespace, String string) {
        NodeId nodeId = NodeId.parseNodeId(string);
        return UaNodeId.from(uaNamespace, nodeId.getValue());
    }

    public static UaNodeId string(UaNamespace uaNamespace, String string) {
        return UaNodeId.from(uaNamespace, (Object)string);
    }

    private UaNodeId(UaNamespace uaNamespace, Object object) {
        this.cW = uaNamespace;
        this.dh = new ExpandedNodeId(uaNamespace.getURI(), object);
        this.hash = this.if();
    }

    public ExpandedNodeId asExpandedNodeId() {
        return this.dh;
    }

    public ExpandedNodeId asLocalExpandedNodeId() {
        return this.dh;
    }

    public NodeId asNodeId(NamespaceTable namespaceTable) {
        try {
            return namespaceTable.toNodeId(this.asLocalExpandedNodeId());
        }
        catch (ServiceResultException serviceResultException) {
            throw new IllegalArgumentException("No mapping found for namespace uri:" + this.cW.getURI());
        }
    }

    @Override
    public int compareTo(UaNodeId uaNodeId) {
        if (this == uaNodeId) {
            return 0;
        }
        int n2 = this.cW.compareTo(uaNodeId.cW);
        if (n2 == 0) {
            n2 = this.getIdType().getValue() - uaNodeId.getIdType().getValue();
        }
        if (n2 == 0) {
            switch (this.getIdType()) {
                case Numeric: {
                    return ((UnsignedInteger)this.getValue()).compareTo((UnsignedInteger)uaNodeId.getValue());
                }
                case String: {
                    return ((String)this.getValue()).compareTo((String)uaNodeId.getValue());
                }
                case Guid: {
                    return ((UUID)this.getValue()).compareTo((UUID)uaNodeId.getValue());
                }
                case Opaque: {
                    return ((ByteString)this.getValue()).compareTo((ByteString)uaNodeId.getValue());
                }
            }
            throw new Error("Unkonwn IdType:" + this.getIdType());
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UaNodeId)) {
            return false;
        }
        UaNodeId uaNodeId = (UaNodeId)object;
        if (this.hash != uaNodeId.hash) {
            return false;
        }
        if (this.cW == null ? uaNodeId.cW != null : !this.cW.equals(uaNodeId.cW)) {
            return false;
        }
        return !(this.dh == null ? uaNodeId.dh != null : !this.d(uaNodeId));
    }

    public IdType getIdType() {
        return this.dh.getIdType();
    }

    public UaNamespace getNamespace() {
        return this.cW;
    }

    public String getNamespaceUri() {
        return this.cW.getURI();
    }

    public Object getValue() {
        return this.dh.getValue();
    }

    public String getValueAsParseForm() {
        IdType idType = this.getIdType();
        Object object = this.dh.getValue();
        if (idType == IdType.Numeric) {
            return "i=" + object;
        }
        if (idType == IdType.String) {
            return "s=" + object;
        }
        if (idType == IdType.Guid) {
            return "g=" + object;
        }
        if (idType == IdType.Opaque) {
            if (object == null) {
                return "b=null";
            }
            return "b=" + new String(CryptoUtil.base64Encode(((ByteString)object).getValue()));
        }
        return "error";
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.asExpandedNodeId().toString();
    }

    @Override
    public UaNodeId withTranslatedNamespaces(UaNamespaceTranslateable.Context context) {
        UaNamespace uaNamespace = context.getNamespaceTranslation().apply(this.cW);
        if (this.cW.equals(uaNamespace)) {
            return this;
        }
        return UaNodeId.from(uaNamespace, this.getValue());
    }

    private int if() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.cW == null ? 0 : this.cW.hashCode());
        n3 = 31 * n3 + (this.dh == null ? 0 : this.dh.hashCode());
        return n3;
    }

    boolean d(UaNodeId uaNodeId) {
        if (this.dh == uaNodeId.dh) {
            return true;
        }
        boolean bl = ExpandedNodeId.isNull(this.dh);
        boolean bl2 = ExpandedNodeId.isNull(uaNodeId.dh);
        if (bl || bl2) {
            return bl == bl2;
        }
        return Objects.equals(this.dh.getValue(), uaNodeId.dh.getValue());
    }
}

