/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaRelativePath;
import com.prosysopc.ua.UaRelativePathElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.BrowsePath;

public class UaBrowsePath {
    private final UaNodeId cR;
    private final UaRelativePath cT;

    public static UaBrowsePath from(BrowsePath browsePath, NamespaceTable namespaceTable) {
        InternalArguments.checkNotNull(namespaceTable, "namespaceTable");
        if (browsePath == null) {
            return null;
        }
        return new UaBrowsePath(UaNodeId.fromLocal(browsePath.getStartingNode(), namespaceTable), UaRelativePath.from(browsePath.getRelativePath(), namespaceTable));
    }

    public static UaBrowsePath from(UaNodeId uaNodeId, UaRelativePath uaRelativePath) {
        return new UaBrowsePath(uaNodeId, uaRelativePath);
    }

    private UaBrowsePath(UaNodeId uaNodeId, UaRelativePath uaRelativePath) {
        this.cR = InternalArguments.checkNotNull(uaNodeId, "startingNode");
        this.cT = InternalArguments.checkNotNull(uaRelativePath, "relativePath");
    }

    public UaBrowsePath append(UaRelativePath uaRelativePath) {
        return UaBrowsePath.from(this.cR, this.cT.append(uaRelativePath));
    }

    public UaBrowsePath append(UaRelativePathElement uaRelativePathElement) {
        return UaBrowsePath.from(this.cR, this.cT.append(uaRelativePathElement));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaBrowsePath uaBrowsePath = (UaBrowsePath)object;
        if (this.cT == null ? uaBrowsePath.cT != null : !this.cT.equals(uaBrowsePath.cT)) {
            return false;
        }
        return !(this.cR == null ? uaBrowsePath.cR != null : !this.cR.equals(uaBrowsePath.cR));
    }

    public UaRelativePath getRelativePath() {
        return this.cT;
    }

    public UaNodeId getStartingNode() {
        return this.cR;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.cT == null ? 0 : this.cT.hashCode());
        n3 = 31 * n3 + (this.cR == null ? 0 : this.cR.hashCode());
        return n3;
    }

    public BrowsePath toBrowsePath(NamespaceTable namespaceTable) {
        if (namespaceTable == null) {
            throw new IllegalArgumentException("The given namespace table cannot be null");
        }
        return new BrowsePath(this.cR.asNodeId(namespaceTable), this.cT.toRelativePath(namespaceTable));
    }

    public String toString() {
        return "UaBrowsePath [startingNode=" + this.cR + ", relativePath=" + this.cT + "]";
    }
}

