/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.AggregateCalculator;
import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.CodegenModel;
import com.prosysopc.ua.CodegenModelProvider;
import com.prosysopc.ua.OperationLimits;
import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.RegisteredClassesImpl;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.typedictionary.DataTypeDictionary;
import com.prosysopc.ua.typedictionary.DataTypeDictionaryComposition;
import com.prosysopc.ua.typedictionary.GeneratedDataTypeDictionary;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaApplication {
    private static Logger logger = LoggerFactory.getLogger(UaApplication.class);
    static final String cF = "5.3.0-181";
    private final AggregateCalculator cG = new AggregateCalculator();
    private CertificateValidator cH;
    private final RegisteredClasses cI = new RegisteredClassesImpl();
    private final DataTypeDictionaryComposition cJ = new DataTypeDictionaryComposition();
    private OperationLimits cK = OperationLimits.defaults();
    private boolean cL = true;

    @Deprecated
    public static String formatUri(Protocol protocol, String string, int n2, String string2) {
        if (string2 == null) {
            string2 = "";
        } else if (!string2.isEmpty() && string2.charAt(0) != '/') {
            string2 = "/" + string2;
        }
        return String.format("%s://%s:%d%s", new Object[]{protocol, string, n2, string2});
    }

    public static String getSdkVersion() {
        return cF;
    }

    @Deprecated
    public static String getVersion() {
        return "v" + UaApplication.getSdkVersion();
    }

    public abstract UaAddressSpace getAddressSpace();

    public AggregateCalculator getAggregateCalculator() {
        return this.cG;
    }

    public abstract ApplicationIdentity getApplicationIdentity();

    public CertificateValidator getCertificateValidator() {
        return this.cH;
    }

    public abstract EncoderContext getEncoderContext();

    public DataTypeDictionary getKnownDataTypeDictionary() {
        return this.cJ;
    }

    public NamespaceTable getNamespaceTable() {
        return this.getEncoderContext().getNamespaceTable();
    }

    public OperationLimits getOperationLimits() {
        return this.cK;
    }

    public RegisteredClasses getRegisteredClasses() {
        return this.cI;
    }

    public abstract ServerTable getServerTable();

    public boolean isAutoDiscoverCodegenModels() {
        return this.cL;
    }

    public void setAutoDiscoverCodegenModels(boolean bl) {
        this.cL = bl;
    }

    public void setCertificateValidator(CertificateValidator certificateValidator) {
        this.cH = certificateValidator;
    }

    public void setOperationLimits(OperationLimits operationLimits) {
        this.cK = operationLimits;
    }

    protected <T extends CodegenModelProvider> void registerAutoDiscoveredModels(Class<T> clazz) {
        logger.debug("Discovering CodegenModels from the classpath");
        ServiceLoader<CodegenModelProvider> serviceLoader = ServiceLoader.load(clazz);
        for (CodegenModelProvider codegenModelProvider : serviceLoader) {
            CodegenModel codegenModel = codegenModelProvider.get();
            logger.debug("Found {}", (Object)codegenModelProvider.getClass().getName());
            this.registerModelInternal(codegenModel);
        }
    }

    protected void registerModelInternal(CodegenModel codegenModel) {
        codegenModel.a(this::getRegisteredClasses, this::getEncoderContext);
        GeneratedDataTypeDictionary generatedDataTypeDictionary = codegenModel.getDataTypeDictionary();
        if (generatedDataTypeDictionary != null) {
            this.cJ.addGeneratedDataTypeDictionary(generatedDataTypeDictionary);
        }
    }

    protected StatusCode validateApplicationCertificate(ApplicationIdentity applicationIdentity) {
        if (this.cH != null) {
            return this.cH.validateCertificate(applicationIdentity.getApplicationDescription(), applicationIdentity.getCertificate());
        }
        return StatusCode.GOOD;
    }

    static {
        logger.info("Prosys OPC UA SDK for Java version {}", (Object)cF);
        logger.info("(c) Prosys OPC Ltd. <http://www.prosysopc.com>");
        if (logger.isDebugEnabled()) {
            try {
                Properties properties = (Properties)System.getProperties().clone();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    logger.debug("{}={}", entry.getKey(), entry.getValue());
                }
            }
            catch (Exception exception) {
                logger.warn("Could not debug-print system properties", (Throwable)exception);
            }
        }
    }

    public static enum Protocol {
        Http,
        OpcHttps,
        OpcTcp;


        public static Protocol parseProtocol(String string) {
            String string2 = string.toLowerCase(Locale.ROOT);
            if (string2.equals("http")) {
                return Http;
            }
            if (string2.equals("opc.tcp")) {
                return OpcTcp;
            }
            if (string2.equals("opc.https")) {
                return OpcHttps;
            }
            return Protocol.valueOf(string);
        }

        public String getTransportProfileUri() {
            if (this.equals((Object)Http)) {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
            }
            if (this.equals((Object)OpcHttps)) {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
            }
            return "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
        }

        public String toString() {
            if (this.equals((Object)Http)) {
                return "http";
            }
            if (this.equals((Object)OpcHttps)) {
                return "opc.https";
            }
            return "opc.tcp";
        }
    }

    public static enum DiagnosticMask {
        AdditionalInfo(4),
        InnerDiagnostics(16),
        InnerStatusCode(8),
        LocalizedText(2),
        SymbolicId(1);

        int value;

        private DiagnosticMask(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }
    }
}

