/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProUtil.points;

import com.vykon.vykonProUtil.points.BAbsEnumOverride;
import javax.baja.control.BEnumPoint;
import javax.baja.control.util.BEnumOverride;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAbsEnumWritableCommand
extends BComponent {
    public static final Property pointOrd = BAbsEnumWritableCommand.newProperty((int)64, (BValue)BOrd.NULL, null);
    public static final Property defaultTime = BAbsEnumWritableCommand.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    public static final Property facets = BAbsEnumWritableCommand.newProperty((int)7, (BValue)BFacets.makeEnum(), null);
    public static final Property fallback = BAbsEnumWritableCommand.newProperty((int)7, (BValue)BDynamicEnum.make((int)0), null);
    public static final Property out = BAbsEnumWritableCommand.newProperty((int)7, (BValue)BDynamicEnum.make((int)0), null);
    public static final Action emergencyOverride = BAbsEnumWritableCommand.newAction((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Action emergencyAuto = BAbsEnumWritableCommand.newAction((int)0, null);
    public static final Action override = BAbsEnumWritableCommand.newAction((int)256, (BValue)new BEnumOverride(), null);
    public static final Action auto = BAbsEnumWritableCommand.newAction((int)256, null);
    public static final Action absOverride = BAbsEnumWritableCommand.newAction((int)256, (BValue)new BAbsEnumOverride(), null);
    public static final Action set = BAbsEnumWritableCommand.newAction((int)256, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BAbsEnumWritableCommand.class);
    private static final BIcon icon = BIcon.std((String)"control/enumPoint.png");
    BEnumPoint slave = null;
    PointSubscriber pointSub = null;

    public BOrd getPointOrd() {
        return (BOrd)this.get(pointOrd);
    }

    public void setPointOrd(BOrd v) {
        this.set(pointOrd, (BValue)v, null);
    }

    public BRelTime getDefaultTime() {
        return (BRelTime)this.get(defaultTime);
    }

    public void setDefaultTime(BRelTime v) {
        this.set(defaultTime, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BDynamicEnum getFallback() {
        return (BDynamicEnum)this.get(fallback);
    }

    public void setFallback(BDynamicEnum v) {
        this.set(fallback, (BValue)v, null);
    }

    public BDynamicEnum getOut() {
        return (BDynamicEnum)this.get(out);
    }

    public void setOut(BDynamicEnum v) {
        this.set(out, (BValue)v, null);
    }

    public void emergencyOverride(BDynamicEnum arg) {
        this.invoke(emergencyOverride, (BValue)arg, null);
    }

    public void emergencyAuto() {
        this.invoke(emergencyAuto, null, null);
    }

    public void override(BEnumOverride arg) {
        this.invoke(override, (BValue)arg, null);
    }

    public void auto() {
        this.invoke(auto, null, null);
    }

    public void absOverride(BAbsEnumOverride arg) {
        this.invoke(absOverride, (BValue)arg, null);
    }

    public void set(BDynamicEnum arg) {
        this.invoke(set, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stopped() {
        this.pointSub.unsubscribeAll();
        this.pointSub = null;
    }

    public void stationStarted() {
        this.initPoint();
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop == pointOrd) {
            this.initPoint();
        }
    }

    private void initPoint() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getPointOrd() != BOrd.NULL) {
            try {
                this.slave = (BEnumPoint)this.getPointOrd().resolve((BObject)this).get();
                if (this.slave.get("fallback") != null) {
                    BDynamicEnum val = BDynamicEnum.make((BEnum)((BStatusEnum)this.slave.get("fallback")).getEnum());
                    this.setFallback(val);
                }
                this.setOut(this.slave.getOut().getValue());
                if (this.slave.get("facets") != null) {
                    this.setFacets((BFacets)this.slave.get("facets"));
                }
                this.pointSub = new PointSubscriber();
                this.pointSub.subscribe((BComponent)this.slave);
            }
            catch (Exception e) {
                System.out.println(this.getSlotPath() + " couldn't resolve point ord");
                System.out.println(e);
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == override || slot == emergencyOverride || slot == set || slot == absOverride) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doEmergencyOverride(BDynamicEnum v, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyOverride").asAction(), (BValue)v, cx);
    }

    public void doEmergencyAuto(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("emergencyAuto").asAction(), null, cx);
    }

    public void doOverride(BEnumOverride v, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("override").asAction(), (BValue)v, cx);
    }

    public void doAuto(Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("auto").asAction(), null, cx);
    }

    public void doAbsOverride(BAbsEnumOverride v, Context cx) {
        if (this.slave == null) {
            return;
        }
        BAbsTime current = Clock.time();
        BAbsTime end = BAbsTime.NULL;
        BDynamicEnum val = BDynamicEnum.make((int)0);
        if (v != null && v.get("expireTime") != null) {
            end = v.getExpireTime();
        }
        if (v != null && v.get("value") != null) {
            val = v.getValue();
        }
        long timeDiff = 0L;
        if (current != BAbsTime.NULL && end != BAbsTime.NULL) {
            timeDiff = v.getExpireTime().getMillis() - current.getMillis();
        }
        BRelTime dur = null;
        dur = timeDiff <= 0L ? BRelTime.make((long)0L) : BRelTime.make((long)timeDiff);
        BEnumOverride o = new BEnumOverride(dur, val);
        this.slave.invoke(this.slave.getSlot("override").asAction(), (BValue)o, cx);
    }

    public void doSet(BDynamicEnum v, Context cx) {
        if (this.slave == null) {
            return;
        }
        this.slave.invoke(this.slave.getSlot("set").asAction(), (BValue)v, cx);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == set) {
            return this.getFallback();
        }
        if (action == override) {
            BEnumOverride o = new BEnumOverride(this.getOut());
            o.setMaxOverrideDuration(this.getMaxOverrideDuration());
            return o;
        }
        if (action == emergencyOverride) {
            return this.getOut();
        }
        if (action == absOverride) {
            BAbsTime end = Clock.time().add(this.getDefaultTime());
            BAbsEnumOverride o = new BAbsEnumOverride(end, this.getOut());
            o.setMaxOverrideDuration(this.getMaxOverrideDuration());
            return o;
        }
        return super.getActionParameterDefault(action);
    }

    BRelTime getMaxOverrideDuration() {
        BRelTime maxDuration = BRelTime.DEFAULT;
        try {
            BFacets facets = this.getFacets();
            BObject obj = facets.get("maxOverrideDuration");
            if (obj instanceof BRelTime) {
                maxDuration = (BRelTime)obj;
            } else {
                BStation station = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)this);
                if (!station.isRunning()) {
                    station.loadSlots();
                    station.lease();
                }
                facets = (BFacets)station.get("sysInfo");
                maxDuration = (BRelTime)facets.get("maxOverrideDuration", (BObject)maxDuration);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxDuration;
    }

    public BIcon getIcon() {
        return icon;
    }

    private class PointSubscriber
    extends Subscriber {
        private PointSubscriber() {
        }

        public void event(BComponentEvent event) {
            int id = event.getId();
            if (id == 0) {
                if (event.getSlotName().equals("fallback")) {
                    BDynamicEnum val = BDynamicEnum.make((BEnum)((BStatusEnum)BAbsEnumWritableCommand.this.slave.get("fallback")).getEnum());
                    BAbsEnumWritableCommand.this.setFallback(val);
                }
                if (event.getSlotName().equals("out")) {
                    BAbsEnumWritableCommand.this.setOut(BAbsEnumWritableCommand.this.slave.getOut().getValue());
                }
                if (event.getSlotName().equals("facets")) {
                    BAbsEnumWritableCommand.this.setFacets(BAbsEnumWritableCommand.this.slave.getFacets());
                }
            }
        }
    }
}

