/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProUtil.job;

import com.vykon.vykonPro.util.BVykonProService;
import com.vykon.vykonProUtil.job.BGlobalJob;
import javax.baja.control.BStringWritable;
import javax.baja.control.util.BStringOverride;
import javax.baja.job.JobCancelException;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BGlobalStringCommandJob
extends BGlobalJob {
    public static final Type TYPE = Sys.loadType(BGlobalStringCommandJob.class);
    private static final int BATCH_SIZE = 20;
    BComponent[] points;
    int action;
    BValue value;
    boolean canceled = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BGlobalStringCommandJob() {
    }

    public BGlobalStringCommandJob(BComponent[] points, int action, BValue value) {
        this.points = points;
        this.action = action;
        this.value = value;
    }

    @Override
    protected void postAsync() {
        if (BVykonProService.getInstance() == null) {
            System.out.println("invoking this action requires the vykonProService in the station, please add the vykonProService to the services container of the station.");
        } else {
            BVykonProService.getInstance().getWorker().post((Runnable)this);
        }
    }

    @Override
    public void run(Context cx) throws Exception {
        if (!this.isAlive()) {
            return;
        }
        if (this.canceled) {
            throw new JobCancelException();
        }
        boolean success = false;
        this.log().start("Starting to process global string command");
        int iteration = 0;
        int total = this.points.length;
        if (total <= 0) {
            total = 1;
        }
        if (this.points.length > 0) {
            BComponent.lease((BComponent[])this.points, (int)1);
            for (int i = 0; i < this.points.length; ++i) {
                if (iteration % 20 == 0) {
                    this.progress((int)((float)iteration / (float)total * 100.0f));
                }
                ++iteration;
                try {
                    if (this.points[i] instanceof BStringWritable) {
                        BStringWritable writable = (BStringWritable)this.points[i];
                        switch (this.action) {
                            case 0: {
                                writable.emergencyOverride((BString)this.value);
                                this.log().success("emergency override " + this.points[i].getSlotPath() + " to " + this.value);
                                break;
                            }
                            case 1: {
                                writable.emergencyAuto();
                                this.log().success("emergency auto " + this.points[i].getSlotPath());
                                break;
                            }
                            case 2: {
                                writable.override((BStringOverride)this.value);
                                this.log().success("override " + this.points[i].getSlotPath() + " to " + this.value);
                                break;
                            }
                            case 3: {
                                writable.auto();
                                this.log().success("auto " + this.points[i].getSlotPath());
                                break;
                            }
                            case 4: {
                                writable.set((BString)this.value);
                                this.log().success("set " + this.points[i].getSlotPath() + " to " + this.value);
                            }
                        }
                    } else {
                        switch (this.action) {
                            case 0: {
                                if (this.points[i].get("emergencyOverride") != null) {
                                    this.points[i].invoke(this.points[i].getSlot("emergencyOverride").asAction(), (BValue)((BString)this.value));
                                    this.log().success("emergency override " + this.points[i].getSlotPath() + " to " + this.value);
                                    break;
                                }
                                if (this.points[i].get("Emergency$20Override") != null) {
                                    this.points[i].invoke(this.points[i].getSlot("Emergency$20Override").asAction(), (BValue)((BString)this.value));
                                    this.log().success("emergency override " + this.points[i].getSlotPath() + " to " + this.value);
                                    break;
                                }
                                this.log().failed(this.points[i].getSlotPath() + " doesn't have an emergencyOverride action");
                                break;
                            }
                            case 1: {
                                if (this.points[i].get("emergencyAuto") != null) {
                                    this.points[i].invoke(this.points[i].getSlot("emergencyAuto").asAction(), null);
                                    this.log().success("emergency auto " + this.points[i].getSlotPath());
                                    break;
                                }
                                if (this.points[i].get("Emergency$20Auto") != null) {
                                    this.points[i].invoke(this.points[i].getSlot("Emergency$20Auto").asAction(), null);
                                    this.log().success("emergency override " + this.points[i].getSlotPath() + " to " + this.value);
                                    break;
                                }
                                this.log().failed(this.points[i].getSlotPath() + " doesn't have an emergencyOverride action");
                                break;
                            }
                            case 2: {
                                if (this.points[i].get("override") != null) {
                                    this.points[i].invoke(this.points[i].getSlot("override").asAction(), (BValue)((BStringOverride)this.value));
                                    this.log().success("override " + this.points[i].getSlotPath() + " to " + this.value);
                                    break;
                                }
                                if (this.points[i].get("Override") != null) {
                                    this.points[i].invoke(this.points[i].getSlot("Override").asAction(), (BValue)((BStringOverride)this.value));
                                    this.log().success("override " + this.points[i].getSlotPath() + " to " + this.value);
                                    break;
                                }
                                this.log().failed(this.points[i].getSlotPath() + " doesn't have an override action");
                                break;
                            }
                            case 3: {
                                if (this.points[i].get("auto") != null) {
                                    this.points[i].invoke(this.points[i].getSlot("auto").asAction(), null);
                                    this.log().success("auto " + this.points[i].getSlotPath());
                                    break;
                                }
                                if (this.points[i].get("Auto") != null) {
                                    this.points[i].invoke(this.points[i].getSlot("Auto").asAction(), null);
                                    this.log().success("auto " + this.points[i].getSlotPath());
                                    break;
                                }
                                this.log().failed(this.points[i].getSlotPath() + " doesn't have an auto action");
                                break;
                            }
                            case 4: {
                                if (this.points[i].get("set") != null) {
                                    this.points[i].invoke(this.points[i].getSlot("set").asAction(), (BValue)((BString)this.value));
                                    this.log().success("set " + this.points[i].getSlotPath() + " to " + this.value);
                                    break;
                                }
                                if (this.points[i].get("Set") != null) {
                                    this.points[i].invoke(this.points[i].getSlot("Set").asAction(), (BValue)((BString)this.value));
                                    this.log().success("set " + this.points[i].getSlotPath() + " to " + this.value);
                                    break;
                                }
                                this.log().failed(this.points[i].getSlotPath() + " doesn't have a set action");
                            }
                        }
                    }
                    success = true;
                    continue;
                }
                catch (ActionInvokeException e) {
                    this.log().failed(this.points[i].getSlotPath() + " could not be invoked");
                }
            }
        } else {
            this.log().failed("Didn't find any points");
        }
        if (this.canceled) {
            throw new JobCancelException();
        }
        if (success) {
            this.log().success("Completed processing global commands");
        } else {
            this.log().failed("Encountered Problems processing global commands");
        }
    }
}

