/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSerial.uc;

import com.tridium.platSerial.npsdk.BSerialPortNpsdk;
import com.tridium.platSerial.npsdk.BSerialPortPlatformServiceNpsdk;
import com.tridium.sys.Nre;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSerialPortPlatformServiceUbuntuCore
extends BSerialPortPlatformServiceNpsdk {
    @Generated
    public static final Type TYPE = Sys.loadType(BSerialPortPlatformServiceUbuntuCore.class);
    private static final String U_MAP_FILE_PATH = "/tmp/u_map";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isValidPlatform() {
        String serialLibPath = Nre.getNiagaraHome() + File.separator + "bin" + File.separator + "libserialnpsdk.so";
        if (!AccessController.doPrivileged(() -> new File(serialLibPath).exists()).booleanValue()) {
            return false;
        }
        return AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.use.snap.serial")) != false;
    }

    @Override
    protected String[] loadPortIdentifiers() {
        return this.loadPortIdentifiers(U_MAP_FILE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] loadPortIdentifiers(String filePath) {
        BufferedReader br;
        this.loadLibraries();
        log.fine("Loading comm port identifiers...");
        try {
            br = AccessController.doPrivileged(() -> new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), StandardCharsets.UTF_8)));
        }
        catch (PrivilegedActionException e) {
            log.severe("Unable to access serial port map");
            return null;
        }
        if (br == null) {
            log.severe("Unable to read serial port map file");
            return null;
        }
        ArrayList<String> slotNamesAR = new ArrayList<String>();
        ArrayList<BSerialPortNpsdk> portAR = new ArrayList<BSerialPortNpsdk>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("COM")) continue;
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() != 2) {
                    log.severe("Unexpected u_map format, cannot enumerate serial ports");
                    String[] stringArray = null;
                    return stringArray;
                }
                String name = st.nextToken();
                String osName = st.nextToken();
                int ndx = Integer.parseInt(name.substring("COM".length()));
                portAR.add(new BSerialPortNpsdk(osName, ndx));
                slotNamesAR.add("COM" + ndx);
            }
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, "Exception occurred parsing u_map file, cannot enumerate serial ports", ioe);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        BSerialPortNpsdk[] ports = portAR.toArray(new BSerialPortNpsdk[0]);
        Object[] slotNames = slotNamesAR.toArray(new String[0]);
        SortUtil.sort((Object[])slotNames, (Object[])ports, (Comparator)this.SERIAL_PORT_COMPARATOR);
        for (int i = 0; i < slotNames.length; ++i) {
            this.add(SlotPath.escape((String)slotNames[i]), (BValue)ports[i], 3);
        }
        return slotNames;
    }
}

