/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.forge.javafileuploader;

import com.tridium.forge.azure.AzureBlobOutputStream;
import com.tridium.forge.fileuploadclient.FileConfig;
import com.tridium.forge.fileuploadclient.IUploadHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUploadHandler
implements IUploadHandler {
    private final Logger logger;
    private static final int DEFAULT_BLOCK_SIZE = 0x400000;
    private static final int FILE_READ_BUFFER_SIZE = 8192;
    private static final String MIME_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";

    public FileUploadHandler(Logger logger) {
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean uploadDataToBlob(FileConfig fileConfig, String sasUrl, Map<String, String> connectionDetails) throws URISyntaxException, IOException {
        this.logger.fine(() -> String.format("Uploading file data from file %s to blob storage using URL %s and connection details %s", fileConfig.getFileName(), AzureBlobOutputStream.safeSig(sasUrl), AzureBlobOutputStream.safeHdrs(connectionDetails)));
        Map<String, Object> map = Collections.emptyMap();
        Consumer<OutputStream> fileData = FileUploadHandler.fileToOutputStreamFunc(fileConfig.getFileName());
        try (AzureBlobOutputStream azureOut = new AzureBlobOutputStream(sasUrl, 0x400000, MIME_TYPE_APPLICATION_OCTET_STREAM, map, connectionDetails);){
            AccessController.doPrivileged(() -> {
                fileData.accept(azureOut);
                return null;
            });
            boolean bl = true;
            return bl;
        }
        catch (PrivilegedActionException ex) {
            this.logger.log(Level.WARNING, String.format("Error uploading file %s", fileConfig.getFileName()), this.logger.isLoggable(Level.FINE) ? ex.getCause() : null);
            return false;
        }
    }

    protected static Consumer<OutputStream> fileToOutputStreamFunc(String fileName) {
        return outStream -> {
            try (FileInputStream inStream = new FileInputStream(fileName);){
                int length;
                byte[] buf = new byte[8192];
                while ((length = inStream.read(buf)) != -1) {
                    outStream.write(buf, 0, length);
                }
                outStream.flush();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        };
    }
}

